/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.ITupleSet;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import java.io.PrintStream;

public class TupleSet
implements ITupleSet {
    private int used;
    private Tuple[] tuplesArray = emptyArray;
    private static Tuple[] emptyArray = new Tuple[0];

    TupleSet() {
        this.clear();
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public void clear() {
        this.used = 0;
    }

    public boolean intersect(TupleSet s) {
        return this.filter(s.asArray());
    }

    public boolean filter(Tuple[] a) {
        Tuple[] oldTuplesArray = this.tuplesArray;
        int oldUsed = this.used;
        this.clear();
        int i = 0;
        while (i < oldUsed) {
            int j = 0;
            while (j < a.length) {
                if (oldTuplesArray[i] == a[j]) {
                    this.insert(a[j]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return oldUsed != this.used;
    }

    public boolean insert(TupleSet s) {
        return this.insert(s.asArray());
    }

    public boolean insert(Tuple[] ts) {
        boolean res = false;
        if (ts != null) {
            int i = 0;
            while (i < ts.length) {
                res |= this.insert(ts[i]);
                ++i;
            }
        }
        return res;
    }

    public boolean insert(Tuple t) {
        int i = 0;
        while (i < this.used) {
            if (t == this.tuplesArray[i]) {
                return false;
            }
            ++i;
        }
        if (this.used == this.tuplesArray.length) {
            Tuple[] newTuplesArray = new Tuple[this.used + 20];
            System.arraycopy(this.tuplesArray, 0, newTuplesArray, 0, this.used);
            this.tuplesArray = newTuplesArray;
        }
        this.tuplesArray[this.used] = t;
        ++this.used;
        return true;
    }

    final Tuple[] getStorage() {
        return this.tuplesArray;
    }

    final int getUsedCount() {
        return this.used;
    }

    public Tuple[] asArray() {
        if (this.used != this.tuplesArray.length) {
            Tuple[] ta = new Tuple[this.used];
            System.arraycopy(this.tuplesArray, 0, ta, 0, this.used);
            this.tuplesArray = ta;
        }
        return this.tuplesArray;
    }

    public ITuple[] getTuples() {
        return this.asArray();
    }

    public void print(PrintStream out) {
        out.print(" [");
        int i = 0;
        while (i < this.used) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(this.tuplesArray[i].getTupleId());
            ++i;
        }
        out.println("]");
    }
}

