/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import java.io.PrintStream;

public class TempVariable
extends Var
implements ITempVariable {
    private Tuple tuple;
    private boolean usedAsOperand;

    public TempVariable(int type, Tuple source, int idx) {
        super(type, idx);
        this.tuple = source;
        this.usedAsOperand = false;
    }

    public int getVariableKind() {
        return 1;
    }

    public boolean isTemp() {
        return true;
    }

    public boolean isConstant() {
        if (this.tuple == null) {
            return false;
        }
        AstObject astObj = this.tuple.getAstObject();
        if (astObj == null || !(astObj instanceof AstExpression)) {
            return false;
        }
        return ((AstExpression)astObj).isConstant();
    }

    public final ITuple sourceTuple() {
        return this.tuple;
    }

    public void printBrief(PrintStream out) {
        out.print("Temporary for tuple " + this.tuple.getTupleId() + "used = " + this.usedAsOperand);
    }

    public boolean used() {
        return this.usedAsOperand;
    }

    public void markAsUsed() {
        this.usedAsOperand = true;
        this.tuple.setAsUsed();
    }
}

