/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstAssertStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstThrowStatement;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.flowgraph.ExceptionHandlingArea;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.CallTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NewTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ThrowTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.VarArgsTuple;
import java.util.AbstractCollection;
import java.util.HashSet;

public class MethodExceptionHandlingArea
extends ExceptionHandlingArea {
    private Method theMethod;

    public MethodExceptionHandlingArea(Method theMethod) {
        super(null);
        this.theMethod = theMethod;
    }

    public AstTypeReference[] computeRaisedExceptions() {
        int nTuples = this.theMethod.getDFG().enumerateTuples();
        HashSet<Object> set = new HashSet<Object>();
        ExceptionHandlingArea[] areaMap = new ExceptionHandlingArea[nTuples];
        MethodExceptionHandlingArea.buildAreaMap(this, areaMap);
        ITuple t = this.getFirst();
        while (t != null) {
            Method m;
            Object tr;
            if (t instanceof ThrowTuple) {
                AstObject ao = t.getAstObject();
                if (ao instanceof AstThrowStatement) {
                    AstThrowStatement a = (AstThrowStatement)ao;
                    tr = a.getExpression().getRuntimeType();
                } else {
                    AstAssertStatement as = (AstAssertStatement)ao;
                    tr = as.getReferencedElement().getDeclaringType();
                }
                if (areaMap[t.getTupleId()].findHandler((AstTypeReference)tr) == null) {
                    set.add(tr);
                }
            } else if ((t instanceof CallTuple || t instanceof NewTuple) && (m = ((VarArgsTuple)t).getCalledMethod()) != null && (tr = m.getExceptionsDeclared()) != null) {
                int i = 0;
                while (i < ((AstTypeReference[])tr).length) {
                    if (areaMap[t.getTupleId()].findHandler(tr[i]) == null) {
                        set.add(tr[i]);
                    }
                    ++i;
                }
            }
            t = t.getNext();
        }
        return ((AbstractCollection)set).toArray(new AstTypeReference[set.size()]);
    }

    private static void buildAreaMap(ExceptionHandlingArea area, ExceptionHandlingArea[] areaMap) {
        ITuple t = area.getFirst();
        while (t != null) {
            areaMap[t.getTupleId()] = area;
            if (t == area.getLast()) break;
            t = t.getNext();
        }
        ExceptionHandlingArea eha = area.getDown();
        while (eha != null) {
            MethodExceptionHandlingArea.buildAreaMap(eha, areaMap);
            eha = eha.getNext();
        }
    }

    public Method getMethod() {
        return this.theMethod;
    }
}

