/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.internal.dataflow.flowgraph.ExceptionHandlingArea;
import com.togethersoft.sca.internal.dataflow.flowgraph.MethodExceptionHandlingArea;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;

public class JavaTry
extends ExceptionHandlingArea {
    private LabelTuple[] handlers;
    private LabelTuple finallyHandler;
    private AstTypeReference[] exceptionTypes;

    JavaTry(ExceptionHandlingArea up, LabelTuple[] labels, AstTypeReference[] exceptionTypes) {
        super(up);
        this.exceptionTypes = exceptionTypes;
        this.handlers = labels;
    }

    LabelTuple findHandler(AstTypeReference exceptionType) {
        int i = 0;
        while (i < this.exceptionTypes.length) {
            if (exceptionType.isDerivedFrom(this.exceptionTypes[i])) {
                return this.handlers[i];
            }
            ++i;
        }
        ExceptionHandlingArea uplevel = this.getUp();
        if (uplevel != null) {
            return uplevel.findHandler(exceptionType);
        }
        return null;
    }

    LabelTuple[] findErrorHandler() {
        ExceptionHandlingArea eha = this.getUp();
        while (!(eha instanceof MethodExceptionHandlingArea)) {
            eha = eha.getUp();
        }
        MethodExceptionHandlingArea meha = (MethodExceptionHandlingArea)eha;
        AstType errorType = meha.getMethod().getProject().getAnalyzer().getModel().findType("java/lang/RuntimeException");
        if (errorType == null) {
            return super.findErrorHandler();
        }
        int i = 0;
        while (i < this.handlers.length) {
            if (this.exceptionTypes[i].isDerivedFrom(errorType)) {
                return new LabelTuple[]{this.handlers[i]};
            }
            ++i;
        }
        if (this.finallyHandler != null) {
            return new LabelTuple[]{this.finallyHandler};
        }
        return this.getUp().findErrorHandler();
    }

    void refineArea() {
        int i = 0;
        while (i < this.handlers.length) {
            this.handlers[i] = this.handlers[i].getRedirection();
            ++i;
        }
        super.refineArea();
    }

    void setupFinallyHandler(LabelTuple handler) {
        this.finallyHandler = handler;
    }
}

