/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.IJavaLoop;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import java.io.PrintStream;

public class JavaLoop
implements IJavaLoop {
    private static final int valTrue = 1;
    private static final int valFalse = 2;
    private static final int valBoth = 3;
    private boolean foreverLoop = false;
    private boolean zeroIterationsLoop = false;
    private boolean executeOnceLoop;
    private ITuple bodyStart;
    private ITuple bodyEnd;
    private ITuple conditionStart;
    private ITuple conditionEnd;
    private AstStatement loopStmt;
    private IJavaLoop[] nested;
    private JavaLoop top;

    public boolean entryIsReachable() {
        IBasicBlock bb = this.bodyStart.basicBlock();
        IBasicBlock bb1 = this.conditionStart.basicBlock();
        return !(bb != null && !bb.isReachable() || bb1 != null && !bb1.isReachable());
    }

    public boolean isForeverLoop() {
        return this.foreverLoop;
    }

    public boolean isZeroIterationsLoop() {
        return this.zeroIterationsLoop;
    }

    public boolean isExecuteOnceLoop() {
        return this.executeOnceLoop;
    }

    public IJavaLoop[] subLoops() {
        return this.nested;
    }

    public AstStatement stmt() {
        return this.loopStmt;
    }

    public void check() {
        if (this.nested != null) {
            int i = 0;
            while (i < this.nested.length) {
                this.nested[i].check();
                ++i;
            }
        }
        if (!this.hasBranchesOutsideOfBody()) {
            int cKind = this.conditionKind();
            boolean bl = this.foreverLoop = cKind == 1;
            if (this.loopStmt instanceof AstDoStatement) {
                this.executeOnceLoop = cKind == 2;
                this.zeroIterationsLoop = false;
            } else {
                this.zeroIterationsLoop = cKind == 2;
                this.executeOnceLoop = false;
            }
        }
    }

    private final int conditionKind() {
        IBasicBlock bb = this.bodyStart.basicBlock();
        if (bb != null && !bb.isReachable()) {
            return 2;
        }
        boolean outside = false;
        boolean goesBack = false;
        int bodyStartId = this.bodyStart.getTupleId();
        int bodyEndId = this.bodyEnd.getTupleId();
        int conditionStartId = this.conditionStart.getTupleId();
        int conditionEndId = this.conditionEnd.getTupleId();
        ITuple t = this.conditionStart;
        while (true) {
            ITuple[] targets;
            if ((targets = t.targets()) != null) {
                int targetId;
                int code = t.getCode();
                if (code == 41 && t.operandValues() != null && t.operandValue(0) instanceof BooleanConstant) {
                    int idx = t.operandValue(0) == BooleanConstant.forTrue() ? 0 : 1;
                    targetId = targets[idx].getTupleId();
                    if (targetId < conditionStartId) {
                        goesBack = true;
                    }
                    if (!(targetId >= bodyStartId && targetId <= bodyEndId || targetId >= conditionStartId && targetId <= conditionEndId)) {
                        outside = true;
                    }
                } else {
                    int i = 0;
                    while (i < targets.length) {
                        targetId = targets[i].getTupleId();
                        if (targetId < conditionStartId) {
                            goesBack = true;
                        }
                        if (!(targetId >= bodyStartId && targetId <= bodyEndId || targetId >= conditionStartId && targetId <= conditionEndId)) {
                            outside = true;
                        }
                        ++i;
                    }
                }
            }
            if (t == this.conditionEnd) break;
            t = t.getNext();
        }
        if (outside) {
            if (!goesBack && this.loopStmt instanceof AstDoStatement) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    private final boolean hasBranchesOutsideOfBody() {
        ITuple t = this.bodyStart;
        int bodyStartId = this.bodyStart.getTupleId();
        int bodyEndId = this.bodyEnd.getTupleId();
        int conditionStartId = this.conditionStart.getTupleId();
        int conditionEndId = this.conditionEnd.getTupleId();
        while (true) {
            IBasicBlock bb;
            if ((bb = t.basicBlock()) != null && bb.isReachable()) {
                if (t.getCode() == 43) {
                    return true;
                }
                ITuple[] targets = t.targets();
                if (targets != null) {
                    int i = 0;
                    while (i < targets.length) {
                        int targetId = targets[i].getTupleId();
                        if (!(targetId >= bodyStartId && targetId <= bodyEndId || targetId >= conditionStartId && targetId <= conditionEndId)) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            if (t == this.bodyEnd) break;
            t = t.getNext();
        }
        return false;
    }

    JavaLoop(JavaLoop top, ITuple bodyStart, ITuple bodyEnd, ITuple conditionStart, ITuple conditionEnd, AstStatement loopStmt) {
        this.bodyStart = bodyStart;
        this.bodyEnd = bodyEnd;
        this.conditionStart = conditionStart;
        this.conditionEnd = conditionEnd;
        this.loopStmt = loopStmt;
        this.nested = null;
        this.top = top;
        if (top != null) {
            top.pushNestedLoop(this);
        }
    }

    private final ITuple labelBack(ITuple t) {
        if (t instanceof LabelTuple) {
            LabelTuple t1 = ((LabelTuple)t).getRedirection();
            if (t1 == null) {
                return t;
            }
            return t1;
        }
        return t;
    }

    void refine() {
        this.conditionStart = this.labelBack(this.conditionStart);
        this.conditionEnd = this.labelBack(this.conditionEnd);
        this.bodyStart = this.labelBack(this.bodyStart);
        this.bodyEnd = this.labelBack(this.bodyEnd);
        if (this.nested != null) {
            int i = 0;
            while (i < this.nested.length) {
                ((JavaLoop)this.nested[i]).refine();
                ++i;
            }
        }
    }

    public void print(PrintStream out) {
        out.println("JavaLoop: bodyStart = " + this.bodyStart.getTupleId() + " bodyEnd = " + this.bodyEnd.getTupleId() + " conditionStart = " + this.conditionStart.getTupleId() + " conditionEnd = " + this.conditionEnd.getTupleId());
        out.println("\tforeverLoop = " + this.foreverLoop + " zeroIterationsLoop " + this.zeroIterationsLoop);
        if (this.nested != null) {
            out.println("nested loops:");
            int i = 0;
            while (i < this.nested.length) {
                this.nested[i].print(out);
                ++i;
            }
            out.println("end nested loops:");
        }
    }

    private void pushNestedLoop(JavaLoop loop) {
        if (this.nested == null) {
            this.nested = new IJavaLoop[1];
        } else {
            IJavaLoop[] newNested = new IJavaLoop[this.nested.length + 1];
            int i = 0;
            while (i < this.nested.length) {
                newNested[i] = this.nested[i];
                ++i;
            }
            this.nested = newNested;
        }
        this.nested[this.nested.length - 1] = loop;
    }

    JavaLoop getTop() {
        return this.top;
    }

    final void setBodyEnd(ITuple tp) {
        this.bodyEnd = tp;
    }
}

