/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;

public class ExceptionHandlingArea {
    private Tuple first;
    private Tuple last;
    private ExceptionHandlingArea up;
    private ExceptionHandlingArea next;
    private ExceptionHandlingArea down;
    protected static LabelTuple[] emptyArray = new LabelTuple[0];

    protected ExceptionHandlingArea(ExceptionHandlingArea up) {
        if (up != null) {
            this.up = up;
            this.next = up.down;
            up.down = this;
        }
    }

    final void setArea(Tuple first, Tuple last) {
        this.first = first;
        this.last = last;
    }

    final ExceptionHandlingArea getUp() {
        return this.up;
    }

    final ExceptionHandlingArea getNext() {
        return this.next;
    }

    final ExceptionHandlingArea getDown() {
        return this.down;
    }

    final Tuple getFirst() {
        return this.first;
    }

    final Tuple getLast() {
        return this.last;
    }

    LabelTuple findHandler(AstTypeReference exceptionType) {
        return null;
    }

    LabelTuple[] findErrorHandler() {
        return emptyArray;
    }

    void refineArea() {
        this.first = ExceptionHandlingArea.findRedirection(this.first);
        this.last = ExceptionHandlingArea.findRedirection(this.last);
        ExceptionHandlingArea a = this.down;
        while (a != null) {
            a.refineArea();
            a = a.next;
        }
    }

    boolean errorsCatched() {
        return false;
    }

    protected static Tuple findRedirection(Tuple t) {
        if (t instanceof LabelTuple) {
            return ((LabelTuple)t).getRedirection();
        }
        return t;
    }
}

