/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.IDataFlowGraph;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.core.ErrorLog;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.MethodSet;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.ControlFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.MemberVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.ParameterVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.TempVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.TupleSet;
import com.togethersoft.sca.internal.dataflow.flowgraph.TupleWebs;
import com.togethersoft.sca.internal.dataflow.flowgraph.UserVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.AssignmentTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.CallTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NewTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ReturnTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.VarArgsTuple;
import com.togethersoft.sca.internal.dataflow.fsa.FSAAnalyzer;
import com.togethersoft.sca.internal.dataflow.fsa.NullSuspectsDetector;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;
import java.io.PrintStream;
import java.util.BitSet;

public class DataFlowGraph
extends ControlFlowGraph
implements IDataFlowGraph {
    private boolean lastVPres;
    private IValueDomain[] oldOut;
    private int lastBuiltin;
    private TupleSet[][] webs;

    public static void doGlobalDataflowAnalysis(Project theProject) {
        Method.markUnreachableMethods(theProject.methodList());
        Method.detectForeverRecursiveLoops(theProject);
        Method.findMethodsGeneratingSideEffects(theProject);
        Method.computeFieldUsage(theProject);
    }

    public void doLocalDataflowAnalysis() {
        this.markUsedTemporaries();
        this.doDeadAssignmentDetection();
        this.doCopyPropagation();
        if (this.doValuePropagation()) {
            this.detectForeverLoops();
        }
        this.computeReachingDefinitions();
        this.detectAlwaysExecutedCalls();
        this.checkForImmediateSideEffects();
        this.computeUninitializedDataAccess();
        this.collectSuspiciousNullPointers();
        this.setupResultValueEstimation();
        this.setupParameterValuesEstimation();
        this.cleanup();
    }

    public void doLocalDataflowAnalysis1() {
        this.markUsedTemporaries();
        this.doDeadAssignmentDetection();
        this.doCopyPropagation();
    }

    public void doLocalDataflowAnalysis2() {
        this.lastVPres = this.doValuePropagation();
        this.setupResultValueEstimation();
        this.setupParameterValuesEstimation();
    }

    public void doLocalDataflowAnalysis3() {
        if (this.lastVPres) {
            this.detectForeverLoops();
        }
        this.computeReachingDefinitions();
        this.detectAlwaysExecutedCalls();
        this.checkForImmediateSideEffects();
        this.computeUninitializedDataAccess();
        this.collectSuspiciousNullPointers();
        this.cleanup();
    }

    private void setupParameterValuesEstimation() {
        ITuple t = this.tuples;
        while (t != null) {
            if ((t instanceof CallTuple || t instanceof NewTuple) && !t.isAssertGenerated()) {
                VarArgsTuple vat = (VarArgsTuple)t;
                vat.propagateInterprocedural();
            }
            t = t.getNext();
        }
    }

    private void setupResultValueEstimation() {
        UserVariable resultVar = this.valueTable.getResultVar();
        if (resultVar == null) {
            return;
        }
        IBasicBlock b = this.basicBlocks;
        while (b.getNext() != null) {
            b = b.getNext();
        }
        IValueDomain rvd = b.out[resultVar.getVarIndex()];
        this.methodBlock.setResultDomain(rvd);
    }

    private void cleanup() {
        this.oldOut = null;
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            b.cleanup();
            b = b.getNextBlock();
        }
    }

    public ITuple[] detectRecursiveCalls(Method m) {
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            b.visited = false;
            b = b.getNextBlock();
        }
        if (this.basicBlocks != null) {
            return this.basicBlocks.detectRecursiveCalls(m);
        }
        return null;
    }

    private void computeUninitializedDataAccess() {
        if (this.basicBlocks == null) {
            return;
        }
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            b.initForUninitializedDetection();
            b = b.getNextBlock();
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            BasicBlock b2 = this.basicBlocks;
            while (b2 != null) {
                IBasicBlock[] s = b2.getSuccessors();
                Object oldIn = b2.vdefIn.clone();
                b2.vdefIn.xor(b2.vdefIn);
                if (s != null) {
                    int i = 0;
                    while (i != s.length) {
                        BasicBlock pb = (BasicBlock)s[i];
                        b2.vdefIn.or(pb.vdefIn);
                        ++i;
                    }
                }
                b2.vdefIn.andNot(b2.vdefGen);
                b2.vdefIn.or(b2.vdefUse);
                if (!b2.vdefIn.equals(oldIn)) {
                    changed = true;
                }
                b2 = b2.getNextBlock();
            }
        }
        Var[] v = this.valueTable.getVariables();
        BitSet b3 = this.basicBlocks.vdefIn;
        int i = 0;
        while (i < v.length) {
            if (v[i] instanceof MemberVariable) {
                MemberVariable mv = (MemberVariable)v[i];
                this.methodBlock.pushFieldReference(mv.fieldUnit());
                if (b3.get(v[i].getVarIndex())) {
                    mv.fieldUnit().markAsUsed();
                }
            }
            ++i;
        }
    }

    private void checkForImmediateSideEffects() {
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            if (b.isReachable()) {
                ITuple t;
                ITuple tNext = b.getFirstTuple();
                do {
                    IVar res;
                    int varKind;
                    t = tNext;
                    tNext = t.getNext();
                    if (!(t instanceof ExprTuple) || (varKind = (res = ((ExprTuple)t).result()).getVariableKind()) != 6 && varKind != 7 && varKind != 1) continue;
                    this.methodBlock.setAsProducingSideEffect();
                    return;
                } while (t != b.getLastTuple());
            }
            b = b.getNextBlock();
        }
    }

    private void computeLocallyMadeCalls() {
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            ITuple t;
            ITuple tNext = b.getFirstTuple();
            b.methGen = new MethodSet();
            do {
                t = tNext;
                tNext = t.getNext();
                if (!(t instanceof CallTuple) && !(t instanceof NewTuple)) continue;
                Method m = ((VarArgsTuple)t).getCalledMethod();
                b.methGen.add(m);
            } while (t != b.getLastTuple());
            b.methOut = b.methGen;
            b = b.getNextBlock();
        }
    }

    public void detectAlwaysExecutedCalls() {
        int i;
        this.computeLocallyMadeCalls();
        boolean changed = true;
        while (changed) {
            changed = false;
            BasicBlock b = this.basicBlocks;
            while (b != null) {
                IBasicBlock[] preds = b.getPredecessors();
                if (preds != null && preds.length != 0) {
                    MethodSet bIn = new MethodSet(((BasicBlock)preds[0]).methOut);
                    i = 1;
                    while (i != preds.length) {
                        BasicBlock pb = (BasicBlock)preds[i];
                        bIn.intersect(pb.methOut);
                        ++i;
                    }
                    bIn.union(b.methGen);
                    changed |= !MethodSet.equivalent(bIn, b.methOut);
                    b.methOut = bIn;
                }
                b = b.getNextBlock();
            }
        }
        MethodSet res = null;
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            if (b.getLastTuple() instanceof ReturnTuple || b.getNext() == null) {
                if (res == null) {
                    res = new MethodSet(b.methOut);
                } else {
                    res.intersect(b.methOut);
                }
            }
            b = b.getNextBlock();
        }
        if (res != null) {
            Method[] m = res.asVector();
            i = 0;
            while (i != m.length) {
                this.methodBlock.pushAlwaysCallee(m[i]);
                ++i;
            }
        }
    }

    private void collectSuspiciousNullPointers() {
        FSAAnalyzer a = new FSAAnalyzer(new NullSuspectsDetector());
        a.processMethod(this.methodBlock);
    }

    public void collectDataForGlobalDataflow(Method meth) {
        ITuple t = this.tuples;
        while (t != null) {
            Method[] m;
            if ((t instanceof CallTuple || t instanceof NewTuple) && (m = ((VarArgsTuple)t).getCalledMethods()) != null) {
                int i = 0;
                while (i < m.length) {
                    meth.pushCallee(m[i]);
                    ++i;
                }
            }
            t = t.getNext();
        }
        if (this.isGetterMethod()) {
            meth.setAsGetter();
        } else if (this.isSetterMethod()) {
            meth.setAsSetter();
        } else if (this.isEmptyMethod()) {
            meth.setAsEmpty();
        }
    }

    private boolean isGetterMethod() {
        if (this.tuples == null) {
            return false;
        }
        return this.tuples instanceof ReturnTuple && this.tuples.operands() != null && this.tuples.operand(0) instanceof MemberVariable;
    }

    private boolean isSetterMethod() {
        if (this.tuples == null) {
            return false;
        }
        ITuple t = this.tuples;
        while (t != null) {
            AssignmentTuple at;
            if (!(t instanceof AssignmentTuple ? (at = (AssignmentTuple)t).result() instanceof MemberVariable && (at.operand(0).isConstant() || at.operand(0).isVariable() && ((IVar)at.operand(0)).getVariableKind() == 3) : t instanceof LabelTuple)) {
                return false;
            }
            t = t.getNext();
        }
        return true;
    }

    private boolean isEmptyMethod() {
        if (this.tuples == null) {
            return true;
        }
        return this.tuples instanceof ReturnTuple && this.tuples.operands() == null;
    }

    public void computeReachingDefinitions() {
        Var[] v = this.valueTable.getVariables();
        int numOfLocals = 0;
        int i = 0;
        while (i < v.length) {
            if (v[i].getVariableKind() == 2 || v[i].getVariableKind() == 3) {
                ++numOfLocals;
            }
            ++i;
        }
        this.webs = new TupleSet[numOfLocals][];
        int currVar = 0;
        int i2 = 0;
        while (i2 < v.length) {
            if (v[i2].getVariableKind() == 2 || v[i2].getVariableKind() == 3) {
                this.computeReachingDefinitionsForVar(v[i2]);
                this.webs[currVar] = this.buildWebs(v[i2]);
                ++currVar;
            }
            ++i2;
        }
    }

    private void computeReachingDefinitionsForVar(Var v) {
        boolean changed;
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            b.initForReachingDefinitionsAnalysis(v);
            b = b.getNextBlock();
        }
        do {
            changed = false;
            BasicBlock b2 = this.basicBlocks;
            while (b2 != null) {
                IBasicBlock[] preds = b2.getPredecessors();
                b2.defIn.clear();
                if (preds != null) {
                    int i = 0;
                    while (i != preds.length) {
                        BasicBlock pb = (BasicBlock)preds[i];
                        if (pb.defGen.isEmpty()) {
                            b2.defIn.insert(pb.defOut);
                        } else {
                            b2.defIn.insert(pb.defGen);
                        }
                        ++i;
                    }
                }
                if (b2.defGen.isEmpty()) {
                    changed |= b2.defOut.insert(b2.defIn);
                }
                b2 = b2.getNextBlock();
            }
        } while (changed);
    }

    private TupleSet[] buildWebs(Var v) {
        int nTuples = 0;
        ITuple t = this.tuples;
        while (t != null) {
            if (t.result() == v) {
                ++nTuples;
            }
            t = t.getNext();
        }
        ExprTuple[] ta = new ExprTuple[nTuples];
        int idx = 0;
        ITuple t2 = this.tuples;
        while (t2 != null) {
            if (t2.result() == v) {
                ta[idx++] = (ExprTuple)t2;
            }
            t2 = t2.getNext();
        }
        TupleWebs webs = new TupleWebs(ta);
        BasicBlock b = this.basicBlocks;
        while (b != null) {
            b.gatherWebsInformation(webs, v);
            b = b.getNextBlock();
        }
        return webs.extract();
    }

    public void doDeadAssignmentDetection() {
        BasicBlock bb;
        boolean changed;
        BasicBlock bb2 = this.basicBlocks;
        while (bb2 != null) {
            bb2.doLocalDeadAssignmentDetection();
            bb2 = bb2.getNextBlock();
        }
        int setSize = this.valueTable.getNumberOfVars();
        do {
            changed = false;
            bb = this.basicBlocks;
            while (bb != null) {
                BitSet newOut = new BitSet(setSize);
                IBasicBlock[] succ = bb.getSuccessors();
                if (succ != null) {
                    int i = 0;
                    while (i < succ.length) {
                        BasicBlock sb = (BasicBlock)succ[i];
                        newOut.or(sb.varIn);
                        if (sb.varOut != null) {
                            BitSet temp = (BitSet)sb.varOut.clone();
                            temp.andNot(sb.varGen);
                            newOut.or(temp);
                        }
                        ++i;
                    }
                }
                if (bb.varOut == null || !newOut.equals(bb.varOut)) {
                    changed = true;
                    bb.varOut = newOut;
                }
                bb = bb.getNextBlock();
            }
        } while (changed);
        bb = this.basicBlocks;
        while (bb != null) {
            int i = 0;
            while (i < setSize) {
                if (bb.varGen.get(i)) {
                    if (!(bb.varOut != null && bb.varOut.get(i) || bb.usedHere.get(i))) {
                        if (!(bb.genTuple[i] instanceof AssignmentTuple)) {
                            bb.genTuple[i].setAsUnused();
                        }
                    } else {
                        bb.genTuple[i].setAsUsed();
                    }
                }
                ++i;
            }
            bb = bb.getNextBlock();
        }
    }

    public void doCopyPropagation() {
        BasicBlock bb;
        boolean changed;
        ExprTuple[] copyingTuples = this.findCopyingTuples();
        BasicBlock bb2 = this.basicBlocks;
        while (bb2 != null) {
            bb2.initForCopyPropagation(copyingTuples);
            bb2 = bb2.getNextBlock();
        }
        int setSize = copyingTuples.length;
        do {
            changed = false;
            bb = this.basicBlocks;
            while (bb != null) {
                BitSet newIn = new BitSet(setSize);
                IBasicBlock[] pred = bb.getPredecessors();
                if (pred != null) {
                    int i = 0;
                    while (i < pred.length) {
                        BasicBlock sb = (BasicBlock)pred[i];
                        if (i == 0) {
                            newIn.or(sb.asgIn);
                        } else {
                            newIn.and(sb.asgIn);
                        }
                        ++i;
                    }
                }
                if (!newIn.equals(bb.asgIn)) {
                    changed = true;
                    bb.asgIn = newIn;
                    bb.asgOut = new BitSet(setSize);
                    bb.asgOut.or(newIn);
                    bb.asgOut.andNot(bb.asgKill);
                    bb.asgOut.or(bb.asgGen);
                }
                bb = bb.getNextBlock();
            }
        } while (changed);
        bb = this.basicBlocks;
        while (bb != null) {
            bb.doLocalCopyPropagation(copyingTuples);
            bb = bb.getNextBlock();
        }
    }

    private final void markUsedTemporaries() {
        ITuple t = this.tuples;
        while (t != null) {
            TempVariable tv;
            IVar resV;
            IVal[] ops = t.operands();
            if (ops != null) {
                int i = 0;
                while (i < ops.length) {
                    IVal op = ops[i];
                    if (op instanceof TempVariable) {
                        ((TempVariable)op).markAsUsed();
                    }
                    ++i;
                }
            }
            if ((resV = t.result()) instanceof TempVariable && (tv = (TempVariable)resV).sourceTuple() != t) {
                tv.markAsUsed();
            }
            t = t.getNext();
        }
    }

    private final ExprTuple[] findCopyingTuples() {
        int nTuples = 0;
        ITuple t = this.tuples;
        while (t != null) {
            if (t instanceof AssignmentTuple && this.isCopyingTuple((AssignmentTuple)t)) {
                ++nTuples;
            }
            t = t.getNext();
        }
        ExprTuple[] copyingTuples = new ExprTuple[nTuples];
        int currTuple = 0;
        ITuple t2 = this.tuples;
        while (t2 != null) {
            AssignmentTuple ta;
            if (t2 instanceof AssignmentTuple && this.isCopyingTuple(ta = (AssignmentTuple)t2)) {
                copyingTuples[currTuple] = ta;
                ++currTuple;
            }
            t2 = t2.getNext();
        }
        return copyingTuples;
    }

    private final boolean isCopyingTuple(AssignmentTuple ta) {
        int op0Kind;
        IVal op0;
        int resKind = ta.result().getVariableKind();
        return !(resKind != 2 && resKind != 3 || (op0 = ta.operand(0)).getValueKind() != 1 || (op0Kind = ((IVar)op0).getVariableKind()) != 2 && op0Kind != 3);
    }

    private final boolean doValuePropagation() {
        boolean changed;
        boolean normal = true;
        int nNormalIterations = 0;
        int i = 0;
        int j = 0;
        if (this.oldOut == null) {
            this.oldOut = new IValueDomain[this.valueTable.getNumberOfVars()];
        }
        BasicBlock bb = this.basicBlocks;
        while (bb != null) {
            ++nNormalIterations;
            bb = bb.getNextBlock();
        }
        int maxNormalIterations = 20;
        if (nNormalIterations > 20) {
            nNormalIterations = 20;
        }
        long[] val1 = null;
        this.initBasicBlocksForValuePropagation();
        do {
            long[] values;
            changed = false;
            if (i == nNormalIterations) {
                i = 0;
                nNormalIterations = nNormalIterations / 2 + 1;
                if (val1 != null && ++j > val1.length + 5) {
                    normal = false;
                    break;
                }
                if (val1 == null) {
                    val1 = this.buildValuesArray();
                }
                values = val1;
            } else {
                values = null;
            }
            BasicBlock bb2 = this.basicBlocks;
            while (bb2 != null) {
                this.combinePredecessors(bb2, values);
                changed |= this.computeOut(bb2);
                bb2 = bb2.getNextBlock();
            }
            ++i;
        } while (changed);
        if (this.basicBlocks != null) {
            this.basicBlocks.setAsReachable();
        }
        return normal;
    }

    private long[] insertValue(long[] a, long val) {
        int j = 0;
        while (j < a.length) {
            if (a[j] == val) {
                return a;
            }
            if (a[j] > val) break;
            ++j;
        }
        long[] an = new long[a.length + 1];
        int k = 0;
        while (k < j) {
            an[k] = a[k];
            ++k;
        }
        an[k] = val;
        while (k < a.length) {
            an[k + 1] = a[k];
            ++k;
        }
        return an;
    }

    private long[] buildValuesArray() {
        long[] a = new long[]{Long.MIN_VALUE, Integer.MIN_VALUE, -32768L, -128L, 0L, 127L, 32767L, 65535L, Integer.MAX_VALUE, Long.MAX_VALUE};
        ITuple t = this.tuples;
        while (t != null) {
            IVal[] op = t.operands();
            if (op != null) {
                int i = 0;
                while (i < op.length) {
                    if (op[i] instanceof IIntegralDomain) {
                        long val = ((IIntegralDomain)((Object)op[i])).getLowValue();
                        a = this.insertValue(a, val);
                    }
                    ++i;
                }
            }
            t = t.getNext();
        }
        return a;
    }

    public void detectForeverLoops() {
        this.enumerateTuples();
        if (this.loops != null) {
            int i = 0;
            while (i < this.loops.length) {
                this.loops[i].check();
                ++i;
            }
        }
    }

    public DataFlowGraph(Project prj, AstMethod method) {
        super(prj, method);
        if (this.methodBlock != null) {
            this.methodBlock.setDFG(this);
        }
        this.lastBuiltin = this.valueTable.numberOfSpecialVars();
    }

    private void initBasicBlocksForValuePropagation() {
        int arrLen = this.valueTable.getNumberOfVars();
        Var[] arr = this.valueTable.getVariables();
        BasicBlock bb = this.basicBlocks;
        while (bb != null) {
            bb.in = new IValueDomain[arrLen];
            bb.out = new IValueDomain[arrLen];
            int i = 0;
            while (i < arrLen) {
                int idx = arr[i].getVarIndex();
                if (arr[i].getVariableKind() == 6 || (arr[i].getVariableKind() == 3 || arr[i].getVariableKind() == 7) && bb == this.basicBlocks || i < this.lastBuiltin) {
                    if (arr[i].getVariableKind() == 3) {
                        ParameterVariable pv = (ParameterVariable)arr[i];
                        IValueDomain vd = this.getMethod().getParameterDomain(pv.getNumber());
                        if (vd != null) {
                            bb.in[idx] = vd;
                            bb.in[idx] = arr[i].defaultDomain();
                        } else {
                            bb.in[idx] = arr[i].defaultDomain();
                        }
                    } else {
                        bb.in[idx] = arr[i].defaultDomain();
                    }
                    bb.out[idx] = arr[i].emptyDomain();
                } else {
                    bb.out[idx] = bb.in[idx] = arr[i].emptyDomain();
                }
                ++i;
            }
            bb = bb.getNextBlock();
        }
    }

    private void combinePredecessors(BasicBlock bb, long[] values) {
        IBasicBlock[] p = bb.getPredecessors();
        if (p != null) {
            BasicBlock bbPred = (BasicBlock)p[0];
            IValueDomain[] pout = bbPred.out;
            int i = 0;
            while (i < pout.length) {
                IValueDomain vOld = bb.in[i];
                bb.in[i] = bbPred.specialOut(bb, i);
                int j = 1;
                while (j < p.length) {
                    BasicBlock bbPred1 = (BasicBlock)p[j];
                    bb.in[i] = bb.in[i].join(bbPred1.specialOut(bb, i));
                    ++j;
                }
                if (values != null && vOld instanceof IntegralDomain && bb.in[i] instanceof IntegralDomain) {
                    IntegralDomain d0 = (IntegralDomain)vOld;
                    IntegralDomain d1 = (IntegralDomain)bb.in[i];
                    bb.in[i] = d0.combine(d1, values);
                }
                ++i;
            }
        }
    }

    private boolean computeOut(BasicBlock bb) {
        int nVars = this.valueTable.getNumberOfVars();
        IValueDomain[] tempOut = this.oldOut;
        this.oldOut = bb.out;
        bb.out = tempOut;
        System.arraycopy(bb.in, 0, bb.out, 0, nVars);
        ITuple t = bb.getFirstTuple();
        while (true) {
            block6: {
                try {
                    ((Tuple)t).propagateValues();
                }
                catch (ClassCastException e) {
                    ErrorLog.log(4, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                    if (ErrorLog.debug) {
                        t.print(System.err);
                    }
                    e.printStackTrace(System.err);
                    t.print(System.err);
                    if (!(t instanceof ExprTuple)) break block6;
                    ExprTuple ee = (ExprTuple)t;
                    ee.setResultValue(((Var)ee.result()).defaultDomain());
                }
            }
            if (t == bb.getLastTuple()) break;
            t = t.getNext();
        }
        boolean needSpecialRecalculation = false;
        int i = 0;
        while (i < nVars) {
            IValueDomain oldVal = this.oldOut[i];
            if (oldVal != null && !oldVal.equals(bb.out[i])) {
                needSpecialRecalculation = true;
            }
            ++i;
        }
        bb.computeSpecialOut();
        return needSpecialRecalculation;
    }

    public void printWebs(PrintStream out) {
        out.println("Webs :");
        if (this.webs != null) {
            int i = 0;
            while (i < this.webs.length) {
                out.println("Var :" + i);
                int j = 0;
                while (j < this.webs[i].length) {
                    this.webs[i][j].print(out);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void print(PrintStream out) {
        this.valueTable.print(out);
        super.print(out);
    }

    private static void abzac() {
        System.err.println("Internal error");
        throw new Error("...");
    }

    public TupleSet[][] getWebs() {
        return this.webs;
    }
}

