/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.IControlFlowGraph;
import com.togethersoft.sca.dataflow.flowgraph.IJavaLoop;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IValueTable;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.AST_Stmt_Translator;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.JavaLoop;
import com.togethersoft.sca.internal.dataflow.flowgraph.MethodExceptionHandlingArea;
import com.togethersoft.sca.internal.dataflow.flowgraph.ValueTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.PGotoTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import java.io.PrintStream;

public class ControlFlowGraph
implements IControlFlowGraph {
    public MethodExceptionHandlingArea exceptions;
    protected Project theProject;
    protected IJavaLoop[] loops;
    protected BasicBlock basicBlocks;
    protected ITuple tuples;
    protected ValueTable valueTable;
    protected Method methodBlock;

    public IBasicBlock getBasicBlockList() {
        return this.basicBlocks;
    }

    public ITuple getTupleList() {
        return this.tuples;
    }

    public IValueTable getValueTable() {
        return this.valueTable;
    }

    ControlFlowGraph(Project prj, AstMethod method) {
        AstCompoundStatement body = method.getBody();
        this.methodBlock = prj.getFor(method);
        if (body == null) {
            if (this.methodBlock != null) {
                this.methodBlock.hasBody = false;
            }
        } else if (this.methodBlock != null) {
            this.methodBlock.hasBody = true;
        }
        this.theProject = prj;
        this.valueTable = new ValueTable(method);
        this.exceptions = new MethodExceptionHandlingArea(this.methodBlock);
        this.tuples = AST_Stmt_Translator.translateMethodBody(body, this.valueTable, this);
        this.removeUnusedTuples();
        this.exceptions.refineArea();
        this.buildBasicBlocks();
        this.buildLinks();
        int nbb = 0;
        BasicBlock currBlock = this.basicBlocks;
        while (currBlock != null) {
            currBlock.id = nbb++;
            currBlock = currBlock.getNextBlock();
        }
    }

    private final boolean removeVoidGotos() {
        boolean changed = false;
        ITuple tp = this.tuples;
        while (tp != null) {
            if (tp.getCode() == 44) {
                ITuple tn = tp.getNext();
                if (((LabelTuple)tp.target(0)).getRedirection() == tn) {
                    tp.removeFromList();
                    tp = tn;
                    changed = true;
                }
            }
            tp = tp.getNext();
        }
        return changed;
    }

    private final void markLeaders() {
        LabelTuple l = null;
        ITuple tp = this.tuples;
        while (tp != null) {
            if (tp instanceof LabelTuple) {
                LabelTuple tpl = (LabelTuple)tp;
                if (l == null) {
                    l = tpl;
                }
                tpl.setRedirection(l);
            } else {
                l = null;
            }
            tp = tp.getNext();
        }
    }

    private final void markUsedLabels() {
        ITuple tp = this.tuples;
        while (tp != null) {
            ITuple[] targets = tp.targets();
            if (targets != null) {
                int i = 0;
                while (i < targets.length) {
                    LabelTuple t = ((LabelTuple)targets[i]).getRedirection();
                    ((Tuple)t).setAsUsed();
                    targets[i] = t;
                    ++i;
                }
            }
            tp = tp.getNext();
        }
    }

    private final ITuple removeUnusedLabels(ITuple tp) {
        ITuple t = tp;
        while (t != null && t instanceof LabelTuple && ((LabelTuple)t).getRedirection() != t) {
            ITuple tt = t;
            t = t.getNext();
            tt.removeFromList();
        }
        return t;
    }

    private final void removeUnusedTuples() {
        do {
            this.markLeaders();
        } while (this.removeVoidGotos());
        this.markUsedLabels();
        if (this.loops != null) {
            int i = 0;
            while (i < this.loops.length) {
                ((JavaLoop)this.loops[i]).refine();
                ++i;
            }
        }
        ITuple currentTuple = this.tuples = this.removeUnusedLabels(this.tuples);
        while (currentTuple != null) {
            ITuple nextTuple;
            while (true) {
                nextTuple = this.removeUnusedLabels(currentTuple.getNext());
                int currCode = currentTuple.getCode();
                if (currCode != 44 && currCode != 43 && currCode != 45 || nextTuple == null || nextTuple.getCode() != 44) break;
                nextTuple.removeFromList();
            }
            currentTuple = nextTuple;
        }
    }

    private final void buildBasicBlocks() {
        BasicBlock currBlock = null;
        ITuple currTuple = this.tuples;
        block0: while (currTuple != null) {
            currBlock = new BasicBlock((Tuple)currTuple, currBlock, this);
            if (this.basicBlocks == null) {
                this.basicBlocks = currBlock;
            }
            currTuple = currTuple.getNext();
            while (currTuple != null && !currTuple.isTarget()) {
                ITuple prevTuple = currTuple;
                currBlock.appendTuple();
                currTuple = currTuple.getNext();
                if (prevTuple.transfersControl()) continue block0;
            }
        }
    }

    private final void buildLinks() {
        BasicBlock currBlock = this.basicBlocks;
        while (currBlock != null) {
            ITuple t = currBlock.getLastTuple();
            ITuple[] targets = t.targets();
            ITuple tn = null;
            if (!t.transfersControl() || t instanceof PGotoTuple) {
                tn = t.getNext();
            }
            currBlock.addSuccessors(targets, tn);
            currBlock = currBlock.getNextBlock();
        }
        BasicBlock currBlock2 = this.basicBlocks;
        while (currBlock2 != null) {
            currBlock2.createPredeccessors();
            currBlock2 = currBlock2.getNextBlock();
        }
        BasicBlock currBlock3 = this.basicBlocks;
        while (currBlock3 != null) {
            currBlock3.addToPredeccessors();
            currBlock3 = currBlock3.getNextBlock();
        }
    }

    void print(PrintStream out) {
        this.enumerateTuples();
        this.printTuples(out);
        this.printBasicBlocks(out);
        if (this.loops != null) {
            int i = 0;
            while (i < this.loops.length) {
                this.loops[i].print(out);
                ++i;
            }
        }
    }

    public final int enumerateTuples() {
        int id = 0;
        ITuple tp = this.tuples;
        while (tp != null) {
            ((Tuple)tp).setTupleId(id);
            ++id;
            tp = tp.getNext();
        }
        return id;
    }

    protected void printTuples(PrintStream out) {
        ITuple tp = this.tuples;
        while (tp != null) {
            tp.print(out);
            tp = tp.getNext();
        }
    }

    protected void printBasicBlocks(PrintStream out) {
        BasicBlock bb = this.basicBlocks;
        while (bb != null) {
            bb.print(out);
            bb = bb.getNextBlock();
        }
    }

    public IJavaLoop[] getLoops() {
        return this.loops;
    }

    public Project getProject() {
        return this.theProject;
    }

    public Method getMethod() {
        return this.methodBlock;
    }
}

