/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import java.io.PrintStream;

public class ConstraintTable {
    private IBasicBlock[] blocks;
    private int[][] indices;
    private IValueDomain[][] values;
    private int nBlocks;

    void clear() {
        this.nBlocks = 0;
    }

    IValueDomain find(IBasicBlock block, int variableIndex) {
        if (this.blocks == null) {
            return null;
        }
        int i = 0;
        while (i < this.nBlocks) {
            if (this.blocks[i] == block) {
                int[] idxs = this.indices[i];
                int j = 0;
                while (j < idxs.length) {
                    if (idxs[j] == variableIndex) {
                        return this.values[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    final void disseminate() {
        if (this.blocks != null) {
            int i = this.nBlocks;
            while (--i >= 0) {
                IValueDomain[] in = ((BasicBlock)this.blocks[i]).in;
                int[] idxs = this.indices[i];
                IValueDomain[] vals = this.values[i];
                int j = idxs.length;
                while (--j >= 0) {
                    int k = idxs[j];
                    in[k] = in[k] == null ? vals[j] : in[k].join(vals[j]);
                }
            }
        }
    }

    public void include(IBasicBlock block, ConstraintCollection coll) {
        int collSize = coll.getSize();
        if (collSize != 0) {
            int blockNumber = this.addBlock(block);
            int i = 0;
            while (i < collSize) {
                this.addEntry(blockNumber, coll.getIndex(i), coll.getConstraint(i));
                ++i;
            }
        }
    }

    public void include(IBasicBlock block, int varIndex, IValueDomain constraint) {
        int blockNumber = this.addBlock(block);
        this.addEntry(blockNumber, varIndex, constraint);
    }

    public ConstraintTable() {
        this.clear();
    }

    private int addBlock(IBasicBlock block) {
        if (this.blocks == null) {
            this.blocks = new IBasicBlock[1];
            this.indices = new int[1][];
            this.values = new IValueDomain[1][];
            this.blocks[0] = block;
            this.indices[0] = null;
            this.values[0] = null;
            this.nBlocks = 1;
            return 0;
        }
        int i = 0;
        while (i < this.nBlocks) {
            if (this.blocks[i] == block) {
                return i;
            }
            ++i;
        }
        if (this.nBlocks == this.blocks.length) {
            int newSize = this.nBlocks + 15;
            IBasicBlock[] newBlocks = new IBasicBlock[newSize];
            int[][] newIndices = new int[newSize][];
            IValueDomain[][] newValues = new IValueDomain[newSize][];
            System.arraycopy(this.blocks, 0, newBlocks, 0, this.nBlocks);
            System.arraycopy(this.indices, 0, newIndices, 0, this.nBlocks);
            System.arraycopy(this.values, 0, newValues, 0, this.nBlocks);
            this.blocks = newBlocks;
            this.indices = newIndices;
            this.values = newValues;
        }
        this.blocks[this.nBlocks] = block;
        this.indices[this.nBlocks] = null;
        this.values[this.nBlocks] = null;
        return this.nBlocks++;
    }

    private void addEntry(int blockIdx, int varIndex, IValueDomain val) {
        int[] oldIndices = this.indices[blockIdx];
        if (this.indices[blockIdx] == null) {
            this.indices[blockIdx] = new int[1];
            this.values[blockIdx] = new IValueDomain[1];
            this.indices[blockIdx][0] = varIndex;
            this.values[blockIdx][0] = val;
            return;
        }
        int i = 0;
        while (i < oldIndices.length) {
            if (oldIndices[i] == varIndex) {
                this.values[blockIdx][i] = this.values[blockIdx][i] != null ? this.values[blockIdx][i].join(val) : val;
                return;
            }
            ++i;
        }
        int oldSize = oldIndices.length;
        int newSize = oldSize + 1;
        int[] newIndices = new int[newSize];
        IValueDomain[] oldValues = this.values[blockIdx];
        IValueDomain[] newValues = new IValueDomain[newSize];
        int i2 = 0;
        while (i2 < oldSize) {
            newIndices[i2] = oldIndices[i2];
            newValues[i2] = oldValues[i2];
            ++i2;
        }
        newIndices[oldSize] = varIndex;
        newValues[oldSize] = val;
        this.indices[blockIdx] = newIndices;
        this.values[blockIdx] = newValues;
    }

    public void print(PrintStream out) {
        out.println(" . Dump of constraint table:");
        if (this.blocks == null) {
            out.println(" . EMPTY");
        } else {
            int i = 0;
            while (i < this.nBlocks) {
                out.print(" . . For block ");
                if (this.blocks[i] == null) {
                    out.println("<EMPTY>");
                } else {
                    out.println("id = " + ((BasicBlock)this.blocks[i]).getBlockId());
                }
                int j = 0;
                while (j < this.indices[i].length) {
                    out.print(" var[" + this.indices[i][j] + "] = ");
                    this.values[i][j].printBrief(out);
                    out.println();
                    ++j;
                }
                ++i;
            }
        }
    }
}

