/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.IControlFlowGraph;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.MethodSet;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.ControlFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.MemberVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.TupleSet;
import com.togethersoft.sca.internal.dataflow.flowgraph.TupleWebs;
import com.togethersoft.sca.internal.dataflow.flowgraph.ValueTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.AssignmentTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.CallTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.GotoTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NewTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ReturnTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ThrowTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.VarArgsTuple;
import java.io.PrintStream;
import java.util.BitSet;

public class BasicBlock
implements IBasicBlock {
    private boolean reachable;
    private BasicBlock next;
    private Tuple firstTuple;
    private Tuple lastTuple;
    private IBasicBlock[] successors;
    private IBasicBlock[] predecessors;
    private ControlFlowGraph cfg;
    private int blockId;
    IValueDomain[] in;
    public IValueDomain[] out;
    BitSet varIn;
    BitSet varOut;
    BitSet varGen;
    BitSet usedHere;
    Tuple[] genTuple;
    BitSet asgIn;
    BitSet asgOut;
    BitSet asgGen;
    BitSet asgKill;
    BitSet vdefIn;
    BitSet vdefGen;
    BitSet vdefUse;
    MethodSet methGen;
    MethodSet methOut;
    TupleSet defIn;
    TupleSet defOut;
    TupleSet defGen;
    boolean visited;
    ITuple[] act;
    private ConstraintTable constraints;
    int id;
    Info d;
    private static final ITuple[] emptyArray = new ITuple[0];

    public IBasicBlock[] getSuccessors() {
        return this.successors;
    }

    public IBasicBlock[] getPredecessors() {
        return this.predecessors;
    }

    public ITuple getFirstTuple() {
        return this.firstTuple;
    }

    public ITuple getLastTuple() {
        return this.lastTuple;
    }

    BasicBlock(Tuple firstTupleValue, BasicBlock prevBlock, ControlFlowGraph cfgVal) {
        if (prevBlock == null) {
            this.next = null;
            this.blockId = 0;
        } else {
            this.insertAfter(prevBlock);
            this.blockId = prevBlock.getBlockId() + 1;
        }
        this.lastTuple = this.firstTuple = firstTupleValue;
        this.firstTuple.setBasicBlock(this);
        this.constraints = new ConstraintTable();
        this.reachable = false;
        this.cfg = cfgVal;
        this.defIn = new TupleSet();
        this.defOut = new TupleSet();
        this.defGen = new TupleSet();
        this.d = new Info();
    }

    public void appendTuple() {
        this.lastTuple = (Tuple)this.lastTuple.getNext();
        this.lastTuple.setBasicBlock(this);
    }

    void cleanup() {
        this.out = null;
        this.in = null;
        this.constraints = null;
        this.usedHere = null;
        this.varGen = null;
        this.varOut = null;
        this.varIn = null;
        this.genTuple = null;
        this.asgKill = null;
        this.asgGen = null;
        this.asgOut = null;
        this.asgIn = null;
        this.vdefUse = null;
        this.vdefGen = null;
        this.vdefIn = null;
        this.methOut = null;
        this.methGen = null;
        this.defGen = null;
        this.defOut = null;
        this.defIn = null;
        this.act = null;
        this.d = null;
    }

    final void addSuccessors(ITuple[] targets, ITuple t) {
        int nSucc = 0;
        if (targets != null) {
            int i = 0;
            while (i < targets.length) {
                nSucc += this.countAsSuccessor(targets[i]);
                ++i;
            }
        }
        if (t != null) {
            nSucc += this.countAsSuccessor(t);
        }
        if (nSucc == 0) {
            return;
        }
        this.successors = new IBasicBlock[nSucc];
        int idx = 0;
        if (targets != null) {
            int i = 0;
            while (i < targets.length) {
                idx = this.addSuccessor(targets[i], idx);
                ++i;
            }
        }
        if (t != null) {
            this.addSuccessor(t, idx);
        }
    }

    private final int countAsSuccessor(ITuple t) {
        BasicBlock bb = (BasicBlock)t.basicBlock();
        if (bb.d.blockMark != this) {
            bb.d.blockMark = this;
            return 1;
        }
        return 0;
    }

    private final int addSuccessor(ITuple t, int idx) {
        BasicBlock bb = (BasicBlock)t.basicBlock();
        if (bb.d.blockMark == this) {
            bb.d.blockMark = null;
            ++bb.d.predCount;
            this.successors[idx] = bb;
            return idx + 1;
        }
        return idx;
    }

    final void createPredeccessors() {
        if (this.d.predCount != 0) {
            this.predecessors = new IBasicBlock[this.d.predCount];
            this.d.predCount = 0;
        }
    }

    final void addToPredeccessors() {
        if (this.successors != null) {
            int i = 0;
            while (i < this.successors.length) {
                BasicBlock bb = (BasicBlock)this.successors[i];
                bb.predecessors[bb.d.predCount++] = this;
                ++i;
            }
        }
    }

    public IBasicBlock getNext() {
        return this.next;
    }

    final BasicBlock getNextBlock() {
        return this.next;
    }

    public void insertAfter(IBasicBlock prevBlock) {
        BasicBlock prev = (BasicBlock)prevBlock;
        this.next = prev.getNextBlock();
        prev.next = this;
    }

    void print(PrintStream out) {
        int i;
        out.println("Block #" + this.blockId + " next =" + (this.next == null ? -1 : this.next.getBlockId()));
        out.println("  First tuple: " + (this.firstTuple == null ? -1 : this.firstTuple.getTupleId()) + " Last tuple: " + (this.lastTuple == null ? -1 : this.lastTuple.getTupleId()));
        out.print("  Successors:");
        if (this.successors == null) {
            out.println("<EMPTY>");
        } else {
            i = 0;
            while (i < this.successors.length) {
                if (i != 0) {
                    out.print(",");
                }
                if (this.successors[i] == null) {
                    out.print("<EMPTY>");
                } else {
                    out.print(" " + ((BasicBlock)this.successors[i]).getBlockId());
                }
                ++i;
            }
            out.println();
        }
        out.print("  Predecessors:");
        if (this.predecessors == null) {
            out.println("<EMPTY>");
        } else {
            i = 0;
            while (i < this.predecessors.length) {
                if (i != 0) {
                    out.print(",");
                }
                if (this.predecessors[i] == null) {
                    out.print("<EMPTY>");
                } else {
                    out.print(" " + ((BasicBlock)this.predecessors[i]).getBlockId());
                }
                ++i;
            }
            out.println();
        }
        if (this.in != null) {
            out.println("IN:");
            i = 0;
            while (i < this.in.length) {
                out.print(". [" + i + "]   = ");
                if (this.in[i] == null) {
                    out.println("null");
                } else {
                    this.in[i].printBrief(out);
                    out.println();
                }
                ++i;
            }
            out.println("OUT:");
            int i2 = 0;
            while (i2 < this.out.length) {
                out.print(". [" + i2 + "]   = ");
                if (this.out[i2] == null) {
                    out.println("null");
                } else {
                    this.out[i2].printBrief(out);
                    out.println();
                }
                ++i2;
            }
        }
        this.constraints.print(out);
        out.println("Var in:" + this.varIn);
        out.println("Var out:" + this.varOut);
        out.println("Var gen:" + this.varGen);
        out.println("Used here:" + this.usedHere);
        i = 0;
        while (i < this.genTuple.length) {
            if (this.genTuple[i] != null) {
                out.println(" " + i + " -- " + this.genTuple[i].getTupleId());
            }
            ++i;
        }
        out.print("def in:");
        this.defIn.print(out);
        out.print("def out:");
        this.defOut.print(out);
        out.print("def gen:");
        this.defGen.print(out);
        if (this.methGen != null) {
            out.println("meth gen");
            this.methGen.print(out);
        }
        if (this.methOut != null) {
            out.println("meth out");
            this.methOut.print(out);
        }
    }

    public IValueDomain getCurrentValue(IVar var) {
        return this.out[((Var)var).getVarIndex()];
    }

    public void setCurrentValue(IVar var, IValueDomain val) {
        MemberVariable mv;
        Var v = (Var)var;
        if (v.getVariableKind() == 6) {
            return;
        }
        int idx = v.getVarIndex();
        this.out[idx] = v.getVariableKind() == 7 ? (((mv = (MemberVariable)v).fieldUnit().modifiers() & 8) != 0 ? val : this.out[idx].join(val)) : val;
    }

    public void updateValuesForCall() {
        Var[] arr = ((ValueTable)this.cfg.getValueTable()).getVariables();
        int i = 0;
        while (i < arr.length) {
            MemberVariable mv;
            if (arr[i].getVariableKind() == 7 && ((mv = (MemberVariable)arr[i]).fieldUnit().modifiers() & 2) == 0) {
                this.out[mv.getVarIndex()] = mv.defaultDomain();
            }
            ++i;
        }
    }

    public IControlFlowGraph getCFG() {
        return this.cfg;
    }

    IValueDomain specialOut(IBasicBlock block, int variableIndex) {
        IValueDomain val = this.constraints.find(block, variableIndex);
        if (val != null) {
            return val;
        }
        return this.out[variableIndex];
    }

    final void initIn() {
        int i = this.in.length;
        while (--i >= 0) {
            this.in[i] = null;
        }
    }

    final void disseminate() {
        if (this.successors != null) {
            int i = this.successors.length;
            while (--i >= 0) {
                IValueDomain[] succIn = ((BasicBlock)this.successors[i]).in;
                int j = this.out.length;
                while (--j >= 0) {
                    succIn[j] = succIn[j] == null ? this.out[j] : succIn[j].join(this.out[j]);
                }
            }
            if (this.constraints != null) {
                this.constraints.disseminate();
            }
        }
    }

    void computeSpecialOut() {
        this.constraints.clear();
        this.lastTuple.computeConstraints(this.constraints);
    }

    int getBlockId() {
        return this.blockId;
    }

    public void setAsReachable() {
        if (!this.reachable) {
            this.reachable = true;
            this.lastTuple.markReachableBlocks();
        }
    }

    public boolean isReachable() {
        return this.reachable;
    }

    void initForCopyPropagation(ExprTuple[] copyingTuples) {
        int nTuples = copyingTuples.length;
        this.asgIn = new BitSet(nTuples);
        this.asgOut = new BitSet(nTuples);
        this.asgGen = new BitSet(nTuples);
        this.asgKill = new BitSet(nTuples);
        Tuple prevTuple = null;
        ITuple currTuple = this.firstTuple;
        while (prevTuple != this.lastTuple) {
            IVar res;
            if (currTuple instanceof ExprTuple && ((res = ((ExprTuple)currTuple).result()).getVariableKind() == 2 || res.getVariableKind() == 3)) {
                int i = 0;
                while (i < nTuples) {
                    ExprTuple t = copyingTuples[i];
                    if (t == currTuple) {
                        this.asgGen.set(i);
                    } else if (t.result() == res || t.operand(0) == res) {
                        this.asgGen.clear(i);
                        this.asgKill.set(i);
                    }
                    ++i;
                }
            }
            prevTuple = currTuple;
            currTuple = currTuple.getNext();
        }
        this.asgOut.or(this.asgGen);
    }

    void doLocalCopyPropagation(ExprTuple[] copyingTuples) {
        int nTuples = copyingTuples.length;
        Tuple prevTuple = null;
        ITuple currTuple = this.firstTuple;
        this.asgGen = new BitSet(nTuples);
        this.asgKill = new BitSet(nTuples);
        while (prevTuple != this.lastTuple) {
            IVal[] ops;
            int i;
            IVar res;
            if (currTuple instanceof ExprTuple && ((res = ((ExprTuple)currTuple).result()).getVariableKind() == 2 || res.getVariableKind() == 3)) {
                i = 0;
                while (i < nTuples) {
                    ExprTuple t = copyingTuples[i];
                    if (t == currTuple) {
                        this.asgGen.set(i);
                        this.asgKill.clear(i);
                    } else if (t.result() == res || t.operand(0) == res) {
                        this.asgGen.clear(i);
                        this.asgKill.set(i);
                    }
                    ++i;
                }
            }
            if ((ops = currTuple.operands()) != null) {
                i = 0;
                while (i < ops.length) {
                    if (ops[i] instanceof IVar) {
                        this.addCopyClosure(i, (IVar)ops[i], (Tuple)currTuple, copyingTuples);
                    }
                    ++i;
                }
            }
            prevTuple = currTuple;
            currTuple = currTuple.getNext();
        }
    }

    private final void addCopyClosure(int opNo, IVar v, Tuple currTuple, ExprTuple[] copyingTuples) {
        int j = 0;
        while (j < copyingTuples.length) {
            if (copyingTuples[j].result() == v && (this.asgGen.get(j) || this.asgIn.get(j)) && !this.asgKill.get(j) && currTuple.addOperandSymbolicValue(v = (IVar)copyingTuples[j].operand(0), opNo)) {
                this.addCopyClosure(opNo, v, currTuple, copyingTuples);
            }
            ++j;
        }
    }

    void initForUninitializedDetection() {
        Var[] vars = ((ValueTable)this.cfg.getValueTable()).getVariables();
        int nVars = vars.length;
        this.vdefGen = new BitSet(nVars);
        this.vdefUse = new BitSet(nVars);
        Tuple prevTuple = null;
        ITuple currTuple = this.firstTuple;
        while (prevTuple != this.lastTuple) {
            IVal[] operands = currTuple.operands();
            if (operands != null) {
                int i = 0;
                while (i < operands.length) {
                    Var v;
                    int idx;
                    if (operands[i] instanceof Var && !this.vdefGen.get(idx = (v = (Var)operands[i]).getVarIndex())) {
                        this.vdefUse.set(idx);
                    }
                    ++i;
                }
            }
            if (currTuple instanceof ExprTuple) {
                Var v = (Var)((ExprTuple)currTuple).result();
                int idx = v.getVarIndex();
                this.vdefGen.set(idx);
            }
            prevTuple = currTuple;
            currTuple = currTuple.getNext();
        }
        this.vdefIn = (BitSet)this.vdefUse.clone();
    }

    void doLocalDeadAssignmentDetection() {
        Var[] vars = ((ValueTable)this.cfg.getValueTable()).getVariables();
        int nVars = vars.length;
        this.genTuple = new Tuple[nVars];
        this.varIn = new BitSet(nVars);
        this.varGen = new BitSet(nVars);
        this.usedHere = new BitSet(nVars);
        Tuple prevTuple = null;
        ITuple currTuple = this.firstTuple;
        while (prevTuple != this.lastTuple) {
            IVal[] operands = currTuple.operands();
            if (operands != null) {
                int i = 0;
                while (i < operands.length) {
                    Var v;
                    if (operands[i] instanceof Var && ((v = (Var)operands[i]).getVariableKind() == 2 || v.getVariableKind() == 3)) {
                        int idx = v.getVarIndex();
                        if (this.varGen.get(idx)) {
                            this.usedHere.set(idx);
                        } else {
                            this.varIn.set(idx);
                        }
                    }
                    ++i;
                }
            }
            if (currTuple instanceof ExprTuple) {
                Var v = (Var)((ExprTuple)currTuple).result();
                if (v == null) {
                    currTuple.print(System.err);
                }
                if (v.getVariableKind() == 2 || v.getVariableKind() == 3) {
                    int idx = v.getVarIndex();
                    if (this.varGen.get(idx)) {
                        if (!this.usedHere.get(idx)) {
                            this.genTuple[idx].setAsUnused();
                        } else {
                            this.genTuple[idx].setAsUsed();
                        }
                        this.usedHere.clear(idx);
                    } else {
                        AstDeclaration ad;
                        AstObject ao;
                        this.varGen.set(idx);
                        if (currTuple instanceof AssignmentTuple && (ao = currTuple.getAstObject().getParent()) instanceof AstDeclaration && (ad = (AstDeclaration)ao).isFinal() && ad.getReferences().length != 0) {
                            this.genTuple[idx] = (Tuple)currTuple;
                            this.genTuple[idx].setAsUsed();
                        }
                    }
                    this.genTuple[idx] = (Tuple)currTuple;
                }
            }
            prevTuple = currTuple;
            currTuple = currTuple.getNext();
        }
    }

    final void initForReachingDefinitionsAnalysis(IVar var) {
        Tuple prevTuple = null;
        ITuple currTuple = this.firstTuple;
        Tuple dGenTuple = null;
        while (prevTuple != this.lastTuple) {
            if (currTuple instanceof ExprTuple && var == currTuple.result()) {
                dGenTuple = currTuple;
            }
            prevTuple = currTuple;
            currTuple = currTuple.getNext();
        }
        this.defIn.clear();
        this.defOut.clear();
        this.defGen.clear();
        if (dGenTuple != null) {
            this.defGen.insert(dGenTuple);
        }
    }

    private final AstObject getStatement(ITuple t) {
        AstObject obj = t.getAstObject();
        while (!(obj instanceof AstStatement)) {
            obj = obj.getParent();
        }
        return obj;
    }

    void gatherWebsInformation(TupleWebs webs, IVar var) {
        Tuple prevTuple = null;
        ITuple currTuple = this.firstTuple;
        ITuple dGenTuple = null;
        boolean usageDetected = false;
        AstObject stmt = null;
        while (prevTuple != this.lastTuple) {
            IVal[] ops = currTuple.operands();
            if (ops != null) {
                int i = 0;
                while (i < ops.length) {
                    if (var == ops[i]) {
                        stmt = this.getStatement(currTuple);
                        if (usageDetected) break;
                        usageDetected = true;
                        webs.merge(this.defIn);
                        break;
                    }
                    ++i;
                }
            }
            if (currTuple instanceof ExprTuple && var == currTuple.result()) {
                if (stmt == this.getStatement(currTuple)) {
                    if (dGenTuple == null) {
                        webs.merge(this.defIn, (ExprTuple)currTuple);
                    } else {
                        webs.merge((ExprTuple)dGenTuple, (ExprTuple)currTuple);
                    }
                } else {
                    stmt = this.getStatement(currTuple);
                    dGenTuple = currTuple;
                }
            }
            prevTuple = currTuple;
            currTuple = currTuple.getNext();
        }
    }

    ITuple[] detectRecursiveCalls(Method m) {
        block13: {
            this.visited = true;
            Tuple prevTuple = null;
            ITuple currTuple = this.firstTuple;
            while (prevTuple != this.lastTuple) {
                if (currTuple instanceof CallTuple || currTuple instanceof NewTuple) {
                    Method[] m1 = ((VarArgsTuple)currTuple).getCalledMethods();
                    boolean ok = m1.length != 0;
                    int i = 0;
                    while (i < m1.length && ok) {
                        ok = false;
                        if (m1[i] == null) break;
                        IMethod[] mc = m1[i].getCallsAlwaysClosure();
                        if (mc != null) {
                            int j = 0;
                            while (j < mc.length) {
                                if (mc[j] == m) {
                                    ok = true;
                                    break;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    if (m1.length == 1 && m1[0] == m) {
                        ok = true;
                    }
                    if (ok) {
                        ITuple[] t = new ITuple[]{currTuple};
                        this.act = t;
                        return t;
                    }
                }
                if (currTuple instanceof ReturnTuple || currTuple instanceof ThrowTuple && currTuple.target(0) == null) {
                    return null;
                }
                prevTuple = currTuple;
                currTuple = currTuple.getNext();
            }
            if (this.successors == null || this.successors.length == 0) break block13;
            ITuple[] ta = emptyArray;
            int i = 0;
            while (i < this.successors.length) {
                block16: {
                    ITuple[] tb;
                    block15: {
                        BasicBlock b;
                        block14: {
                            b = (BasicBlock)this.successors[i];
                            if (!b.visited) break block14;
                            tb = b.act;
                            if (tb != null && tb.length != 0) break block15;
                            break block16;
                        }
                        tb = b.detectRecursiveCalls(m);
                        if (tb == null || tb.length == 0) {
                            return null;
                        }
                    }
                    ITuple[] tc = new ITuple[ta.length + tb.length];
                    int j = 0;
                    while (j < ta.length) {
                        tc[j] = ta[j];
                        ++j;
                    }
                    int j2 = 0;
                    while (j2 < tb.length) {
                        tc[ta.length + j2] = tb[j2];
                        ++j2;
                    }
                    ta = tc;
                }
                ++i;
            }
            this.act = ta;
            return ta;
        }
        return null;
    }

    public AstObject getFirstAST() {
        Tuple prevTuple = null;
        ITuple currTuple = this.firstTuple;
        while (prevTuple != this.lastTuple) {
            if (!(currTuple instanceof LabelTuple) && !(currTuple instanceof GotoTuple)) {
                return currTuple.getAstObject();
            }
            prevTuple = currTuple;
            currTuple = currTuple.getNext();
        }
        if (this.successors != null) {
            if (this.successors[0].isReachable()) {
                return null;
            }
            if (this.successors[0] != this) {
                return this.successors[0].getFirstAST();
            }
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    class Info {
        BasicBlock blockMark;
        int predCount;

        Info() {
        }
    }
}

