/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstAssertStatement;
import com.togethersoft.sca.ast.AstBreakStatement;
import com.togethersoft.sca.ast.AstCaseLabel;
import com.togethersoft.sca.ast.AstCatchClause;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstContinueStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstExpressionStatement;
import com.togethersoft.sca.ast.AstFinallyClause;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSwitchGroup;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.ast.AstSynchronizedStatement;
import com.togethersoft.sca.ast.AstThrowStatement;
import com.togethersoft.sca.ast.AstTryStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.dataflow.flowgraph.IJavaLoop;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IUserVariable;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.dataflow.flowgraph.AST_Expr_Translator;
import com.togethersoft.sca.internal.dataflow.flowgraph.ControlFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.ExceptionHandlingArea;
import com.togethersoft.sca.internal.dataflow.flowgraph.JavaLoop;
import com.togethersoft.sca.internal.dataflow.flowgraph.JavaTry;
import com.togethersoft.sca.internal.dataflow.flowgraph.UserVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.ValueTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.AssignmentTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.AssumeTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.GotoTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.InitTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NewTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NopTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.RequireTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ReturnTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.SwitchTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.SyncTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ThrowTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import com.togethersoft.sca.internal.jparser.ast.AssignExpr;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;

class AST_Stmt_Translator {
    ControlFlowGraph theGraph;
    private ValueTable vt;
    private SwitchTuple currSwitch;
    private LabelInfo labels;
    ExceptionHandlingArea exceptions;
    private boolean topIsActive;
    private ITuple lastTuple;
    private IJavaLoop[] loops;
    private JavaLoop currentLoop;
    private LabelTuple tEntry;
    private LabelTuple tPrologue;
    private LabelTuple tEpilogue;
    private LabelTuple tEnd;
    private DataFlowAnalyzer theAnalyzer;

    static ITuple translateMethodBody(AstStatement stmt, ValueTable vtable, ControlFlowGraph g) {
        LabelTuple tPrologue = null;
        if (stmt != null) {
            tPrologue = new LabelTuple(null, stmt);
            AST_Stmt_Translator tr = new AST_Stmt_Translator(g.getProject().getAnalyzer(), vtable);
            tr.theGraph = g;
            tr.tPrologue = tPrologue;
            tr.tEntry = new LabelTuple(tr.tPrologue, stmt);
            tr.tEpilogue = new LabelTuple(tr.tEntry, stmt);
            tr.tEnd = new LabelTuple(tr.tEpilogue, stmt);
            g.exceptions.setArea(tr.tPrologue, tr.tEnd);
            tr.exceptions = g.exceptions;
            tr.translatePrologue();
            tr.translateEpilogue();
            tr.translate(stmt, null, null, tr.tEntry);
            g.loops = tr.getLoops();
        }
        return tPrologue;
    }

    private ITuple translatePrologueCondition(AstExpression e, ITuple t) {
        IVal v = this.translateExpr(e, true, null, null, t);
        AssumeTuple at = new AssumeTuple(v, this.lastTuple, e);
        return at;
    }

    private ITuple translateMethodPrologueCondition(AstMethod m, ITuple t) {
        AstExpression[] e = m.getPreconditions();
        ITuple cl = t;
        int i = 0;
        while (i < e.length) {
            cl = this.translatePrologueCondition(e[i], cl);
            ++i;
        }
        return cl;
    }

    private ITuple translateClassPrologueCondition(AstType m, ITuple t) {
        AstExpression[] e = m.getInvariants();
        ITuple cl = t;
        int i = 0;
        while (i < e.length) {
            cl = this.translatePrologueCondition(e[i], cl);
            ++i;
        }
        return cl;
    }

    private ITuple translateEpilogueCondition(AstExpression e, ITuple t) {
        IVal v = this.translateExpr(e, true, null, null, t);
        RequireTuple rt = new RequireTuple(v, this.lastTuple, e);
        return rt;
    }

    private ITuple translateMethodEpilogueCondition(AstMethod m, ITuple t) {
        AstExpression[] e = m.getPostconditions();
        ITuple cl = t;
        int i = 0;
        while (i < e.length) {
            cl = this.translateEpilogueCondition(e[i], cl);
            ++i;
        }
        return cl;
    }

    private ITuple translateClassEpilogueCondition(AstType m, ITuple t) {
        AstExpression[] e = m.getInvariants();
        ITuple cl = t;
        int i = 0;
        while (i < e.length) {
            cl = this.translateEpilogueCondition(e[i], cl);
            ++i;
        }
        return cl;
    }

    private void translatePrologue() {
        AstMethod m = (AstMethod)this.theGraph.getMethod().getAstObject();
        ITuple cl = this.tPrologue;
        AstType at = m.getDeclaringType();
        while (at != null) {
            cl = this.translateClassPrologueCondition(at, cl);
            at = at.getSuperClass();
        }
        AstMethod[] om = m.getOverridden();
        int j = 0;
        while (j < om.length) {
            cl = this.translateMethodPrologueCondition(om[j], cl);
            ++j;
        }
        this.translateMethodPrologueCondition(m, cl);
        if (cl == this.tPrologue) {
            new NopTuple(cl, m);
        }
        Tuple t = this.tPrologue;
        while (t != this.tEntry) {
            t.setAsAssertGenerated();
            t = (Tuple)t.getNext();
        }
    }

    private void translateEpilogue() {
        AstMethod m = (AstMethod)this.theGraph.getMethod().getAstObject();
        ITuple cl = this.tEpilogue;
        AstType at = m.getDeclaringType();
        while (at != null) {
            cl = this.translateClassEpilogueCondition(at, cl);
            at = at.getSuperClass();
        }
        AstMethod[] om = m.getOverridden();
        int j = 0;
        while (j < om.length) {
            cl = this.translateMethodEpilogueCondition(om[j], cl);
            ++j;
        }
        this.translateMethodEpilogueCondition(m, cl);
        Tuple t = this.tEpilogue;
        while (t != this.tEnd) {
            t.setAsAssertGenerated();
            t = (Tuple)t.getNext();
        }
    }

    private ITuple translate(AstStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        ITuple t;
        LabelTuple stmtLabel;
        LabelInfo oldLabels = this.labels;
        boolean oldTopIsActive = this.topIsActive;
        String[] names = stmt.getLabelNames();
        if (names != null && names.length != 0) {
            stmtLabel = new LabelTuple(linkAfter, stmt);
            this.topIsActive = true;
            int i = 0;
            while (i < names.length) {
                this.labels = new LabelInfo(names[i], stmtLabel, this.labels);
                ++i;
            }
        } else {
            this.topIsActive = false;
            stmtLabel = null;
        }
        switch (stmt.getObjectKind()) {
            case 10: {
                t = this.translateWhile((AstWhileStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 27: {
                t = this.translateDo((AstDoStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 17: {
                t = this.translateFor((AstForStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 16: {
                t = this.translateIf((AstIfStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 13: {
                t = this.translateSwitch((AstSwitchStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 26: {
                t = this.translateSwitchGroup((AstSwitchGroup)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 21: {
                t = this.translateCompound((AstCompoundStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 22: {
                t = linkAfter;
                break;
            }
            case 18: {
                t = this.translateBreak((AstBreakStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 28: {
                t = this.translateContinue((AstContinueStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 14: {
                t = this.translateReturn((AstReturnStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 24: {
                t = this.translateDeclaration((AstDeclarationStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 23: {
                t = this.translateExpression((AstExpressionStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 12: {
                t = this.translateSynchronized((AstSynchronizedStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 11: {
                t = this.translateTry((AstTryStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 15: {
                t = this.translateThrow((AstThrowStatement)stmt, onBreak, onContinue, linkAfter);
                break;
            }
            case 47: {
                t = this.translateAssert((AstAssertStatement)stmt, linkAfter);
                break;
            }
            default: {
                throw new Error("Unknown statement kind: " + stmt.getObjectKind());
            }
        }
        this.labels = oldLabels;
        this.topIsActive = oldTopIsActive;
        if (stmtLabel != null) {
            return stmtLabel;
        }
        return t;
    }

    private ITuple translateWhile(AstWhileStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        LabelTuple loopEntry = new LabelTuple(linkAfter, stmt);
        LabelTuple loopBody = new LabelTuple(loopEntry, stmt);
        LabelTuple loopExit = new LabelTuple(loopBody, stmt);
        this.setupContinueLabel(loopEntry);
        this.translateExpr(stmt.getCondition(), false, loopBody, loopExit, loopEntry);
        this.pushLoop(loopBody, loopExit, loopEntry, this.lastTuple, stmt);
        ITuple link = this.translate(stmt.getBody(), loopExit, loopEntry, loopBody);
        this.setLoopBodyEnd(new GotoTuple(loopEntry, link, stmt));
        this.restoreLoopContext();
        return loopExit;
    }

    private ITuple translateDo(AstDoStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        LabelTuple loopBody = new LabelTuple(linkAfter, stmt);
        LabelTuple loopEntry = new LabelTuple(loopBody, stmt);
        LabelTuple loopExit = new LabelTuple(loopEntry, stmt);
        this.setupContinueLabel(loopEntry);
        this.translateExpr(stmt.getCondition(), false, loopBody, loopExit, loopEntry);
        this.pushLoop(loopBody, loopEntry, loopEntry, this.lastTuple, stmt);
        linkAfter = this.translate(stmt.getBody(), loopExit, loopEntry, loopBody);
        this.setLoopBodyEnd(linkAfter);
        this.restoreLoopContext();
        return loopExit;
    }

    private ITuple translateFor(AstForStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        AstStatement[] stmts = stmt.getInitializers();
        int i = 0;
        while (i < stmts.length) {
            linkAfter = this.translate(stmts[i], onBreak, onContinue, linkAfter);
            ++i;
        }
        LabelTuple loopCond = new LabelTuple(linkAfter, stmt);
        LabelTuple loopBody = new LabelTuple(loopCond, stmt);
        LabelTuple loopEntry = new LabelTuple(loopBody, stmt);
        LabelTuple loopExit = new LabelTuple(loopEntry, stmt);
        this.setupContinueLabel(loopEntry);
        AstExpression condExpr = stmt.getCondition();
        ITuple endCond = loopCond;
        if (condExpr != null) {
            this.translateExpr(stmt.getCondition(), false, loopBody, loopExit, loopCond);
            endCond = this.lastTuple;
        }
        this.pushLoop(loopBody, loopExit, loopCond, endCond, stmt);
        this.translate(stmt.getBody(), loopExit, loopEntry, loopBody);
        stmts = stmt.getUpdateStatements();
        linkAfter = loopEntry;
        int i2 = 0;
        while (i2 < stmts.length) {
            linkAfter = this.translate(stmts[i2], loopExit, loopEntry, linkAfter);
            ++i2;
        }
        this.setLoopBodyEnd(new GotoTuple(loopCond, linkAfter, stmt));
        this.restoreLoopContext();
        return loopExit;
    }

    private ITuple translateIf(AstIfStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        LabelTuple yesBranch = new LabelTuple(linkAfter, stmt);
        LabelTuple noBranch = new LabelTuple(yesBranch, stmt);
        this.translateExpr(stmt.getCondition(), false, yesBranch, noBranch, linkAfter);
        linkAfter = this.translate(stmt.getThenStatement(), onBreak, onContinue, yesBranch);
        AstStatement elseStmt = stmt.getElseStatement();
        if (elseStmt != null) {
            LabelTuple stmtEnd = new LabelTuple(noBranch, stmt);
            new GotoTuple(stmtEnd, linkAfter, stmt);
            this.translate(elseStmt, onBreak, onContinue, noBranch);
            return stmtEnd;
        }
        return noBranch;
    }

    private ITuple translateSwitch(AstSwitchStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        SwitchTuple prevSwitch = this.currSwitch;
        LabelTuple stmtEnd = new LabelTuple(linkAfter, stmt);
        IVal v = this.translateExpr(stmt.getCondition(), true, null, null, linkAfter);
        this.currSwitch = new SwitchTuple(v, stmtEnd, stmtEnd.getPrev(), stmt);
        linkAfter = this.currSwitch;
        AstSwitchGroup[] stmts = stmt.getBody();
        int i = 0;
        while (i < stmts.length) {
            linkAfter = this.translate(stmts[i], stmtEnd, onContinue, linkAfter);
            ++i;
        }
        this.currSwitch = prevSwitch;
        return stmtEnd;
    }

    private ITuple translateSwitchGroup(AstSwitchGroup stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        AstCaseLabel[] caseLabels = stmt.getLabels();
        LabelTuple label = new LabelTuple(linkAfter, stmt);
        int i = 0;
        while (i < caseLabels.length) {
            if (caseLabels[i].isDefault()) {
                this.currSwitch.setDefaultLabel(label);
            } else {
                IVal v = this.translateExpr(caseLabels[i].getCondition(), true, null, null, this.currSwitch.getPrev());
                this.currSwitch.pushCase(label, v);
            }
            ++i;
        }
        AstStatement[] stmts = stmt.getStatements();
        linkAfter = label;
        int i2 = 0;
        while (i2 < stmts.length) {
            linkAfter = this.translate(stmts[i2], onBreak, onContinue, linkAfter);
            ++i2;
        }
        return linkAfter;
    }

    private ITuple translateCompound(AstCompoundStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        AstStatement[] stmts = stmt.getStatements();
        int i = 0;
        while (i < stmts.length) {
            linkAfter = this.translate(stmts[i], onBreak, onContinue, linkAfter);
            ++i;
        }
        return linkAfter;
    }

    private ITuple translateBreak(AstBreakStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        String labelName = stmt.getLabelName();
        if (labelName != null) {
            LabelTuple label = this.findLabel(labelName);
            if (label != null) {
                return new GotoTuple(label, linkAfter, stmt);
            }
            return linkAfter;
        }
        if (onBreak != null) {
            return new GotoTuple(onBreak, linkAfter, stmt);
        }
        return linkAfter;
    }

    private ITuple translateContinue(AstContinueStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        String labelName = stmt.getLabelName();
        if (labelName != null) {
            LabelTuple label = this.findLabelForContinue(labelName);
            if (label != null) {
                return new GotoTuple(label, linkAfter, stmt);
            }
            return linkAfter;
        }
        if (onContinue != null) {
            return new GotoTuple(onContinue, linkAfter, stmt);
        }
        return linkAfter;
    }

    private ITuple translateReturn(AstReturnStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        AstExpression expr = stmt.getReturnExpression();
        if (expr != null) {
            IVal v = this.translateExpr(expr, true, null, null, linkAfter);
            UserVariable resVar = this.vt.getResultVar();
            if (resVar != null) {
                this.lastTuple = new AssignmentTuple(this.vt.getResultVar(), v, this.lastTuple, expr);
            }
            return new ReturnTuple(v, this.lastTuple, stmt, this.tEpilogue);
        }
        return new ReturnTuple(linkAfter, stmt, this.tEpilogue);
    }

    private ITuple translateDeclaration(AstDeclarationStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        AstDeclaration[] decl = stmt.getDeclarations();
        int i = 0;
        while (i < decl.length) {
            linkAfter = this.translateDecl(decl[i], linkAfter);
            ++i;
        }
        return linkAfter;
    }

    private ITuple translateExpression(AstExpressionStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        this.translateExpr(stmt.getExpression(), false, null, null, linkAfter);
        return this.lastTuple;
    }

    private ITuple translateSynchronized(AstSynchronizedStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        IVal v = this.translateExpr(stmt.getExpression(), true, null, null, linkAfter);
        linkAfter = new SyncTuple(v, true, this.lastTuple, stmt);
        linkAfter = this.translate(stmt.getBody(), onBreak, onContinue, linkAfter);
        return new SyncTuple(v, false, linkAfter, stmt);
    }

    private ITuple translateTry(AstTryStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        ITuple insertionPoint = linkAfter;
        LabelTuple stmtExit = new LabelTuple(insertionPoint, stmt);
        AstFinallyClause finallyStmt = stmt.getFinallyClause();
        LabelTuple[] catchLabels = null;
        AstTypeReference[] catchTypes = null;
        AstCatchClause[] catches = stmt.getCatchClauses();
        if (catches != null) {
            catchLabels = new LabelTuple[catches.length];
            catchTypes = new AstTypeReference[catches.length];
            int i = 0;
            while (i < catches.length) {
                catchLabels[i] = new LabelTuple(linkAfter, stmt);
                linkAfter = catchLabels[i];
                catchTypes[i] = catches[i].getParameter().getType();
                AstVariable currDecl = catches[i].getParameter();
                if (currDecl.getObjectKind() == 9) {
                    AstVariable varDecl = currDecl;
                    IUserVariable ev = this.vt.addUserVariable(varDecl, 2);
                    linkAfter = new InitTuple(4, ev, linkAfter, varDecl);
                }
                linkAfter = this.translate(catches[i].getBody(), onBreak, onContinue, linkAfter);
                ++i;
            }
            new GotoTuple(stmtExit, linkAfter, stmt);
        }
        JavaTry jt = new JavaTry(this.exceptions, catchLabels, catchTypes);
        if (finallyStmt != null) {
            jt.setupFinallyHandler(stmtExit);
        }
        this.exceptions = jt;
        linkAfter = this.translate(stmt.getBody(), onBreak, onContinue, insertionPoint);
        jt.setArea((Tuple)insertionPoint.getNext(), (Tuple)linkAfter);
        this.exceptions = this.exceptions.getUp();
        new GotoTuple(stmtExit, linkAfter, stmt);
        if (finallyStmt != null) {
            return this.translate(finallyStmt.getBody(), onBreak, onContinue, stmtExit);
        }
        return stmtExit;
    }

    private ITuple translateThrow(AstThrowStatement stmt, LabelTuple onBreak, LabelTuple onContinue, ITuple linkAfter) {
        AstExpression throwExpr = stmt.getExpression();
        IVal v = this.translateExpr(throwExpr, true, null, null, linkAfter);
        Tuple targetTuple = this.findHandler(throwExpr.getRuntimeType());
        return new ThrowTuple(v, targetTuple, this.lastTuple, stmt);
    }

    private ITuple translateAssert(AstAssertStatement stmt, ITuple linkAfter) {
        NewTuple nt;
        LabelTuple noBranch = new LabelTuple(linkAfter, stmt);
        LabelTuple yesBranch = new LabelTuple(noBranch, stmt);
        this.translateExpr(stmt.getCondition(), false, yesBranch, noBranch, linkAfter);
        AstExpression extraArg = stmt.getArgument();
        if (extraArg != null) {
            IVal v = this.translateExpr(extraArg, true, null, null, noBranch);
            nt = new NewTuple(1, this.lastTuple, stmt);
            nt.setOperand(0, v);
        } else {
            nt = new NewTuple(0, this.lastTuple, stmt);
        }
        ITempVariable temp = this.vt.addTempVariable(9, nt);
        nt.setResultVar(temp);
        Tuple targetTuple = this.findHandler(nt.getTypeReference());
        new ThrowTuple(temp, targetTuple, nt, stmt);
        return yesBranch;
    }

    private IVal translateExpr(AstExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch, ITuple linkAfter) {
        AST_Expr_Translator exprTranslator = new AST_Expr_Translator(this, this.vt, linkAfter, this.theAnalyzer);
        IVal res = exprTranslator.translate(expr, valueUsed, yesBranch, noBranch);
        this.lastTuple = exprTranslator.getLinkAfter();
        return res;
    }

    private ITuple translateDecl(AstDeclaration currDecl, ITuple linkAfter) {
        ITuple last = null;
        if (currDecl.getObjectKind() == 9) {
            AstVariable varDecl = (AstVariable)currDecl;
            this.vt.addUserVariable(varDecl, 2);
            if (varDecl.getInitializer() == null) {
                last = linkAfter;
            } else {
                AssignExpr expr = ((VariableDeclarator)varDecl).getInitializerAssignment();
                this.translateExpr(expr, true, null, null, linkAfter);
                last = this.lastTuple;
            }
        }
        return last;
    }

    Tuple findHandler(AstTypeReference exceptionType) {
        LabelTuple t = this.exceptions.findHandler(exceptionType);
        if (t == null) {
            t = this.tEnd;
        }
        return t;
    }

    private LabelTuple findLabel(String labelName) {
        LabelInfo inf = this.labels;
        while (inf != null) {
            if (inf.name.equals(labelName)) {
                return inf.tuple;
            }
            inf = inf.next;
        }
        return null;
    }

    private LabelTuple findLabelForContinue(String labelName) {
        LabelInfo inf = this.labels;
        while (inf != null) {
            if (inf.name.equals(labelName)) {
                return inf.contTuple;
            }
            inf = inf.next;
        }
        return null;
    }

    private void setupContinueLabel(LabelTuple cLabel) {
        if (this.topIsActive) {
            LabelTuple key = this.labels.tuple;
            LabelInfo inf = this.labels;
            while (inf != null && inf.tuple == key) {
                inf.contTuple = cLabel;
                inf = inf.next;
            }
        }
    }

    private void pushLoop(ITuple bodyStart, ITuple bodyEnd, ITuple conditionStart, ITuple conditionEnd, AstStatement loopStmt) {
        JavaLoop oldCurrentLoop = this.currentLoop;
        this.currentLoop = new JavaLoop(this.currentLoop, bodyStart, bodyEnd, conditionStart, conditionEnd, loopStmt);
        if (oldCurrentLoop == null) {
            if (this.loops == null) {
                this.loops = new IJavaLoop[1];
            } else {
                IJavaLoop[] newLoops = new IJavaLoop[this.loops.length + 1];
                int i = 0;
                while (i < this.loops.length) {
                    newLoops[i] = this.loops[i];
                    ++i;
                }
                this.loops = newLoops;
            }
            this.loops[this.loops.length - 1] = this.currentLoop;
        }
    }

    private final void setLoopBodyEnd(ITuple t) {
        this.currentLoop.setBodyEnd(t);
    }

    private final void restoreLoopContext() {
        this.currentLoop = this.currentLoop.getTop();
    }

    private AST_Stmt_Translator(DataFlowAnalyzer theAnalyzer, ValueTable vtVal) {
        this.vt = vtVal;
        this.currSwitch = null;
        this.labels = null;
        this.topIsActive = false;
        this.lastTuple = null;
        this.loops = null;
        this.currentLoop = null;
        this.theAnalyzer = theAnalyzer;
    }

    public IJavaLoop[] getLoops() {
        return this.loops;
    }

    private class LabelInfo {
        String name;
        LabelTuple tuple;
        LabelTuple contTuple;
        LabelInfo next;

        LabelInfo(String nameVal, LabelTuple tupleVal, LabelInfo nextVal) {
            this.name = nameVal;
            this.tuple = tupleVal;
            this.next = nextVal;
            this.contTuple = null;
        }
    }
}

