/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstArrayCreationExpression;
import com.togethersoft.sca.ast.AstArrayInitializer;
import com.togethersoft.sca.ast.AstArrayReference;
import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstBooleanLiteral;
import com.togethersoft.sca.ast.AstCastExpression;
import com.togethersoft.sca.ast.AstCharLiteral;
import com.togethersoft.sca.ast.AstConditionalExpression;
import com.togethersoft.sca.ast.AstConstructorInvocation;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDoubleLiteral;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstFloatLiteral;
import com.togethersoft.sca.ast.AstIntLiteral;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstLongLiteral;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstParenthesizedExpression;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IUserVariable;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.flowgraph.AST_Stmt_Translator;
import com.togethersoft.sca.internal.dataflow.flowgraph.TempVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.UserVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.ValueTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.AddTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.AssignmentTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.BitAndTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.BitOrTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.BitXorTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.CallTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.CastTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ComTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.DecTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.DivTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.EQ_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.GE_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.GT_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.GotoTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.IfTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.IncTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.IndexingTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.InstanceofTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LE_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LT_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LengthTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.MemberAccessTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ModTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.MulTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NE_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NegTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NewArrayTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NewTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NotTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.PGotoTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.PhiTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ShiftLeftTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ShiftRightTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.SubTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.UnsignedShiftRightTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.UplTuple;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.CharConstant;
import com.togethersoft.sca.internal.dataflow.values.ConstantVal;
import com.togethersoft.sca.internal.dataflow.values.DoubleConstant;
import com.togethersoft.sca.internal.dataflow.values.FloatConstant;
import com.togethersoft.sca.internal.dataflow.values.IntConstant;
import com.togethersoft.sca.internal.dataflow.values.LongConstant;
import com.togethersoft.sca.internal.dataflow.values.ObjectConstant;
import com.togethersoft.sca.internal.dataflow.values.TypeConstant;

class AST_Expr_Translator {
    private DataFlowAnalyzer theAnalyzer;
    private ValueTable vt;
    private ITuple linkAfter;
    private AST_Stmt_Translator stmtTrans;

    IVal translate(AstExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        switch (expr.getObjectKind()) {
            case 43: {
                return this.translateUnary((AstUnaryExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 33: {
                return this.translateBinary((AstBinaryExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 32: {
                return this.translateAssignment((AstAssignmentExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 38: {
                return this.translateMethodCall((AstMethodCallExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 39: {
                return this.translateNew((AstObjectCreationExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 30: {
                return this.translateNewArray((AstArrayCreationExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 31: {
                return this.translateArrayReference((AstArrayReference)expr, valueUsed, yesBranch, noBranch);
            }
            case 34: {
                return this.translateCast((AstCastExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 35: {
                return this.translateConditional((AstConditionalExpression)expr, valueUsed, yesBranch, noBranch);
            }
            case 44: {
                return this.translateArrayInitializer((AstArrayInitializer)expr);
            }
            case 45: {
                return this.translateTypeExpression((AstTypeExpression)expr);
            }
            case 36: {
                return this.translateFieldReference((AstFieldReference)expr, valueUsed, yesBranch, noBranch);
            }
            case 41: {
                UserVariable sv = this.vt.getSuperVar();
                if (sv == null) {
                    sv = this.vt.pseudo(null);
                }
                return this.applyCasts(sv, expr, valueUsed, yesBranch, noBranch);
            }
            case 42: {
                UserVariable sv = this.vt.getSuperVar();
                if (sv == null) {
                    sv = this.vt.pseudo(null);
                }
                return this.applyCasts(sv, expr, valueUsed, yesBranch, noBranch);
            }
            case 51: {
                UserVariable rv = this.vt.getResultVar();
                if (rv == null) {
                    rv = this.vt.pseudo(null);
                }
                return this.applyCasts(rv, expr, valueUsed, yesBranch, noBranch);
            }
            case 29: {
                return this.translateConstructorCall((AstConstructorInvocation)expr, valueUsed, yesBranch, noBranch);
            }
            case 40: {
                return this.translateSimpleReference((AstSimpleReference)expr, valueUsed, yesBranch, noBranch);
            }
            case 37: {
                return this.translateLiteral((AstLiteral)expr, valueUsed, yesBranch, noBranch);
            }
            case 46: {
                return this.translateParenthesizedExpression((AstParenthesizedExpression)expr, valueUsed, yesBranch, noBranch);
            }
        }
        throw new Error("Unknown expression object kind:" + expr.getObjectKind());
    }

    private IVal applyCasts(IVal exprValue, AstExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        IVal resultValue = exprValue;
        if (valueUsed) {
            AstTypeReference runtimeType = expr.getRuntimeType();
            int producedType = exprValue.getValueType();
            int expectedType = ValueTable.translateType(runtimeType);
            if (expectedType != 0 && expectedType != producedType) {
                CastTuple castTuple = new CastTuple(exprValue, expectedType, this.linkAfter, expr);
                this.linkAfter = castTuple;
                resultValue = this.setupResultTemp(castTuple);
            }
        }
        if (yesBranch != null) {
            this.linkAfter = new IfTuple(resultValue, yesBranch, noBranch, this.linkAfter, expr);
        }
        return resultValue;
    }

    private IVal translateUnary(AstUnaryExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        IVal res;
        ExprTuple t;
        IVal operand = this.translate(expr.getOperand(), true, null, null);
        switch (expr.getExpressionKind()) {
            case 0: {
                t = new UplTuple(operand, this.linkAfter, expr);
                res = this.setupResultTemp(t);
                break;
            }
            case 1: {
                t = new NegTuple(operand, this.linkAfter, expr);
                res = this.setupResultTemp(t);
                break;
            }
            case 2: {
                t = new ComTuple(operand, this.linkAfter, expr);
                res = this.setupResultTemp(t);
                break;
            }
            case 3: {
                t = new NotTuple(operand, this.linkAfter, expr);
                res = this.setupResultTemp(t);
                break;
            }
            case 4: {
                t = new IncTuple(operand, this.linkAfter, expr);
                res = operand;
                if (operand instanceof IVar) {
                    t.setResultVar((IVar)operand);
                    break;
                }
                res = this.setupResultTemp(t);
                break;
            }
            case 5: {
                t = new DecTuple(operand, this.linkAfter, expr);
                res = operand;
                if (operand instanceof IVar) {
                    t.setResultVar((IVar)operand);
                    break;
                }
                res = this.setupResultTemp(t);
                break;
            }
            case 6: {
                if (valueUsed || yesBranch != null) {
                    AssignmentTuple at = new AssignmentTuple(operand, 1, this.linkAfter, (AstExpression)expr);
                    res = this.setupResultTemp(at);
                    this.linkAfter = at;
                } else {
                    res = null;
                }
                t = new IncTuple(operand, this.linkAfter, expr);
                if (operand instanceof IVar) {
                    t.setResultVar((IVar)operand);
                    break;
                }
                res = this.setupResultTemp(t);
                break;
            }
            case 7: {
                if (valueUsed || yesBranch != null) {
                    AssignmentTuple at = new AssignmentTuple(operand, 2, this.linkAfter, (AstExpression)expr);
                    res = this.setupResultTemp(at);
                    this.linkAfter = at;
                } else {
                    res = null;
                }
                t = new DecTuple(operand, this.linkAfter, expr);
                if (operand instanceof IVar) {
                    t.setResultVar((IVar)operand);
                    break;
                }
                res = this.setupResultTemp(t);
                break;
            }
            default: {
                throw new Error("Bad kind of unary expression:" + expr.getExpressionKind());
            }
        }
        this.linkAfter = t;
        return this.applyCasts(res, expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateBinary(AstBinaryExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        ExprTuple t;
        int exprKind = expr.getExpressionKind();
        if (exprKind == 15) {
            return this.translateAnd(expr, valueUsed, yesBranch, noBranch);
        }
        if (exprKind == 16) {
            return this.translateOr(expr, valueUsed, yesBranch, noBranch);
        }
        IVal op0 = this.translate(expr.getLeftOperand(), true, null, null);
        IVal op1 = this.translate(expr.getRightOperand(), true, null, null);
        switch (exprKind) {
            case 1: {
                t = new MulTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 2: {
                t = new DivTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 3: {
                t = new ModTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 4: {
                t = new AddTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 5: {
                t = new SubTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 6: {
                t = new ShiftLeftTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 7: {
                t = new ShiftRightTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 8: {
                t = new UnsignedShiftRightTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 9: {
                t = new InstanceofTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 10: {
                t = new LT_Tuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 11: {
                t = new GT_Tuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 17: {
                t = new LE_Tuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 18: {
                t = new GE_Tuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 19: {
                t = new EQ_Tuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 20: {
                t = new NE_Tuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 12: {
                t = new BitAndTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 13: {
                t = new BitXorTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 14: {
                t = new BitOrTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            default: {
                throw new Error("Unknown binary expression kind:" + exprKind);
            }
        }
        this.linkAfter = t;
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateAnd(AstBinaryExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        if (yesBranch != null && !valueUsed) {
            LabelTuple rightLabel = new LabelTuple(this.linkAfter, expr);
            this.translate(expr.getLeftOperand(), false, rightLabel, noBranch);
            this.linkAfter = rightLabel;
            this.translate(expr.getRightOperand(), false, yesBranch, noBranch);
            return null;
        }
        LabelTuple endLabel = new LabelTuple(this.linkAfter, expr);
        LabelTuple rightLabel = new LabelTuple(this.linkAfter, expr);
        IVal op0 = this.translate(expr.getLeftOperand(), true, rightLabel, endLabel);
        this.linkAfter = rightLabel;
        IVal op1 = this.translate(expr.getRightOperand(), true, null, null);
        PhiTuple phi = new PhiTuple(2, (ITuple)endLabel, expr);
        phi.setOperand(0, op0);
        phi.setOperand(1, op1);
        this.linkAfter = phi;
        return this.applyCasts(this.setupResultTemp(phi), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateOr(AstBinaryExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        if (yesBranch != null && !valueUsed) {
            LabelTuple rightLabel = new LabelTuple(this.linkAfter, expr);
            this.translate(expr.getLeftOperand(), false, yesBranch, rightLabel);
            this.linkAfter = rightLabel;
            this.translate(expr.getRightOperand(), false, yesBranch, noBranch);
            return null;
        }
        LabelTuple endLabel = new LabelTuple(this.linkAfter, expr);
        LabelTuple rightLabel = new LabelTuple(this.linkAfter, expr);
        IVal op0 = this.translate(expr.getLeftOperand(), true, endLabel, rightLabel);
        this.linkAfter = rightLabel;
        IVal op1 = this.translate(expr.getRightOperand(), true, null, null);
        PhiTuple phi = new PhiTuple(2, (ITuple)endLabel, expr);
        phi.setOperand(0, op0);
        phi.setOperand(1, op1);
        this.linkAfter = phi;
        return this.applyCasts(this.setupResultTemp(phi), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateAssignment(AstAssignmentExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        ExprTuple t;
        IVal op0v = this.translate(expr.getLeftOperand(), true, null, null);
        IVal op1 = this.translate(expr.getRightOperand(), true, null, null);
        IVar op0 = op0v instanceof IVar ? (IVar)op0v : this.vt.pseudo(expr.getRuntimeType());
        switch (expr.getExpressionKind()) {
            case 0: {
                t = new AssignmentTuple(op1, this.linkAfter, expr);
                break;
            }
            case 1: {
                t = new AddTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 2: {
                t = new SubTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 3: {
                t = new MulTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 4: {
                t = new DivTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 5: {
                t = new ModTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 6: {
                t = new ShiftRightTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 7: {
                t = new UnsignedShiftRightTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 8: {
                t = new ShiftLeftTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 9: {
                t = new BitAndTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 10: {
                t = new BitXorTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            case 11: {
                t = new BitOrTuple(op0, op1, this.linkAfter, expr);
                break;
            }
            default: {
                throw new Error("Bad assignment expression kind:" + expr.getExpressionKind());
            }
        }
        t.setResultVar(op0);
        this.linkAfter = t;
        return this.applyCasts(op0, expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateLiteral(AstLiteral expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        ConstantVal res;
        switch (expr.getLiteralKind()) {
            case 7: {
                res = ObjectConstant.forNull();
                break;
            }
            case 4: {
                AstBooleanLiteral abl = (AstBooleanLiteral)expr;
                res = BooleanConstant.make(abl.getValue());
                break;
            }
            case 6: {
                ObjectConstant objConst = new ObjectConstant(expr.getText());
                objConst.setFrontEndTypeReference(expr.getRuntimeType());
                res = objConst;
                break;
            }
            case 5: {
                AstCharLiteral acl = (AstCharLiteral)expr;
                res = new CharConstant(acl.getValue());
                break;
            }
            case 0: {
                AstIntLiteral ail = (AstIntLiteral)expr;
                res = new IntConstant(ail.getValue());
                break;
            }
            case 1: {
                AstLongLiteral ail = (AstLongLiteral)expr;
                res = new LongConstant(ail.getValue());
                break;
            }
            case 2: {
                AstFloatLiteral afl = (AstFloatLiteral)expr;
                res = new FloatConstant(afl.getValue());
                break;
            }
            case 3: {
                AstDoubleLiteral afl = (AstDoubleLiteral)expr;
                res = new DoubleConstant(afl.getValue());
                break;
            }
            default: {
                throw new Error("Bad kind of literal expression:" + expr.getLiteralKind());
            }
        }
        return this.applyCasts(res, expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateArrayReference(AstArrayReference expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        IVal op0 = this.translate(expr.getBase(), true, null, null);
        IVal op1 = this.translate(expr.getIndex(), true, null, null);
        IndexingTuple t = new IndexingTuple(op0, op1, this.linkAfter, expr);
        this.linkAfter = t;
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateCast(AstCastExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        IVal op0 = this.translate(expr.getExpression(), true, null, null);
        CastTuple t = new CastTuple(op0, this.linkAfter, expr);
        this.linkAfter = t;
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateConditional(AstConditionalExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        LabelTuple yesLabel = new LabelTuple(this.linkAfter, expr);
        LabelTuple noLabel = new LabelTuple(yesLabel, expr);
        LabelTuple endLabel = new LabelTuple(noLabel, expr);
        this.translate(expr.testExpression(), true, yesLabel, noLabel);
        this.linkAfter = yesLabel;
        IVal v0 = this.translate(expr.trueExpression(), true, null, null);
        new GotoTuple(endLabel, this.linkAfter, expr);
        this.linkAfter = noLabel;
        IVal v1 = this.translate(expr.falseExpression(), true, null, null);
        PhiTuple phi = new PhiTuple(2, (ITuple)endLabel, expr);
        phi.setOperand(0, v0);
        phi.setOperand(1, v1);
        this.linkAfter = phi;
        return this.applyCasts(this.setupResultTemp(phi), expr, valueUsed, yesBranch, noBranch);
    }

    private ITuple[] mergeTargets(ITuple[] t, LabelTuple[] l) {
        ITuple[] res = new ITuple[t.length + l.length];
        System.arraycopy(t, 0, res, 0, t.length);
        System.arraycopy(l, 0, res, t.length, l.length);
        return res;
    }

    private IVal translateMethodCall(AstMethodCallExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        AstExpression[] args = expr.getArguments();
        int nOperands = 1 + (args == null ? 0 : args.length);
        CallTuple t = new CallTuple(nOperands, this.linkAfter, expr);
        int i = 1;
        while (i < nOperands) {
            t.setOperand(i, this.translate(args[i - 1], true, null, null));
            ++i;
        }
        t.setOperand(0, this.translate(expr.getMethodExpression(), true, null, null));
        this.linkAfter = t;
        if (expr.getReferencedElement() instanceof AstMethod) {
            AstTypeReference[] e = ((AstMethod)expr.getReferencedElement()).getExceptionTypes();
            if (e != null && e.length != 0) {
                ITuple[] trgs = new ITuple[e.length];
                int i2 = 0;
                while (i2 < trgs.length) {
                    trgs[i2] = this.stmtTrans.findHandler(e[i2]);
                    ++i2;
                }
                LabelTuple[] lt = this.stmtTrans.exceptions.findErrorHandler();
                this.linkAfter = new PGotoTuple(this.mergeTargets(trgs, lt), this.linkAfter, expr);
            } else {
                ITuple[] lt = this.stmtTrans.exceptions.findErrorHandler();
                if (lt != null && lt.length != 0) {
                    this.linkAfter = new PGotoTuple(lt, this.linkAfter, expr);
                }
            }
        } else {
            ITuple[] lt = this.stmtTrans.exceptions.findErrorHandler();
            if (lt != null && lt.length != 0) {
                this.linkAfter = new PGotoTuple(lt, this.linkAfter, expr);
            }
        }
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateConstructorCall(AstConstructorInvocation expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        AstTypeReference[] e;
        AstExpression[] args = expr.getArguments();
        int nOperands = 1 + (args == null ? 0 : args.length);
        CallTuple t = new CallTuple(nOperands, this.linkAfter, expr);
        int i = 1;
        while (i < nOperands) {
            t.setOperand(i, this.translate(args[i - 1], true, null, null));
            ++i;
        }
        t.setOperand(0, this.applyCasts(this.vt.pseudo(expr.getType()), expr, true, null, null));
        this.linkAfter = t;
        if (expr.getReferencedElement() instanceof AstMethod && (e = ((AstMethod)expr.getReferencedElement()).getExceptionTypes()) != null && e.length != 0) {
            ITuple[] trgs = new ITuple[e.length];
            int i2 = 0;
            while (i2 < trgs.length) {
                trgs[i2] = this.stmtTrans.findHandler(e[i2]);
                ++i2;
            }
            this.linkAfter = new PGotoTuple(trgs, this.linkAfter, expr);
        }
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateNew(AstObjectCreationExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        AstTypeReference[] e;
        AstExpression[] args = expr.getArguments();
        int nOperands = args == null ? 0 : args.length;
        NewTuple t = new NewTuple(nOperands, this.linkAfter, expr);
        int i = 0;
        while (i < nOperands) {
            t.setOperand(i, this.translate(args[i], true, null, null));
            ++i;
        }
        this.linkAfter = t;
        if (expr.getReferencedElement() instanceof AstMethod && (e = ((AstMethod)expr.getReferencedElement()).getExceptionTypes()) != null && e.length != 0) {
            ITuple[] trgs = new ITuple[e.length];
            int i2 = 0;
            while (i2 < trgs.length) {
                trgs[i2] = this.stmtTrans.findHandler(e[i2]);
                ++i2;
            }
            this.linkAfter = new PGotoTuple(trgs, this.linkAfter, expr);
        }
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateNewArray(AstArrayCreationExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        AstExpression[] args = expr.getDimensions();
        int nOperands = args == null ? 0 : args.length;
        NewArrayTuple t = new NewArrayTuple(nOperands, this.linkAfter, expr);
        int i = 0;
        while (i < nOperands) {
            t.setOperand(i, this.translate(args[i], true, null, null));
            ++i;
        }
        AstArrayInitializer initExpr = expr.getInitializer();
        if (initExpr != null) {
            this.translate(initExpr, true, null, null);
        }
        this.linkAfter = t;
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateSimpleReference(AstSimpleReference expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        AstDeclaration decl = expr.getReferencedElement();
        Field fld = decl instanceof AstVariable ? this.theAnalyzer.getFor((AstVariable)decl) : null;
        IVal res = this.vt.findUserVariable(decl);
        if (fld != null) {
            int initType;
            AstExpression initExpr;
            if (res == null) {
                res = this.vt.addMemberVariable((AstVariable)decl, fld);
            }
            if (fld.isFinal() && ((Var)res).getVariableKind() != 2 && (initExpr = fld.getInitializer()) != null && ((initType = ValueTable.translateType(initExpr.getType())) == 1 || initType == 2 || initType == 3 || initType == 4 || initType == 5 || initType == 6 || initType == 7 || initType == 8)) {
                res = this.translate(initExpr, true, null, null);
            }
        } else if (res == null) {
            res = this.vt.pseudo(expr.getType());
        }
        return this.applyCasts(res, expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateFieldReference(AstFieldReference expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        IUserVariable res;
        AstExpression baseExpression = expr.getBaseExpression();
        IVal op = this.translate(baseExpression, true, null, null);
        AstDeclaration dcl = expr.getReferencedElement();
        if (dcl != null && dcl instanceof AstVariable) {
            String name;
            if (ValueTable.translateType(baseExpression.getType()) == 10 && (name = ((AstVariable)dcl).getElementName()) != null && name.equals("length")) {
                LengthTuple t = new LengthTuple(op, this.linkAfter, expr);
                this.linkAfter = t;
                return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
            }
            Field fld = this.theAnalyzer.getFor((AstVariable)dcl);
            if (fld != null) {
                res = this.vt.findUserVariable(dcl);
                if (fld.isFinal()) {
                    AstExpression initExpr;
                    if (res == null) {
                        res = this.vt.addMemberVariable((AstVariable)dcl, fld);
                    }
                    if ((initExpr = fld.getInitializer()) != null && initExpr.isConstant()) {
                        int initType = ValueTable.translateType(initExpr.getType());
                        IVal resv = this.translate(initExpr, true, null, null);
                        return this.applyCasts(resv, expr, valueUsed, yesBranch, noBranch);
                    }
                } else {
                    res = this.vt.pseudo(expr.getType());
                }
            } else {
                res = this.vt.pseudo(expr.getType());
            }
        } else {
            res = this.vt.pseudo(expr.getType());
        }
        MemberAccessTuple t = new MemberAccessTuple(op, res, this.linkAfter, expr);
        this.linkAfter = t;
        return this.applyCasts(this.setupResultTemp(t), expr, valueUsed, yesBranch, noBranch);
    }

    private IVal translateParenthesizedExpression(AstParenthesizedExpression expr, boolean valueUsed, LabelTuple yesBranch, LabelTuple noBranch) {
        AstExpression expr1 = expr.getExpression();
        if (valueUsed && expr.getRuntimeType() != expr1.getRuntimeType()) {
            return this.applyCasts(this.translate(expr1, true, null, null), expr, valueUsed, yesBranch, noBranch);
        }
        return this.translate(expr1, valueUsed, yesBranch, noBranch);
    }

    private IVal translateTypeExpression(AstTypeExpression expr) {
        return new TypeConstant(expr.getType());
    }

    private IVal translateArrayInitializer(AstArrayInitializer expr) {
        AstExpression[] exprList = expr.getInitializers();
        int i = 0;
        while (i < exprList.length) {
            IVal v = this.translate(exprList[i], true, null, null);
            if (v instanceof TempVariable) {
                TempVariable tv = (TempVariable)v;
                Tuple t = (Tuple)tv.sourceTuple();
                t.setAsUsed();
            }
            ++i;
        }
        return this.vt.pseudo(expr.getType());
    }

    private ITempVariable setupResultTemp(ExprTuple exprTuple) {
        ITempVariable temp = this.vt.addTempVariable(exprTuple.backEndType(), exprTuple);
        exprTuple.setResultVar(temp);
        return temp;
    }

    final ITuple getLinkAfter() {
        return this.linkAfter;
    }

    AST_Expr_Translator(AST_Stmt_Translator stmtTrans, ValueTable vt, ITuple linkAfter, DataFlowAnalyzer theAnalyzer) {
        this.vt = vt;
        this.stmtTrans = stmtTrans;
        this.linkAfter = linkAfter;
        this.theAnalyzer = theAnalyzer;
    }
}

