/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.dataflow.INamedUnit;
import com.togethersoft.sca.dataflow.IPackage;
import com.togethersoft.sca.dataflow.IProject;
import com.togethersoft.sca.internal.dataflow.Behavior;
import com.togethersoft.sca.internal.dataflow.ClassUnit;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.NamedUnit;
import com.togethersoft.sca.internal.dataflow.NamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Package;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class Project
extends NamespaceUnit
implements IProject {
    protected int[] attributeAreaSizes;
    private static final int hashTableSize = 10240;
    protected Hashtable astToUnit = new Hashtable(10240);
    protected Field fieldList;
    protected Method methodList;
    protected ClassUnit classList;
    private IPackage defaultPackage;
    private DataFlowAnalyzer theAnalyzer;
    protected Method[][] recursiveLoops;
    protected int numberOfMethods;
    protected int markBase;

    public int unitKind() {
        return 0;
    }

    public IPackage defaultPackage() {
        return this.defaultPackage;
    }

    public IPackage[] packages() {
        int nItems = 0;
        if (this.subUnits != null) {
            int i = 0;
            while (i < this.subUnits.length) {
                if (this.subUnits[i].unitKind() == 1) {
                    ++nItems;
                }
                ++i;
            }
        }
        if (nItems == 0) {
            return null;
        }
        int resIdx = 0;
        IPackage[] res = new IPackage[nItems];
        int i = 0;
        while (i < this.subUnits.length) {
            if (this.subUnits[i].unitKind() == 1) {
                res[resIdx] = (IPackage)this.subUnits[i];
                ++resIdx;
            }
            ++i;
        }
        return res;
    }

    public Project(DataFlowAnalyzer theAnalyzer) {
        super(null, "The whole project", null, 0, 0, null);
        this.theAnalyzer = theAnalyzer;
        this.attributeAreaSizes = new int[6];
    }

    public final void update(AstCompilationUnit[] deleted, AstCompilationUnit[] added, AstCompilationUnit[] changedInterfaceOld, AstCompilationUnit[] changedInterfaceNew, AstCompilationUnit[] changedBody) {
        this.removeUnitsFor(deleted);
        this.removeUnitsFor(changedInterfaceOld);
        this.removeUnitsFor(changedBody);
        this.ageAll();
        this.addUnitsFor(added);
        this.addUnitsFor(changedInterfaceNew);
        this.addUnitsFor(changedBody);
    }

    public void ageAll() {
        Enumeration e = this.astToUnit.elements();
        while (e.hasMoreElements()) {
            NamedUnit nu = (NamedUnit)e.nextElement();
            if (nu.updateState == 2) {
                System.err.println(" I N V A L I D named unit in global list :" + nu.name());
            }
            nu.updateState = 1;
        }
    }

    private final void dumpCompUnits(String header, AstCompilationUnit[] u, PrintStream out) {
        out.println(header);
        int i = 0;
        while (i < u.length) {
            out.println(u[i].getElementName());
            ++i;
        }
    }

    private final void removeUnitsFor(AstCompilationUnit[] u) {
        int i = 0;
        while (i < u.length) {
            NamedUnit.removeFor(this, u[i]);
            ++i;
        }
    }

    private final void addUnitsFor(AstCompilationUnit[] u) {
        int i = 0;
        while (i < u.length) {
            Package.addCompilationUnit(this, u[i]);
            ++i;
        }
    }

    public void loadModel(AstModel model) {
        AstPackage[] packages = model.getPackages();
        AstPackage defPkg = model.getDefaultPackage();
        this.cleanup();
        if (packages != null) {
            this.subUnits = new INamedUnit[packages.length];
            int i = 0;
            while (i < packages.length) {
                if (defPkg == packages[i]) {
                    this.defaultPackage = new Package(packages[i], this);
                    this.subUnits[i] = this.defaultPackage;
                } else {
                    this.subUnits[i] = new Package(packages[i], this);
                }
                ++i;
            }
        }
    }

    public int reserveSlot(int uKind) {
        int slotNo = this.attributeAreaSizes[uKind];
        int n = uKind;
        this.attributeAreaSizes[n] = this.attributeAreaSizes[n] + 1;
        return slotNo;
    }

    public void releaseSlot(int uKind, int slotNo) {
        int n = uKind;
        this.attributeAreaSizes[n] = this.attributeAreaSizes[n] - 1;
    }

    void cleanup() {
        this.astToUnit.clear();
        this.fieldList = null;
        this.methodList = null;
        this.classList = null;
        this.recursiveLoops = null;
        this.markBase = 0;
        this.numberOfMethods = 0;
    }

    public Package getFor(AstPackage pkg) {
        Object res = this.astToUnit.get(pkg);
        if (res == null) {
            return null;
        }
        return (Package)res;
    }

    public Behavior getFor(AstType typ) {
        Object res = this.astToUnit.get(typ);
        if (res == null) {
            return null;
        }
        return (Behavior)res;
    }

    public Field getFor(AstVariable fld) {
        Object res = this.astToUnit.get(fld);
        if (res == null) {
            return null;
        }
        return (Field)res;
    }

    public Method getFor(AstMethod mth) {
        Object res = this.astToUnit.get(mth);
        if (res == null) {
            return null;
        }
        return (Method)res;
    }

    public Method getFor(AstInitializer mth) {
        Object res = this.astToUnit.get(mth);
        if (res == null) {
            return null;
        }
        return (Method)res;
    }

    public int getNumberOfMethods() {
        return this.numberOfMethods;
    }

    public Field fieldList() {
        return this.fieldList;
    }

    public Method methodList() {
        return this.methodList;
    }

    public ClassUnit classList() {
        return this.classList;
    }

    public DataFlowAnalyzer getAnalyzer() {
        return this.theAnalyzer;
    }

    public Method[][] getRecursiveLoops() {
        return this.recursiveLoops;
    }

    public Enumeration namedUnits() {
        return this.astToUnit.elements();
    }
}

