/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstClassFile;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.dataflow.IClass;
import com.togethersoft.sca.dataflow.IInterface;
import com.togethersoft.sca.dataflow.INamedUnit;
import com.togethersoft.sca.dataflow.IPackage;
import com.togethersoft.sca.internal.dataflow.Behavior;
import com.togethersoft.sca.internal.dataflow.ClassUnit;
import com.togethersoft.sca.internal.dataflow.InterfaceUnit;
import com.togethersoft.sca.internal.dataflow.NamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Project;

public class Package
extends NamespaceUnit
implements IPackage {
    public int unitKind() {
        return 1;
    }

    public IPackage[] subpackages() {
        int nItems = 0;
        if (this.subUnits != null) {
            int i = 0;
            while (i < this.subUnits.length) {
                if (this.subUnits[i].unitKind() == 1) {
                    ++nItems;
                }
                ++i;
            }
        }
        if (nItems == 0) {
            return null;
        }
        int resIdx = 0;
        IPackage[] res = new IPackage[nItems];
        int i = 0;
        while (i < this.subUnits.length) {
            if (this.subUnits[i].unitKind() == 1) {
                res[resIdx] = (IPackage)this.subUnits[i];
                ++resIdx;
            }
            ++i;
        }
        return res;
    }

    public IClass[] classes() {
        int nItems = 0;
        if (this.subUnits != null) {
            int i = 0;
            while (i < this.subUnits.length) {
                if (this.subUnits[i].unitKind() == 2) {
                    ++nItems;
                }
                ++i;
            }
        }
        if (nItems == 0) {
            return null;
        }
        int resIdx = 0;
        IClass[] res = new IClass[nItems];
        int i = 0;
        while (i < this.subUnits.length) {
            if (this.subUnits[i].unitKind() == 2) {
                res[resIdx] = (IClass)this.subUnits[i];
                ++resIdx;
            }
            ++i;
        }
        return res;
    }

    public IInterface[] interfaces() {
        int nItems = 0;
        if (this.subUnits != null) {
            int i = 0;
            while (i < this.subUnits.length) {
                if (this.subUnits[i].unitKind() == 3) {
                    ++nItems;
                }
                ++i;
            }
        }
        if (nItems == 0) {
            return null;
        }
        int resIdx = 0;
        IInterface[] res = new IInterface[nItems];
        int i = 0;
        while (i < this.subUnits.length) {
            if (this.subUnits[i].unitKind() == 3) {
                res[resIdx] = (IInterface)this.subUnits[i];
                ++resIdx;
            }
            ++i;
        }
        return res;
    }

    public Package(AstPackage pkg, NamespaceUnit nameScope) {
        super(pkg, pkg.getElementName(), nameScope, 0, 0, null);
        AstPackage[] packages = pkg.getSubpackages();
        AstCompilationUnit[] units = pkg.getCompilationUnits();
        AstClassFile[] classFiles = pkg.getClassFiles();
        AstType[] extTypes = new AstType[classFiles.length];
        int i = 0;
        while (i < classFiles.length) {
            extTypes[i] = classFiles[i].getType();
            ++i;
        }
        int nSubUnits = packages == null ? 0 : packages.length;
        nSubUnits += extTypes.length;
        if (units != null) {
            int i2 = 0;
            while (i2 < units.length) {
                AstType[] types = units[i2].getTypes();
                if (types != null) {
                    nSubUnits += types.length;
                }
                ++i2;
            }
        }
        if (nSubUnits != 0) {
            int subUnitsIdx = 0;
            this.subUnits = new INamedUnit[nSubUnits];
            if (packages != null) {
                int i3 = 0;
                while (i3 < packages.length) {
                    this.subUnits[subUnitsIdx] = new Package(packages[i3], this);
                    ++subUnitsIdx;
                    ++i3;
                }
            }
            if (extTypes != null) {
                int j = 0;
                while (j < extTypes.length) {
                    Behavior u = extTypes[j].isClass() ? new ClassUnit(extTypes[j], this, null) : new InterfaceUnit(extTypes[j], this, null);
                    this.subUnits[subUnitsIdx] = u;
                    ++subUnitsIdx;
                    ++j;
                }
            }
            if (units != null) {
                int i4 = 0;
                while (i4 < units.length) {
                    AstType[] types = units[i4].getTypes();
                    if (types != null) {
                        int j = 0;
                        while (j < types.length) {
                            Behavior u = types[j].isClass() ? new ClassUnit(types[j], this, units[i4]) : new InterfaceUnit(types[j], this, units[i4]);
                            this.subUnits[subUnitsIdx] = u;
                            ++subUnitsIdx;
                            ++j;
                        }
                    }
                    ++i4;
                }
            }
        }
    }

    private void addCompilationUnit1(AstCompilationUnit unit) {
        AstType[] types = unit.getTypes();
        if (types != null) {
            int j = 0;
            while (j < types.length) {
                Behavior u = types[j].isClass() ? new ClassUnit(types[j], this, unit) : new InterfaceUnit(types[j], this, unit);
                this.addSubUnit(u);
                ++j;
            }
        }
    }

    private Package(AstPackage pkg, NamespaceUnit nameScope, boolean nlp) {
        super(pkg, pkg.getElementName(), nameScope, 0, 0, null);
        nameScope.addSubUnit(this);
    }

    private static Package getPackage(Project prj, AstPackage pkg) {
        Package p = prj.getFor(pkg);
        if (p == null) {
            AstObject obj = pkg.getParent();
            p = obj instanceof AstPackage ? new Package(pkg, (NamespaceUnit)((Object)obj), true) : new Package(pkg, prj, true);
        }
        return p;
    }

    static void addCompilationUnit(Project prj, AstCompilationUnit unit) {
        Package p = Package.getPackage(prj, (AstPackage)unit.getParent());
        p.addCompilationUnit1(unit);
    }
}

