/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.INamedUnit;
import com.togethersoft.sca.dataflow.INamespaceUnit;
import com.togethersoft.sca.internal.dataflow.NamedUnit;

public abstract class NamespaceUnit
extends NamedUnit
implements INamespaceUnit {
    protected INamedUnit[] subUnits = null;

    public INamedUnit[] find(String name) {
        int nItems = 0;
        if (this.subUnits != null) {
            int i = 0;
            while (i < this.subUnits.length) {
                if (name.equals(this.subUnits[i].name())) {
                    ++nItems;
                }
                ++i;
            }
        }
        if (nItems == 0) {
            return null;
        }
        INamedUnit[] units = new INamedUnit[nItems];
        int idx = 0;
        int i = 0;
        while (i < this.subUnits.length) {
            if (name.equals(this.subUnits[i].name())) {
                units[idx++] = this.subUnits[i];
            }
            ++i;
        }
        return units;
    }

    public INamedUnit[] getAll() {
        return this.subUnits;
    }

    void removeMe(NamedUnit unit) {
        if (this.subUnits != null) {
            int i = 0;
            while (i < this.subUnits.length) {
                if (this.subUnits[i] == unit) {
                    INamedUnit[] nUnits = new INamedUnit[this.subUnits.length - 1];
                    System.arraycopy(this.subUnits, 0, nUnits, 0, i);
                    System.arraycopy(this.subUnits, i, nUnits, i + 1, this.subUnits.length - i - 1);
                    this.subUnits = nUnits;
                    break;
                }
                ++i;
            }
        }
    }

    void addSubUnit(NamedUnit unit) {
        if (this.subUnits == null) {
            this.subUnits = new INamedUnit[]{unit};
        } else {
            INamedUnit[] nUnits = new INamedUnit[this.subUnits.length + 1];
            System.arraycopy(this.subUnits, 0, nUnits, 0, this.subUnits.length);
            nUnits[this.subUnits.length] = unit;
            this.subUnits = nUnits;
        }
    }

    protected NamespaceUnit(AstObject astNode, String nameVal, NamespaceUnit scopeVal, int accessTypeVal, int modifiersVal, AstCompilationUnit compilationUnitVal) {
        super(astNode, nameVal, scopeVal, accessTypeVal, modifiersVal, compilationUnitVal);
    }
}

