/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.INamedUnit;
import com.togethersoft.sca.dataflow.INamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Attribute;
import com.togethersoft.sca.internal.dataflow.NamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Project;
import java.util.Enumeration;

public abstract class NamedUnit
implements INamedUnit {
    private AstObject astNode;
    private String name;
    private NamespaceUnit scope;
    private AstCompilationUnit compilationUnit;
    private short accessType;
    private short modifiers;
    protected int updateState;
    public static final int VALID = 1;
    public static final int INVALID = 2;
    public static final int CREATED = 3;
    public static final int MODIFIED = 4;
    private Attribute[] attributes;

    public abstract int unitKind();

    public final String name() {
        return this.name;
    }

    public INamespaceUnit scope() {
        return this.scope;
    }

    public int accessType() {
        return this.accessType;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean isAbstract() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isStrictfp() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isTransient() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isVolatile() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & 0x80) != 0;
    }

    static int decodeAstAccess(int astAccess) {
        if ((astAccess & 2) != 0) {
            return 3;
        }
        if ((astAccess & 4) != 0) {
            return 2;
        }
        if ((astAccess & 1) != 0) {
            return 1;
        }
        return 0;
    }

    static int decodeAstModifiers(int astModifiers) {
        int unitModifiers = 0;
        if ((astModifiers & 8) != 0) {
            unitModifiers = 8;
        }
        if ((astModifiers & 0x10) != 0) {
            unitModifiers |= 2;
        }
        if ((astModifiers & 0x20) != 0) {
            unitModifiers |= 0x80;
        }
        if ((astModifiers & 0x40) != 0) {
            unitModifiers |= 0x20;
        }
        if ((astModifiers & 0x80) != 0) {
            unitModifiers |= 0x10;
        }
        if ((astModifiers & 0x100) != 0) {
            unitModifiers |= 0x40;
        }
        if ((astModifiers & 0x400) != 0) {
            unitModifiers |= 1;
        }
        if ((astModifiers & 0x800) != 0) {
            unitModifiers |= 4;
        }
        return unitModifiers;
    }

    public AstObject getAstObject() {
        return this.astNode;
    }

    protected NamedUnit(AstObject astNode, String nameVal, NamespaceUnit scopeVal, int accessTypeVal, int modifiersVal, AstCompilationUnit compilationUnitVal) {
        int nOfAttributes;
        this.astNode = astNode;
        this.name = nameVal;
        this.scope = scopeVal;
        this.accessType = (short)accessTypeVal;
        this.modifiers = (short)modifiersVal;
        this.compilationUnit = compilationUnitVal;
        Project theProject = this.getProject();
        if (astNode != null) {
            theProject.astToUnit.put(astNode, this);
        }
        this.updateState = 3;
        if (this.unitKind() != 0 && (nOfAttributes = theProject.attributeAreaSizes[this.unitKind()]) != 0) {
            this.attributes = new Attribute[nOfAttributes];
        }
    }

    public final AstCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void remove() {
        this.getProject().astToUnit.remove(this.astNode);
        if (this.scope != null) {
            this.scope.removeMe(this);
        }
        this.updateState = 2;
    }

    public static void removeFor(Project prj, AstCompilationUnit unit) {
        String eName = unit.getElementName();
        Enumeration e = prj.astToUnit.elements();
        while (e.hasMoreElements()) {
            NamedUnit nu = (NamedUnit)e.nextElement();
            AstCompilationUnit u = nu.getCompilationUnit();
            if (u == null || !eName.equals(u.getElementName())) continue;
            nu.remove();
        }
    }

    public final Project getProject() {
        NamedUnit unit = this;
        while (unit.scope != null) {
            unit = unit.scope;
        }
        return (Project)unit;
    }

    public Attribute getAttribute(int n) {
        return this.attributes[n];
    }

    public void setAttribute(int n, Attribute val) {
        this.attributes[n] = val;
    }

    final void expandAttributeArea() {
        if (this.attributes == null) {
            this.attributes = new Attribute[1];
        } else {
            Attribute[] na = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, na, 0, this.attributes.length);
            this.attributes = na;
        }
    }

    final void removeAttributeSlot(int slotNo) {
        int nAttr = this.attributes.length;
        if (nAttr == 1) {
            this.attributes = null;
        } else {
            Attribute[] na = new Attribute[nAttr - 1];
            System.arraycopy(this.attributes, 0, na, 0, slotNo);
            System.arraycopy(this.attributes, slotNo + 1, na, slotNo, nAttr - slotNo - 1);
            this.attributes = na;
        }
    }

    public final int getUpdateState() {
        return this.updateState;
    }

    public final boolean isValid() {
        return this.updateState == 1;
    }

    public final boolean isInvalid() {
        return this.updateState == 2;
    }

    public final boolean wasCreated() {
        return this.updateState == 3;
    }

    public final boolean wasModified() {
        return this.updateState == 4;
    }

    protected final void setAsValid() {
        this.updateState = 1;
    }

    protected final void setAsModified() {
        this.updateState = 4;
    }
}

