/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitorAdapter;
import com.togethersoft.sca.ast.visitor.AstStatementVisitorAdapter;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.dataflow.flowgraph.IDataFlowGraph;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.Behavior;
import com.togethersoft.sca.internal.dataflow.ClassUnit;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.InterfaceUnit;
import com.togethersoft.sca.internal.dataflow.Member;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.NamedUnit;
import com.togethersoft.sca.internal.dataflow.NamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.DataFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.ValueTable;
import com.togethersoft.sca.internal.dataflow.known.KnownMethod;
import com.togethersoft.sca.internal.dataflow.values.ValueDomain;
import java.io.PrintStream;

public class Method
extends Member
implements IMethod {
    private DataFlowGraph theDFG;
    private boolean inForeverRecursion;
    private boolean inRecursiveLoop;
    private boolean visited;
    private boolean immediateSideEffect;
    private boolean sideEffect;
    private boolean isReachable;
    private boolean isClassInitializer;
    private boolean isGetterVal;
    private boolean isSetterVal;
    private boolean isEmptyVal;
    private boolean callsExternal;
    private IMethod[] callees;
    private IMethod[] callers;
    private IMethod[] callsAlways;
    private IMethod[] callsAlwaysClosure;
    private AstTypeReference[] exceptionsRaised;
    private AstTypeReference[] exceptionsDeclared;
    private Field[] fieldsReferenced;
    private boolean needsUpdateVal;
    private IValueDomain resultDomain;
    private IValueDomain nResultDomain;
    private boolean resultDomainChanged;
    private boolean resultTrackable;
    private IValueDomain[] parameterDomain;
    private boolean parameterDomainTrackable;
    private boolean parameterDomainChanged;
    public Method[] overrideClosure;
    private Method next;
    private int methodId;
    public boolean hasBody;
    private int mark;
    private ITuple[] recursiveCalls;
    public KnownMethod extraInfo;
    Behavior[] subclasses;

    public int unitKind() {
        return 5;
    }

    public boolean isClassInitializer() {
        return this.isClassInitializer;
    }

    public boolean bodyPresent() {
        return this.hasBody;
    }

    public boolean callsUnknown() {
        return this.callsExternal;
    }

    private void setCallsUnknown() {
        this.callsExternal = true;
    }

    private void initMethod() {
        Project prj = this.getProject();
        this.hasBody = false;
        this.next = prj.methodList;
        prj.methodList = this;
        this.methodId = prj.numberOfMethods++;
        this.isReachable = false;
        this.isSetterVal = false;
        this.isGetterVal = false;
        AstMethod meth = (AstMethod)this.getAstObject();
        AstTypeReference[] e = meth.getExceptionTypes();
        if (e != null && e.length != 0) {
            this.exceptionsDeclared = e;
        }
        this.resultDomainChanged = false;
        this.resultTrackable = meth.isFinal() || !meth.isPublic();
        AstVariable[] v = meth.getParameters();
        this.parameterDomain = new IValueDomain[v.length];
        this.parameterDomainChanged = false;
        this.parameterDomainTrackable = meth.getBody() == null ? false : !meth.isPublic() && !meth.isProtected();
    }

    private final void scanMethodBodyForInnerTypes(AstMethod mth) {
        AstCompoundStatement body = mth.getBody();
        if (body == null) {
            return;
        }
        class StmtVisitor
        extends AstStatementVisitorAdapter {
            Method m;
            private final /* synthetic */ Method this$0;

            StmtVisitor(Method this$0, Method m) {
                this.this$0 = this$0;
                this.m = m;
            }

            public void visitDeclarationStatement(AstDeclarationStatement stmt) {
                AstDeclaration[] decl = stmt.getDeclarations();
                int i = 0;
                while (i < decl.length) {
                    AstDeclaration currDecl = decl[i];
                    if (currDecl instanceof AstType) {
                        AstType tp = (AstType)currDecl;
                        NamespaceUnit nu = (NamespaceUnit)this.m.scope();
                        if (tp.isClass()) {
                            this.m.pushSubclass(new ClassUnit(tp, nu, nu.getCompilationUnit()));
                        } else {
                            this.m.pushSubclass(new InterfaceUnit(tp, nu, nu.getCompilationUnit()));
                        }
                    }
                    ++i;
                }
            }
        }
        body.visitStatements(new StmtVisitor(this, this));
        class ExprVisitor
        extends AstExpressionVisitorAdapter {
            Method m;
            private final /* synthetic */ Method this$0;

            ExprVisitor(Method this$0, Method m) {
                this.this$0 = this$0;
                this.m = m;
            }

            public void visitObjectCreationExpression(AstObjectCreationExpression expr) {
                AstType tp = expr.getClassBody();
                if (tp != null) {
                    NamespaceUnit nu = (NamespaceUnit)this.m.scope();
                    if (tp.isClass()) {
                        this.m.pushSubclass(new ClassUnit(tp, nu, nu.getCompilationUnit()));
                    } else {
                        this.m.pushSubclass(new InterfaceUnit(tp, nu, nu.getCompilationUnit()));
                    }
                }
            }
        }
        body.visitExpressions(new ExprVisitor(this, this));
    }

    public Method(AstMethod methDecl, NamespaceUnit nameScope) {
        super(methDecl, methDecl.getElementName(), nameScope, NamedUnit.decodeAstAccess(methDecl.getModifiers()), NamedUnit.decodeAstModifiers(methDecl.getModifiers()));
        this.isClassInitializer = false;
        this.initMethod();
        this.scanMethodBodyForInnerTypes(methDecl);
    }

    public Method(AstInitializer methDecl, NamespaceUnit nameScope) {
        super(methDecl, methDecl.getElementName(), nameScope, NamedUnit.decodeAstAccess(methDecl.getModifiers()), NamedUnit.decodeAstModifiers(methDecl.getModifiers()));
        this.isClassInitializer = true;
        this.initMethod();
        this.scanMethodBodyForInnerTypes(methDecl);
    }

    public void pushCallee(IMethod meth) {
        block6: {
            if (meth == null) {
                this.setCallsUnknown();
                return;
            }
            if (this.callees != null) {
                int i = 0;
                while (i < this.callees.length) {
                    if (this.callees[i] != meth) {
                        ++i;
                        continue;
                    }
                    break block6;
                }
                IMethod[] newCallees = new IMethod[this.callees.length + 1];
                int i2 = 0;
                while (i2 < this.callees.length) {
                    newCallees[i2] = this.callees[i2];
                    ++i2;
                }
                this.callees = newCallees;
            } else {
                this.callees = new IMethod[1];
            }
            this.callees[this.callees.length - 1] = meth;
        }
        ((Method)meth).pushCaller(this);
    }

    public void pushAlwaysCallee(IMethod meth) {
        if (meth == null) {
            return;
        }
        if (this.callsAlways != null) {
            int i = 0;
            while (i < this.callsAlways.length) {
                if (this.callsAlways[i] == meth) {
                    return;
                }
                ++i;
            }
            IMethod[] newCallsAlways = new IMethod[this.callsAlways.length + 1];
            int i2 = 0;
            while (i2 < this.callsAlways.length) {
                newCallsAlways[i2] = this.callsAlways[i2];
                ++i2;
            }
            this.callsAlways = newCallsAlways;
        } else {
            this.callsAlways = new IMethod[1];
        }
        this.callsAlways[this.callsAlways.length - 1] = meth;
    }

    private boolean pushAlwaysCalleeClosure(IMethod meth) {
        if (meth == null) {
            return false;
        }
        if (this.callsAlwaysClosure != null) {
            int i = 0;
            while (i < this.callsAlwaysClosure.length) {
                if (this.callsAlwaysClosure[i] == meth) {
                    return false;
                }
                ++i;
            }
            IMethod[] newCallsAlwaysClosure = new IMethod[this.callsAlwaysClosure.length + 1];
            int i2 = 0;
            while (i2 < this.callsAlwaysClosure.length) {
                newCallsAlwaysClosure[i2] = this.callsAlwaysClosure[i2];
                ++i2;
            }
            this.callsAlwaysClosure = newCallsAlwaysClosure;
        } else {
            this.callsAlwaysClosure = new IMethod[1];
        }
        this.callsAlwaysClosure[this.callsAlwaysClosure.length - 1] = meth;
        return true;
    }

    public static void computeCallsAlwaysClosure(Project prj) {
        boolean changed;
        Method m = prj.methodList;
        while (m != null) {
            m.callsAlwaysClosure = m.callsAlways;
            m = m.getNext();
        }
        do {
            changed = false;
            Method m2 = prj.methodList;
            while (m2 != null) {
                if (m2.callsAlways != null) {
                    int i = 0;
                    while (i < m2.callsAlways.length) {
                        Method meth = (Method)m2.callsAlways[i];
                        if (meth.callsAlwaysClosure != null) {
                            int j = 0;
                            while (j < meth.callsAlwaysClosure.length) {
                                changed |= m2.pushAlwaysCalleeClosure(meth.callsAlwaysClosure[j]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                m2 = m2.getNext();
            }
        } while (changed);
    }

    private void pushCaller(IMethod meth) {
        if (this.callers != null) {
            int i = 0;
            while (i < this.callers.length) {
                if (this.callers[i] == meth) {
                    return;
                }
                ++i;
            }
            IMethod[] newCallers = new IMethod[this.callers.length + 1];
            int i2 = 0;
            while (i2 < this.callers.length) {
                newCallers[i2] = this.callers[i2];
                ++i2;
            }
            this.callers = newCallers;
        } else {
            this.callers = new IMethod[1];
        }
        this.callers[this.callers.length - 1] = meth;
    }

    public void pushExceptionRaise(AstTypeReference exc) {
        if (this.exceptionsRaised != null) {
            int i = 0;
            while (i < this.exceptionsRaised.length) {
                if (this.exceptionsRaised[i] == exc) {
                    return;
                }
                ++i;
            }
            AstTypeReference[] newExceptionsRaised = new AstTypeReference[this.exceptionsRaised.length + 1];
            int i2 = 0;
            while (i2 < this.exceptionsRaised.length) {
                newExceptionsRaised[i2] = this.exceptionsRaised[i2];
                ++i2;
            }
            this.exceptionsRaised = newExceptionsRaised;
        } else {
            this.exceptionsRaised = new AstTypeReference[1];
        }
        this.exceptionsRaised[this.exceptionsRaised.length - 1] = exc;
    }

    String location() {
        if (this.getAstObject() != null) {
            return this.getAstObject().getPosition().getFileName();
        }
        return "????";
    }

    void print(PrintStream out) {
        int i;
        out.println("Method #" + this.methodId + " (" + this.name() + ")" + " class initializer = " + this.isClassInitializer + " has body = " + this.hasBody + " reachable = " + this.isReachable + " non triv recursive = " + (this.recursiveCalls != null));
        out.println(" . Getter = " + this.isGetterVal + " Setter = " + this.isSetterVal + " Empty = " + this.isEmptyVal + " SideEffects = " + this.sideEffect + " calls Unknown = " + this.callsUnknown());
        out.print(" . Callees = ");
        if (this.callees != null) {
            i = 0;
            while (i < this.callees.length) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print(((Method)this.callees[i]).getMethodId());
                ++i;
            }
            out.println();
        } else {
            out.println("none");
        }
        out.print(" . Callers = ");
        if (this.callers != null) {
            i = 0;
            while (i < this.callers.length) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print(((Method)this.callers[i]).getMethodId());
                ++i;
            }
            out.println();
        } else {
            out.println("none");
        }
        out.print(" . Calls Always = ");
        if (this.callsAlways != null) {
            i = 0;
            while (i < this.callsAlways.length) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print(((Method)this.callsAlways[i]).getMethodId());
                ++i;
            }
            out.println();
        } else {
            out.println("none");
        }
    }

    public static void printAll(Project prj, PrintStream out) {
        Method meth = prj.methodList;
        while (meth != null) {
            meth.print(out);
            meth = meth.next;
        }
    }

    public static void printAllRecursuve(Project prj, PrintStream out) {
        Method meth = prj.methodList;
        while (meth != null) {
            if (meth.recursiveCalls != null) {
                meth.print(out);
            }
            meth = meth.next;
        }
    }

    public static void printInfiniteRecursionInfo(Project prj, PrintStream out) {
        if (prj.recursiveLoops == null) {
            out.println("No infinite recursion detected");
        } else {
            out.println("Infinite recursion detected:");
            int i = 0;
            while (i < prj.recursiveLoops.length) {
                out.println(" . Loop[" + i + "]");
                Method[] m = prj.recursiveLoops[i];
                int j = 0;
                while (j < m.length) {
                    out.println(m[j].name() + ":");
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void markUnreachableMethods(Method methodList) {
        Method m = methodList;
        while (m != null) {
            m.isReachable = m.accessType() != 3;
            m = m.getNext();
        }
        Method m2 = methodList;
        while (m2 != null) {
            if (m2.isReachable) {
                m2.markReachableClosure();
            }
            m2 = m2.getNext();
        }
    }

    private final void markReachableClosure() {
        this.isReachable = true;
        if (this.callees != null) {
            int i = 0;
            while (i < this.callees.length) {
                Method mc = (Method)this.callees[i];
                if (!mc.isReachable) {
                    mc.markReachableClosure();
                }
                ++i;
            }
        }
    }

    public static void processGlobalExceptionInfo(Method methodList) {
        Method m = methodList;
        while (m != null) {
            m.exceptionsRaised = !m.hasBody ? m.exceptionsDeclared : m.getDFG().exceptions.computeRaisedExceptions();
            m.visited = false;
            m = m.getNext();
        }
        Method m2 = methodList;
        while (m2 != null) {
            if (!m2.visited) {
                m2.computeCallsUnknownClosure();
            }
            m2 = m2.getNext();
        }
        Method m3 = methodList;
        while (m3 != null) {
            m3.visited = false;
            m3 = m3.getNext();
        }
    }

    private final boolean computeCallsUnknownClosure() {
        this.visited = true;
        if (!this.callsUnknown() && this.callees != null) {
            int i = 0;
            while (i < this.callees.length) {
                Method meth = (Method)this.callees[i];
                if (!meth.visited && meth.computeCallsUnknownClosure()) {
                    this.callsExternal = true;
                    break;
                }
                ++i;
            }
        }
        return this.callsExternal;
    }

    public static void findMethodsGeneratingSideEffects(Project prj) {
        boolean changed;
        Method m = prj.methodList;
        while (m != null) {
            if (!m.hasBody) {
                if (m.extraInfo != null && !m.extraInfo.hasSideEffect()) {
                    m.sideEffect = false;
                } else {
                    m.setAsProducingSideEffect();
                }
            }
            m.sideEffect = m.immediateSideEffect;
            m = m.getNext();
        }
        do {
            changed = false;
            Method m2 = prj.methodList;
            while (m2 != null) {
                if (!m2.sideEffect && m2.callees != null) {
                    int i = 0;
                    while (i < m2.callees.length) {
                        if (((Method)m2.callees[i]).sideEffect) {
                            m2.sideEffect = true;
                            changed = true;
                            break;
                        }
                        ++i;
                    }
                }
                m2 = m2.getNext();
            }
        } while (changed);
    }

    public AstTypeReference[] getExceptions() {
        return this.exceptionsRaised;
    }

    public AstTypeReference[] getExceptionsDeclared() {
        return this.exceptionsDeclared;
    }

    public boolean isGetter() {
        return this.isGetterVal;
    }

    public boolean isSetter() {
        return this.isSetterVal;
    }

    public boolean isEmpty() {
        return this.isEmptyVal;
    }

    public void setAsEmpty() {
        this.isEmptyVal = true;
    }

    public void setAsSetter() {
        this.isSetterVal = true;
    }

    public void setAsGetter() {
        this.isGetterVal = true;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public Method getNext() {
        return this.next;
    }

    public boolean isReachable() {
        return this.isReachable;
    }

    public boolean hasSideEffect() {
        return this.sideEffect;
    }

    public void setAsProducingSideEffect() {
        this.immediateSideEffect = true;
    }

    public ITuple[] getRecursiveCalls() {
        return this.recursiveCalls;
    }

    public static void detectForeverRecursiveLoops(Project prj) {
        Method m = prj.methodList;
        while (m != null) {
            m.inForeverRecursion = false;
            m.visited = false;
            m = m.getNext();
        }
        Method[] stack = new Method[prj.numberOfMethods];
        Method m2 = prj.methodList;
        while (m2 != null) {
            if (!m2.visited && m2.markRecursion(stack, 0)) {
                Method.pushRecursiveLoop(prj, Method.extractLoop(stack));
            }
            m2 = m2.getNext();
        }
        Method.computeCallsAlwaysClosure(prj);
        Method m3 = prj.methodList;
        while (m3 != null) {
            if (!m3.inRecursiveLoop && m3.theDFG != null) {
                m3.recursiveCalls = m3.theDFG.detectRecursiveCalls(m3);
            }
            m3 = m3.getNext();
        }
        Method m4 = prj.methodList;
        while (m4 != null) {
            m4.callsAlways = null;
            m4.callsAlwaysClosure = null;
            m4 = m4.getNext();
        }
    }

    private boolean markRecursion(Method[] stack, int sp) {
        if (this.inForeverRecursion) {
            stack[sp] = null;
            return true;
        }
        if (!this.visited) {
            this.visited = true;
            if (this.callsAlways != null) {
                this.inForeverRecursion = true;
                stack[sp] = this;
                int i = 0;
                while (i < this.callsAlways.length) {
                    if (((Method)this.callsAlways[i]).markRecursion(stack, sp + 1)) {
                        return true;
                    }
                    ++i;
                }
            }
            this.inForeverRecursion = false;
        }
        return false;
    }

    private static Method[] extractLoop(Method[] array) {
        int start = 0;
        while (!array[start].inForeverRecursion) {
            ++start;
        }
        int end = start;
        while (array[end] != null) {
            ++end;
        }
        int size = end - start;
        Method[] loop = new Method[size];
        int i = 0;
        while (i < size) {
            loop[i] = array[i + start];
            loop[i].inRecursiveLoop = true;
            ++i;
        }
        return loop;
    }

    private static void pushRecursiveLoop(Project prj, Method[] loop) {
        if (prj.recursiveLoops == null) {
            prj.recursiveLoops = new Method[1][];
        } else {
            Method[][] newRecursiveLoops = new Method[prj.recursiveLoops.length + 1][];
            int i = 0;
            while (i < prj.recursiveLoops.length) {
                newRecursiveLoops[i] = prj.recursiveLoops[i];
                ++i;
            }
            prj.recursiveLoops = newRecursiveLoops;
        }
        prj.recursiveLoops[prj.recursiveLoops.length - 1] = loop;
    }

    public static void computeFieldUsage(Project prj) {
        Method m = prj.methodList;
        while (m != null) {
            if (m.callees != null && m.fieldsReferenced != null) {
                int i = 0;
                while (i < m.fieldsReferenced.length) {
                    Field f = m.fieldsReferenced[i];
                    if (!f.isValueUsed()) {
                        if (prj.markBase == 0) {
                            Method mc = prj.methodList;
                            while (mc != null) {
                                mc.mark = 0;
                                mc = mc.getNext();
                            }
                            prj.markBase = 1;
                        }
                        if (m.findFieldUsage(f, prj.markBase)) {
                            f.markAsUsed();
                        }
                        ++prj.markBase;
                    }
                    ++i;
                }
            }
            m = m.getNext();
        }
    }

    private final boolean findFieldUsage(Field f, int m) {
        if (this.callees != null) {
            int i = 0;
            while (i < this.callees.length) {
                Method mc = (Method)this.callees[i];
                if (mc.mark != m) {
                    mc.mark = m;
                    if (mc.fieldsReferenced != null) {
                        int j = 0;
                        while (j < mc.fieldsReferenced.length) {
                            if (mc.fieldsReferenced[j] == f) {
                                return true;
                            }
                            ++j;
                        }
                    }
                    if (mc.findFieldUsage(f, m)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public void pushFieldReference(Field decl) {
        this.fieldsReferenced = Method.pushField(this.fieldsReferenced, decl);
    }

    private static Field[] pushField(Field[] arr, Field decl) {
        if (arr == null) {
            arr = new Field[]{decl};
            return arr;
        }
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == decl) {
                return arr;
            }
            ++i;
        }
        Field[] newArr = new Field[arr.length + 1];
        int i2 = 0;
        while (i2 < arr.length) {
            newArr[i2] = arr[i2];
            ++i2;
        }
        newArr[arr.length] = decl;
        return newArr;
    }

    public IMethod[] getCallsAlwaysClosure() {
        return this.callsAlwaysClosure;
    }

    public void setDFG(DataFlowGraph dfg) {
        this.theDFG = dfg;
    }

    public IDataFlowGraph getDataFlowGraph() {
        return this.theDFG;
    }

    public DataFlowGraph getDFG() {
        return this.theDFG;
    }

    public void remove() {
        Project prj = this.getProject();
        super.remove();
        if (prj.methodList == this) {
            prj.methodList = this.next;
            --prj.numberOfMethods;
        } else {
            Method e = prj.methodList;
            while (e != null) {
                if (e.next == this) {
                    e.next = this.next;
                    --prj.numberOfMethods;
                    break;
                }
                e = e.next;
            }
        }
    }

    public IValueDomain getResultDomain() {
        if (this.resultDomain == null) {
            AstMethod meth = (AstMethod)this.getAstObject();
            AstTypeReference retType = meth.getReturnType();
            this.resultDomain = ValueDomain.getDefault(ValueTable.translateType(retType), retType);
        }
        return this.resultDomain;
    }

    public void setResultDomain(IValueDomain newResultDomainValue) {
        if (this.resultTrackable) {
            this.nResultDomain = this.nResultDomain == null ? newResultDomainValue : this.nResultDomain.join(newResultDomainValue);
        }
    }

    public IValueDomain getParameterDomain(int pNo) {
        return this.parameterDomain[pNo];
    }

    public int getNumberOfParameters() {
        return this.parameterDomain.length;
    }

    public void updateParameterDomain(int pNo, IValueDomain d) throws Throwable {
        if (!this.parameterDomainTrackable || d == null) {
            return;
        }
        if (this.parameterDomain[pNo] != null) {
            try {
                d = d.join(this.parameterDomain[pNo]);
            }
            catch (Throwable t) {
                System.err.println("--------------------------------------------");
                AstMethod meth = (AstMethod)this.getAstObject();
                System.err.println(" d = ");
                d.printBrief(System.err);
                System.err.println(" parameterDomain[pNo] = ");
                this.parameterDomain[pNo].printBrief(System.err);
                System.err.println(meth.getSignature());
                this.print(System.err);
                System.err.println("=== pNo = " + pNo);
                System.err.println(t);
                throw t;
            }
            this.parameterDomainChanged |= !d.equals(this.parameterDomain[pNo]);
        } else {
            this.parameterDomainChanged = true;
        }
        this.parameterDomain[pNo] = d;
    }

    public final void updateValues() {
        if (this.resultTrackable && this.nResultDomain != null) {
            boolean chg = this.resultDomain != null ? !this.nResultDomain.equals(this.resultDomain) : true;
            this.resultDomain = this.nResultDomain;
            this.resultDomainChanged = chg;
        }
    }

    public boolean anyChanged() {
        return this.parameterDomainChanged || this.resultDomainChanged;
    }

    public void dropChangedFlags() {
        this.parameterDomainChanged = false;
        this.resultDomainChanged = false;
    }

    public void computeNeedsUpdate() {
        if (this.parameterDomainChanged) {
            this.needsUpdateVal = true;
        } else {
            this.needsUpdateVal = false;
            if (this.callees != null) {
                int i = 0;
                while (i < this.callees.length) {
                    if (((Method)this.callees[i]).resultDomainChanged) {
                        this.needsUpdateVal = true;
                    }
                    ++i;
                }
            }
        }
    }

    public boolean needsUpdate() {
        return this.needsUpdateVal;
    }

    public void pushSubclass(Behavior sub) {
        if (this.subclasses == null) {
            this.subclasses = new Behavior[1];
            this.subclasses[0] = sub;
        } else {
            Behavior[] newSubclasses = new Behavior[this.subclasses.length + 1];
            int i = 0;
            while (i < this.subclasses.length) {
                newSubclasses[i] = this.subclasses[i];
                ++i;
            }
            newSubclasses[this.subclasses.length] = sub;
            this.subclasses = newSubclasses;
        }
    }
}

