/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.dataflow.IField;
import com.togethersoft.sca.internal.dataflow.Member;
import com.togethersoft.sca.internal.dataflow.NamedUnit;
import com.togethersoft.sca.internal.dataflow.NamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Project;
import java.io.PrintStream;

public class Field
extends Member
implements IField {
    private AstExpression initExpr;
    private boolean used;
    private Field next;

    public int unitKind() {
        return 4;
    }

    public Field(AstVariable varDecl, NamespaceUnit nameScope) {
        super(varDecl, varDecl.getElementName(), nameScope, NamedUnit.decodeAstAccess(varDecl.getModifiers()), NamedUnit.decodeAstModifiers(varDecl.getModifiers()));
        Project prj = this.getProject();
        this.initExpr = varDecl.getInitializer();
        this.used = false;
        this.next = prj.fieldList;
        prj.fieldList = this;
    }

    public void print(PrintStream out) {
        out.println("Field (" + this.name() + ")" + " used = " + this.used);
    }

    public static void printAll(Project prj, PrintStream out) {
        Field fld = prj.fieldList;
        while (fld != null) {
            fld.print(out);
            fld = fld.next;
        }
    }

    public boolean isValueUsed() {
        return this.used;
    }

    public AstExpression getInitializer() {
        return this.initExpr;
    }

    public final void markAsUsed() {
        this.used = true;
    }

    public final Field getNext() {
        return this.next;
    }

    public void remove() {
        Project prj = this.getProject();
        super.remove();
        if (prj.fieldList == this) {
            prj.fieldList = this.next;
        } else {
            Field e = prj.fieldList;
            while (e != null) {
                if (e.next == this) {
                    e.next = this.next;
                    break;
                }
                e = e.next;
            }
        }
    }
}

