/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstModelChangeListener;
import com.togethersoft.sca.ast.AstModelDelta;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.IExtensionExecutable;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.internal.dataflow.AttributesProvider;
import com.togethersoft.sca.internal.dataflow.Behavior;
import com.togethersoft.sca.internal.dataflow.ClassUnit;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.NamedUnit;
import com.togethersoft.sca.internal.dataflow.Package;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.DataFlowGraph;
import com.togethersoft.sca.internal.dataflow.fsa.FSA;
import com.togethersoft.sca.internal.dataflow.fsa.FSAAnalyzer;
import com.togethersoft.sca.internal.dataflow.known.KnownInfoLoader;
import com.togethersoft.sca.internal.dataflow.values.ObjectDomain;
import java.util.Enumeration;

public class DataFlowAnalyzer
implements IExtensionExecutable,
AstModelChangeListener {
    private static final int maxIter = 20;
    private AttributesProvider[] providers;
    private AstModel theModel;
    private Project theProject;
    private KnownInfoLoader knownInfo;
    private DataFlowAnalyzer nextAnalyzer;
    private static DataFlowAnalyzer theGlobalList;

    public void setParameters(IParameterRegistry registry) {
    }

    public DataFlowAnalyzer() {
    }

    public DataFlowAnalyzer(AstModel model) {
        this.setup(model, null);
    }

    public DataFlowAnalyzer(AstModel model, AttributesProvider[] providers) {
        this.setup(model, providers);
    }

    public void setup(AstModel model, AttributesProvider[] providers) {
        this.theModel = model;
        this.providers = new AttributesProvider[0];
        this.theProject = new Project(this);
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                this.registerProvider(providers[i]);
                ++i;
            }
        }
        this.theProject.loadModel(this.theModel);
        this.knownInfo = new KnownInfoLoader(this.theProject, this.theModel);
        this.nextAnalyzer = theGlobalList;
        theGlobalList = this;
    }

    public final void close() {
        this.cleanup();
        if (theGlobalList == this) {
            theGlobalList = this.nextAnalyzer;
        } else {
            DataFlowAnalyzer dfa = theGlobalList;
            while (dfa != null) {
                if (dfa.nextAnalyzer == this) {
                    dfa.nextAnalyzer = this.nextAnalyzer;
                }
                dfa = dfa.nextAnalyzer;
            }
        }
    }

    public static DataFlowAnalyzer correspondingTo(AstModel model) {
        DataFlowAnalyzer dfa = theGlobalList;
        while (dfa != null) {
            if (dfa.theModel == model) {
                return dfa;
            }
            dfa = dfa.nextAnalyzer;
        }
        return null;
    }

    public final void analyze(JobControl jctl) {
        if (jctl != null) {
            // empty if block
        }
        this.doLocalBuiltinAnalysis();
        if (jctl != null) {
            jctl.update(0.25);
        }
        Enumeration e = this.theProject.namedUnits();
        while (e.hasMoreElements()) {
            NamedUnit u = (NamedUnit)e.nextElement();
            if (!u.wasCreated() && !u.wasModified()) continue;
            int i = 0;
            while (i < this.providers.length) {
                AttributesProvider ap = this.providers[i];
                ap.updateLocalInfo(u, this.theProject);
                ++i;
            }
        }
        if (jctl != null) {
            jctl.update(0.25);
        }
        this.doGlobalBuiltinAnalysis();
        if (jctl != null) {
            jctl.update(0.25);
        }
        int i = 0;
        while (i < this.providers.length) {
            this.providers[i].updateGlobalInfo(this.theProject);
            ++i;
        }
        if (jctl != null) {
            jctl.update(0.25);
        }
    }

    public final void update(JobControl jctl, AstCompilationUnit[] deleted, AstCompilationUnit[] added, AstCompilationUnit[] changedInterfaceOld, AstCompilationUnit[] changedInterfaceNew, AstCompilationUnit[] changedBody) {
        this.theProject.update(deleted, added, changedInterfaceOld, changedInterfaceNew, changedBody);
        this.analyze(jctl);
    }

    public void modelChanged(AstModelDelta delta) {
        this.update(null, delta.removedFiles, delta.addedFiles, delta.expiredFiles[0], delta.expiredFiles[1], delta.updatedFiles);
    }

    private void doLocalBuiltinAnalysis() {
        Method m = this.theProject.methodList();
        while (m != null) {
            AstMethod mth;
            AstCompoundStatement body;
            AstObject ao;
            if ((m.wasCreated() || m.wasModified()) && (ao = m.getAstObject()) != null && (body = (mth = (AstMethod)ao).getBody()) != null) {
                try {
                    DataFlowGraph fg = new DataFlowGraph(this.theProject, mth);
                }
                catch (Throwable t) {
                    System.err.println("####################################");
                    System.err.println(t);
                    m.hasBody = false;
                    m.setDFG(null);
                }
            }
            m = m.getNext();
        }
        Method m2 = this.theProject.methodList();
        while (m2 != null) {
            DataFlowGraph fg;
            if ((m2.wasCreated() || m2.wasModified()) && (fg = m2.getDFG()) != null) {
                fg.collectDataForGlobalDataflow(m2);
            }
            m2 = m2.getNext();
        }
        Method.processGlobalExceptionInfo(this.theProject.methodList);
        this.doGlobalValuePropagation();
    }

    private final boolean anyChanges() {
        boolean res = false;
        Method m = this.theProject.methodList();
        while (m != null) {
            m.updateValues();
            if (m.anyChanged()) {
                res = true;
            }
            m = m.getNext();
        }
        return res;
    }

    private void doGlobalValuePropagation() {
        Method m;
        Method m2 = this.theProject.methodList();
        while (m2 != null) {
            DataFlowGraph fg;
            if ((m2.wasCreated() || m2.wasModified()) && (fg = m2.getDFG()) != null) {
                fg.doLocalDataflowAnalysis1();
            }
            m2 = m2.getNext();
        }
        int iterationCounter = 0;
        do {
            m = this.theProject.methodList();
            while (m != null) {
                m.computeNeedsUpdate();
                m = m.getNext();
            }
            Method m3 = this.theProject.methodList();
            while (m3 != null) {
                m3.dropChangedFlags();
                m3 = m3.getNext();
            }
            Method m4 = this.theProject.methodList();
            while (m4 != null) {
                DataFlowGraph fg = m4.getDFG();
                if (fg != null && (m4.needsUpdate() || iterationCounter == 0 && (m4.wasCreated() || m4.wasModified()))) {
                    fg.doLocalDataflowAnalysis2();
                }
                m4 = m4.getNext();
            }
        } while (this.anyChanges() && ++iterationCounter <= 20);
        if (iterationCounter > 20) {
            System.err.println("Global analysis did not converged after " + iterationCounter + " iterations");
        }
        m = this.theProject.methodList();
        while (m != null) {
            DataFlowGraph fg = m.getDFG();
            if (fg != null) {
                fg.doLocalDataflowAnalysis3();
            }
            m = m.getNext();
        }
    }

    private void doGlobalBuiltinAnalysis() {
        DataFlowGraph.doGlobalDataflowAnalysis(this.theProject);
    }

    public final void cleanup() {
        if (this.knownInfo != null) {
            this.knownInfo.cleanup();
        }
        if (this.theProject != null) {
            this.theProject.cleanup();
        }
        ObjectDomain.cleanup();
    }

    private final boolean[] recode(boolean[] map) {
        boolean[] newMap = new boolean[6];
        if (map[0]) {
            int i = 0;
            while (i < newMap.length) {
                newMap[i] = true;
                ++i;
            }
        } else {
            if (map[1]) {
                newMap[4] = true;
                newMap[5] = true;
            } else {
                if (map[3]) {
                    newMap[4] = true;
                }
                if (map[4]) {
                    newMap[5] = true;
                }
            }
            if (map[5]) {
                newMap[2] = true;
                newMap[3] = true;
            } else {
                if (map[7]) {
                    newMap[2] = true;
                }
                if (map[6]) {
                    newMap[3] = true;
                }
            }
            if (map[2]) {
                newMap[1] = true;
            }
        }
        return newMap;
    }

    public final boolean registerProvider(AttributesProvider p) {
        if (p == null) {
            return false;
        }
        int i = 0;
        while (i < this.providers.length) {
            if (this.providers[i] == p) {
                return false;
            }
            ++i;
        }
        AttributesProvider[] nProviders = new AttributesProvider[this.providers.length + 1];
        System.arraycopy(this.providers, 0, nProviders, 0, this.providers.length);
        nProviders[this.providers.length] = p;
        this.providers = nProviders;
        boolean[] slotRequestMap = this.recode(p.getRequestedSlots());
        int[] slotNumbers = new int[6];
        int i2 = 0;
        while (i2 < slotRequestMap.length) {
            slotNumbers[i2] = slotRequestMap[i2] ? this.theProject.reserveSlot(i2) : -1;
            ++i2;
        }
        p.setupSlotNumbers(slotNumbers);
        return true;
    }

    public final boolean unregisterProvider(AttributesProvider p) {
        if (p == null) {
            return false;
        }
        int i = 0;
        while (i < this.providers.length) {
            if (this.providers[i] == p) {
                AttributesProvider[] nProviders = new AttributesProvider[this.providers.length - 1];
                System.arraycopy(this.providers, 0, nProviders, 0, i);
                System.arraycopy(this.providers, i, nProviders, i + 1, this.providers.length - i - 1);
                this.providers = nProviders;
                return true;
            }
            ++i;
        }
        int[] slotNumbers = p.getSlotNumbers();
        int i2 = 0;
        while (i2 < slotNumbers.length) {
            if (slotNumbers[i2] >= 0) {
                this.theProject.releaseSlot(i2, slotNumbers[i2]);
            }
            ++i2;
        }
        return false;
    }

    public final AttributesProvider getProvider(String name) {
        int i = 0;
        while (i < this.providers.length) {
            if (this.providers[i].name().equals(name)) {
                return this.providers[i];
            }
            ++i;
        }
        return null;
    }

    public final Project getProject() {
        return this.theProject;
    }

    public final Package getFor(AstPackage pkg) {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.getFor(pkg);
    }

    public final Behavior getFor(AstType typ) {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.getFor(typ);
    }

    public final Field getFor(AstVariable fld) {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.getFor(fld);
    }

    public final Method getFor(AstMethod mth) {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.getFor(mth);
    }

    public final Method getFor(AstInitializer mth) {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.getFor(mth);
    }

    public final Field fieldList() {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.fieldList;
    }

    public final Method methodList() {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.methodList;
    }

    public final ClassUnit classList() {
        if (this.theProject == null) {
            return null;
        }
        return this.theProject.classList;
    }

    public final DataFlowGraph getDataFlowGraph(AstMethod mth) {
        Method meth = this.theProject.getFor(mth);
        if (meth != null) {
            return meth.getDFG();
        }
        return null;
    }

    public void runFSA(FSA automaton, boolean globally) {
        FSAAnalyzer a = new FSAAnalyzer(automaton);
        Method m = this.methodList();
        while (m != null) {
            a.processMethod(m);
            m = m.getNext();
        }
    }

    public AstModel getModel() {
        return this.theModel;
    }
}

