/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.dataflow.IClass;
import com.togethersoft.sca.dataflow.INamedUnit;
import com.togethersoft.sca.internal.dataflow.Behavior;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.NamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Project;
import java.io.PrintStream;

public class ClassUnit
extends Behavior
implements IClass {
    private IClass superclass;
    private ClassUnit next;

    public int unitKind() {
        return 2;
    }

    public IClass superclass() {
        return this.superclass;
    }

    public IClass[] superclasses() {
        int nSuperclasses = 0;
        IClass c = this.superclass();
        while (c != null) {
            ++nSuperclasses;
            c = c.superclass();
        }
        if (nSuperclasses != 0) {
            IClass[] res = new IClass[nSuperclasses];
            int idx = 0;
            IClass c2 = this.superclass();
            while (c2 != null) {
                res[idx++] = c2;
                c2 = c2.superclass();
            }
            return res;
        }
        return null;
    }

    public boolean isDataClass() {
        if (this.subUnits != null) {
            int i = 0;
            while (i < this.subUnits.length) {
                Method meth;
                INamedUnit u = this.subUnits[i];
                if (u instanceof Method && !(meth = (Method)u).isGetter() && !meth.isSetter() && !meth.isEmpty()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public ClassUnit(AstType type, NamespaceUnit nameScope, AstCompilationUnit compilationUnitVal) {
        super(type, nameScope, compilationUnitVal);
        Project prj = this.getProject();
        this.next = prj.classList;
        prj.classList = this;
    }

    public void print(PrintStream out) {
        out.println("Class # (" + this.name() + ")" + " data class = " + this.isDataClass());
    }

    public static void printAll(Project prj, PrintStream out) {
        ClassUnit cl = prj.classList;
        while (cl != null) {
            cl.print(out);
            cl = cl.getNextClass();
        }
    }

    public ClassUnit getNextClass() {
        return this.next;
    }

    public void remove() {
        Project prj = this.getProject();
        super.remove();
        if (prj.classList == this) {
            prj.classList = this.next;
        } else {
            ClassUnit e = prj.classList;
            while (e != null) {
                if (e.next == this) {
                    e.next = this.next;
                    break;
                }
                e = e.next;
            }
        }
    }
}

