/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.dataflow.IBehavior;
import com.togethersoft.sca.dataflow.IField;
import com.togethersoft.sca.dataflow.IInterface;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.dataflow.INamedUnit;
import com.togethersoft.sca.internal.dataflow.ClassUnit;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.InterfaceUnit;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.NamedUnit;
import com.togethersoft.sca.internal.dataflow.NamespaceUnit;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.known.KnownClass;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;

public abstract class Behavior
extends NamespaceUnit
implements IBehavior {
    public KnownClass knownInfo;

    public IInterface[] getSuperinterfaces() {
        return null;
    }

    public IField findField(String name) {
        return null;
    }

    public IMethod[] findMethod(String name) {
        return null;
    }

    public IMethod[] getMethods() {
        if (this.subUnits != null) {
            int nMethods = 0;
            int i = 0;
            while (i < this.subUnits.length) {
                if (this.subUnits[i] instanceof IMethod) {
                    ++nMethods;
                }
                ++i;
            }
            IMethod[] mth = new IMethod[nMethods];
            int idx = 0;
            int i2 = 0;
            while (i2 < this.subUnits.length) {
                if (this.subUnits[i2] instanceof IMethod) {
                    mth[idx++] = (IMethod)this.subUnits[i2];
                }
                ++i2;
            }
            return mth;
        }
        return new IMethod[0];
    }

    public IBehavior[] getSubclasses() {
        Project p = this.getProject();
        AstType t = (AstType)this.getAstObject();
        AstType[] subclasses = t.getSubtypes();
        if (subclasses != null) {
            IBehavior[] bh = new IBehavior[subclasses.length];
            int i = 0;
            while (i < subclasses.length) {
                bh[i] = p.getFor(subclasses[i]);
                ++i;
            }
            return bh;
        }
        return new IBehavior[0];
    }

    protected Behavior(AstType type, NamespaceUnit nameScope, AstCompilationUnit compilationUnitVal) {
        super(type, type.getElementName(), nameScope, NamedUnit.decodeAstAccess(type.getModifiers()), NamedUnit.decodeAstModifiers(type.getModifiers()), compilationUnitVal);
        AstType[] types;
        AstMethod[] constrs;
        AstMethod[] methods;
        AstInitializer[] inits;
        int nSubUnits = 0;
        AstField[] fields = type.getFields();
        if (fields != null) {
            nSubUnits = fields.length;
        }
        if ((inits = type.getInitializers()) != null) {
            nSubUnits += inits.length;
        }
        if ((methods = type.getMethods()) != null) {
            nSubUnits += methods.length;
        }
        if ((constrs = type.getConstructors()) != null) {
            nSubUnits += constrs.length;
        }
        if (type instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)type;
            MethodDeclaration md = td.getClassInitializer();
            if (md != null) {
                ++nSubUnits;
            }
            if ((md = td.getInstanceInitializer()) != null) {
                ++nSubUnits;
            }
        }
        if ((types = type.getTypes()) != null) {
            nSubUnits += types.length;
        }
        if (nSubUnits != 0) {
            int i;
            int unitIdx = 0;
            this.subUnits = new INamedUnit[nSubUnits];
            if (fields != null) {
                i = 0;
                while (i < fields.length) {
                    this.subUnits[unitIdx++] = new Field(fields[i], this);
                    ++i;
                }
            }
            if (inits != null) {
                i = 0;
                while (i < inits.length) {
                    this.subUnits[unitIdx++] = new Method(inits[i], (NamespaceUnit)this);
                    ++i;
                }
            }
            if (methods != null) {
                i = 0;
                while (i < methods.length) {
                    this.subUnits[unitIdx++] = new Method(methods[i], (NamespaceUnit)this);
                    ++i;
                }
            }
            if (constrs != null) {
                i = 0;
                while (i < constrs.length) {
                    this.subUnits[unitIdx++] = new Method(constrs[i], (NamespaceUnit)this);
                    ++i;
                }
            }
            if (type instanceof TypeDeclaration) {
                TypeDeclaration td = (TypeDeclaration)type;
                MethodDeclaration md = td.getClassInitializer();
                if (md != null) {
                    this.subUnits[unitIdx++] = new Method(md, (NamespaceUnit)this);
                }
                if ((md = td.getInstanceInitializer()) != null) {
                    this.subUnits[unitIdx++] = new Method(md, (NamespaceUnit)this);
                }
            }
            if (types != null) {
                int i2 = 0;
                while (i2 < types.length) {
                    AstCompilationUnit cUnit = this.getCompilationUnit();
                    this.subUnits[unitIdx++] = types[i2].isClass() ? new ClassUnit(types[i2], this, cUnit) : new InterfaceUnit(types[i2], this, cUnit);
                    ++i2;
                }
            }
        }
    }
}

