/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core.plugin.audit;

import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ESAutoFix
extends AutoFix {
    private static String lineSeparator = System.getProperty("line.separator");
    private String name;
    private ArrayList es = new ArrayList();
    private int tabSize;
    public static boolean enabled = true;

    public ESAutoFix(String name) {
        this.name = name;
    }

    public ESAutoFix(IAuditMessage m, String name) {
        m.addAutoFix(this);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append(':');
        buf.append(this.tabSize);
        buf.append(':');
        if (this.es != null) {
            int i = 0;
            int n = this.es.size();
            while (i < n) {
                ((EditingSequence)this.es.get(0)).print(buf);
                ++i;
            }
        }
        return buf.toString();
    }

    public static ESAutoFix fromString(String s) {
        int p = s.indexOf(58);
        ESAutoFix fix = new ESAutoFix(s.substring(0, p));
        int q = s.indexOf(58, ++p);
        try {
            fix.setTabSize(Integer.parseInt(s.substring(p, q), 10));
            ArrayList<EditingSequence> list = new ArrayList<EditingSequence>();
            int end = s.length();
            p = q + 1;
            while (p < end) {
                String text;
                int endColumn;
                int endLine;
                char cmd = s.charAt(p++);
                q = s.indexOf(44, p);
                int startLine = Integer.parseInt(s.substring(p, q), 10);
                p = q + 1;
                q = s.indexOf(44, p);
                int startColumn = Integer.parseInt(s.substring(p, q), 10);
                p = q + 1;
                q = s.indexOf(44, p);
                if (cmd == '>') {
                    endLine = Integer.parseInt(s.substring(p, q), 10);
                    p = q + 1;
                    q = s.indexOf(44, p);
                    endColumn = Integer.parseInt(s.substring(p, q), 10);
                    p = q + 1;
                    text = null;
                } else if (cmd == '<') {
                    endColumn = startColumn;
                    endLine = startLine;
                    text = s.substring(p, q);
                    p = q + 1;
                    while (p < end && s.charAt(p) == ',') {
                        q = s.indexOf(44, p);
                        text = text + s.substring(p, q);
                        p = q + 1;
                    }
                } else {
                    System.err.println("Auto fix format error");
                    return null;
                }
                EditingSequence edit = new EditingSequence(cmd == '>' ? 1 : 0, startLine, startColumn, endLine, endColumn, text);
                list.add(edit);
            }
            fix.es = list;
        }
        catch (NumberFormatException x) {
            System.err.println("Auto fix format error");
            return null;
        }
        return fix;
    }

    public boolean fix() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean fix(InputStream sin, OutputStream sout) {
        if (this.es == null || this.es.size() == 0) {
            return false;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(sin);
            BufferedOutputStream out = new BufferedOutputStream(sout);
            int line = 1;
            int column = 1;
            int editPos = 0;
            EditingSequence edit = (EditingSequence)this.es.get(0);
            int editLine = edit.startLine;
            int editColumn = edit.startColumn;
            while (true) {
                int ch;
                if (line == editLine && column == editColumn) {
                    int rc;
                    if (edit.op == 0) {
                        ((OutputStream)out).write(edit.text.getBytes());
                    } else {
                        do {
                            if ((ch = ((InputStream)in).read()) == 10) {
                                ++line;
                                column = 1;
                                continue;
                            }
                            ++column;
                        } while (line < edit.endLine || line == edit.endLine && column < edit.endColumn);
                    }
                    if (++editPos < this.es.size()) {
                        edit = (EditingSequence)this.es.get(editPos);
                        editLine = edit.startLine;
                        editColumn = edit.startColumn;
                        continue;
                    }
                    byte[] buf = new byte[4096];
                    while ((rc = ((InputStream)in).read(buf)) > 0) {
                        void var13_14;
                        ((OutputStream)out).write(buf, 0, (int)var13_14);
                    }
                    break;
                }
                ch = ((InputStream)in).read();
                if (ch == 10) {
                    ++line;
                    column = 1;
                } else {
                    column = ch == 9 ? (column += this.tabSize) : ++column;
                }
                ((OutputStream)out).write(ch);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException x) {
            x.printStackTrace(System.err);
            return false;
        }
    }

    public void insert(int line, int column, String text) {
        this.es.add(new EditingSequence(0, line, column, line, column, text));
    }

    public void insert(AstSourcePosition pos, String text) {
        this.insert(pos.getStartLine(), pos.getStartColumn(), text);
    }

    public void insertAfter(AstSourcePosition pos, String text) {
        this.insert(pos.getEndLine(), pos.getEndColumn(), text);
    }

    public void insertLine(int line, int column, String text) {
        this.insert(line, column, text + lineSeparator);
    }

    public void insertLine(AstSourcePosition pos, String text) {
        this.insert(pos, text + lineSeparator);
    }

    public void insert(String text) {
        EditingSequence prev = (EditingSequence)this.es.get(this.es.size() - 1);
        this.insert(prev.endLine, prev.endColumn, text);
    }

    public void insertLine(String text) {
        this.insert(text + lineSeparator);
    }

    public void indent(int startLine, int indentation) {
        char[] pad = new char[indentation - 1];
        int i = indentation - 1;
        while (--i >= 0) {
            pad[i] = 32;
        }
        this.insert(startLine, 1, new String(pad));
    }

    public void indent(int indentation) {
        EditingSequence prev = (EditingSequence)this.es.get(this.es.size() - 1);
        char[] pad = new char[indentation - 1];
        int i = indentation - 1;
        while (--i >= 0) {
            pad[i] = 32;
        }
        this.insert(prev.endLine, prev.endColumn, new String(pad));
    }

    public void remove(int startLine, int startColumn, int endLine, int endColumn) {
        this.es.add(new EditingSequence(1, startLine, startColumn, endLine, endColumn, null));
    }

    public void remove(AstSourcePosition pos) {
        this.remove(pos.getStartLine(), pos.getStartColumn(), pos.getEndLine(), pos.getEndColumn());
    }

    public void removeWithSpace(AstSourcePosition pos) {
        this.remove(pos.getStartLine(), pos.getStartColumn(), pos.getEndLine(), pos.getEndColumn() + 1);
    }

    public void removeBlock(AstSourcePosition pos) {
        this.remove(pos.getStartLine(), 1, pos.getEndLine(), Integer.MAX_VALUE);
    }

    public void setTabSize(int size) {
        this.tabSize = size;
    }

    public static class EditingSequence {
        static final int OP_INSERT = 0;
        static final int OP_REMOVE = 1;
        int op;
        int startLine;
        int startColumn;
        int endLine;
        int endColumn;
        String text;

        /*
         * WARNING - void declaration
         */
        void print(StringBuffer buf) {
            if (this.op == 0) {
                int q;
                buf.append('<');
                buf.append(this.startLine);
                buf.append(',');
                buf.append(this.startColumn);
                buf.append(',');
                int p = 0;
                while ((q = this.text.indexOf(44, p)) >= 0) {
                    void var3_3;
                    buf.append(this.text.substring(p, (int)var3_3));
                    buf.append(",,");
                }
                buf.append(this.text.substring(p));
                buf.append(',');
            } else {
                buf.append(">");
                buf.append(this.startLine);
                buf.append(',');
                buf.append(this.startColumn);
                buf.append(',');
                buf.append(this.endLine);
                buf.append(',');
                buf.append(this.endColumn);
                buf.append(",");
            }
        }

        EditingSequence(int op, int startLine, int startColumn, int endLine, int endColumn, String text) {
            this.op = op;
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.text = text;
        }
    }
}

