/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.ICodeInspectorExecutable;
import com.togethersoft.sca.core.IExtension;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.ISourceBase;
import com.togethersoft.sca.core.IStaticAnalyzer;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.internal.core.Log;
import com.togethersoft.sca.internal.core.PluginManager;
import com.togethersoft.sca.internal.core.Project;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class StaticAnalyzer
implements IStaticAnalyzer {
    private PluginManager pluginManager;
    private ILog log;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.togethersoft.sca.core.Messages");
    private static StaticAnalyzer instance;
    private static final int MEM_SCALE = 150;
    static /* synthetic */ Class class$java$lang$Runtime;

    private StaticAnalyzer() {
    }

    public static StaticAnalyzer getInstance() {
        if (instance == null) {
            instance = new StaticAnalyzer();
        }
        return instance;
    }

    public boolean init(String[] pluginPath, URL[] pluginPropPath, ClassLoader[] loaders) {
        this.pluginManager = new PluginManager(pluginPath, pluginPropPath, loaders);
        return this.pluginManager.init();
    }

    public void shutdown() {
        this.pluginManager.shutdown();
    }

    public ILog getLog() {
        if (this.log == null) {
            this.log = new Log();
        }
        return this.log;
    }

    public void log(int severity, String msg, Object[] values) {
        if (this.log != null) {
            this.log.log(new Message(severity, resourceBundle.getString(msg), values));
        }
    }

    public IExtension[] getExtensions() {
        return this.pluginManager != null ? this.pluginManager.getExtensions() : new IExtension[]{};
    }

    public IExtension getExtension(String name) {
        return this.pluginManager != null ? this.pluginManager.getExtension(name) : null;
    }

    public ICodeInspector[] getCodeInspectors() {
        return this.pluginManager != null ? this.pluginManager.getCodeInspectors() : new ICodeInspector[]{};
    }

    public ICodeInspector getCodeInspector(String id) {
        return this.pluginManager != null ? this.pluginManager.getCodeInspector(id) : null;
    }

    public void run(IProject project, List analyzers, JobControl jobControl) {
        HashMap<ICodeInspector, ArrayList<IAnalyzerDescriptor>> inspectors = new HashMap<ICodeInspector, ArrayList<IAnalyzerDescriptor>>();
        Iterator iter = analyzers.iterator();
        while (iter.hasNext()) {
            IAnalyzerDescriptor d = (IAnalyzerDescriptor)iter.next();
            ArrayList<IAnalyzerDescriptor> list = (ArrayList<IAnalyzerDescriptor>)inspectors.get(d.getInspector());
            if (list == null) {
                list = new ArrayList<IAnalyzerDescriptor>();
                inspectors.put(d.getInspector(), list);
            }
            list.add(d);
        }
        if (jobControl != null) {
            jobControl.setScale(1.0 / (double)(inspectors.keySet().size() + 1));
        }
        long available = this.availableMemory();
        long required = 0L;
        int scale = 1;
        Project projectPart = new Project(project);
        ISourceBase[] bases = project.getSourceBases();
        int i = 0;
        while (i < bases.length) {
            iter = bases[i].getSourceFiles().iterator();
            long chunk = 0L;
            while (iter.hasNext()) {
                String file = (String)iter.next();
                chunk += 150L * project.getFileSize(file);
            }
            if (required != 0L && required + chunk > available) {
                if (jobControl != null) {
                    scale *= 2;
                    jobControl.setScale(0.5);
                }
                this.processProjectPart(projectPart, inspectors, jobControl);
                projectPart = new Project(project);
                required = 0L;
                available = this.availableMemory();
            }
            projectPart.addSourceBase(bases[i]);
            required += chunk;
            if (jobControl != null && jobControl.isCanceled()) break;
            ++i;
        }
        this.processProjectPart(projectPart, inspectors, jobControl);
        available = this.availableMemory();
        if (jobControl != null) {
            jobControl.setScale(scale);
        }
    }

    private long availableMemory() {
        long available = Long.MAX_VALUE;
        try {
            Method maxMemoryMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = StaticAnalyzer.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("maxMemory", null);
            if (maxMemoryMethod != null) {
                Runtime runtime = Runtime.getRuntime();
                long maxMemory = (Long)maxMemoryMethod.invoke((Object)runtime, null);
                available = (long)(0.7 * (double)(maxMemory - runtime.totalMemory()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return available;
    }

    private void processProjectPart(IProject projectPart, HashMap inspectors, JobControl jobControl) {
        projectPart.update(false, jobControl);
        if (jobControl != null && jobControl.isCanceled()) {
            return;
        }
        Iterator iter = inspectors.keySet().iterator();
        while (iter.hasNext()) {
            ICodeInspector insp = (ICodeInspector)iter.next();
            ICodeInspectorExecutable executable = insp.createExecutableCodeInspector();
            if (executable == null) continue;
            List list = (List)inspectors.get(insp);
            try {
                executable.run(projectPart, list.toArray(new IAnalyzerDescriptor[list.size()]), jobControl);
            }
            catch (Throwable e) {
                projectPart.getLog().log(new Message(3, e.getMessage(), null));
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

