/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.ISourceBase;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.internal.core.Log;
import com.togethersoft.sca.internal.jparser.Control;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;

public class Project
implements IProject {
    private static final int DEFAULT_TAB_SIZE = 4;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.togethersoft.sca.core.Messages");
    protected Control compiler;
    protected String projectName;
    protected int tabSize = 4;
    protected String classpath;
    protected boolean assertEnabled;
    private Collection bases = new ArrayList();
    private ILog log;

    public Project(String projectName, int tabSize) {
        this.projectName = projectName;
        this.tabSize = tabSize;
    }

    public Project(String projectName, int tabSize, String classpath) {
        this(projectName, tabSize);
        this.classpath = classpath;
    }

    public Project() {
    }

    public Project(IProject project) {
        this(project.getProjectName(), project.getTabSize(), project.getClasspath());
        this.assertEnabled = project.isAssertEnabled();
        this.log = project.getLog();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public ILog getLog() {
        if (this.log == null) {
            this.log = new Log();
        }
        return this.log;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        if (tabSize < 1) {
            this.getLog().log(new Message(2, resourceBundle.getString("Project.1"), new Object[]{new Integer(tabSize)}));
            tabSize = 4;
        }
        this.tabSize = tabSize;
    }

    public void enableAssert(boolean enabled) {
        this.assertEnabled = enabled;
    }

    public boolean isAssertEnabled() {
        return this.assertEnabled;
    }

    public String[] getSourceFiles() {
        ArrayList files = new ArrayList();
        ISourceBase[] bases = this.getSourceBases();
        int i = 0;
        while (i < bases.length) {
            files.addAll(bases[i].getSourceFiles());
            ++i;
        }
        return files.toArray(new String[files.size()]);
    }

    public ISourceBase[] getSourceBases() {
        return this.bases.toArray(new ISourceBase[this.bases.size()]);
    }

    protected void setSourceBases(Collection bases) {
        this.bases = bases;
    }

    public void addSourceBase(ISourceBase sourceBase) {
        this.bases.add(sourceBase);
    }

    public Reader openFile(String filename) {
        Iterator iter = this.bases.iterator();
        while (iter.hasNext()) {
            Reader in = ((ISourceBase)iter.next()).openFile(filename);
            if (in == null) continue;
            return in;
        }
        return null;
    }

    public long getTimestamp(String filename) {
        Iterator iter = this.bases.iterator();
        while (iter.hasNext()) {
            long timestamp = ((ISourceBase)iter.next()).getTimestamp(filename);
            if (timestamp == -1L) continue;
            return timestamp;
        }
        return -1L;
    }

    public long getFileSize(String filename) {
        Iterator iter = this.bases.iterator();
        while (iter.hasNext()) {
            long filesize = ((ISourceBase)iter.next()).getFileSize(filename);
            if (filesize == -1L) continue;
            return filesize;
        }
        return -1L;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void update(boolean shallowModel, JobControl jobControl) {
        this.getCompiler().update(shallowModel, jobControl);
    }

    public void deepUpdate(AstCompilationUnit file) {
        this.getCompiler().deepUpdate(file);
    }

    public AstModel getModel() {
        return this.getCompiler().getModel();
    }

    public void write() {
        this.getCompiler().write();
    }

    public Control getCompiler() {
        if (this.compiler == null) {
            this.compiler = new Control(this);
        }
        return this.compiler;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer("Project [\n");
        ISourceBase[] bases = this.getSourceBases();
        int i = 0;
        while (i < bases.length) {
            sbuf.append("\t").append(bases[i].toString()).append('\n');
            ++i;
        }
        sbuf.append(" ]");
        return sbuf.toString();
    }
}

