/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.IExtension;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.internal.core.AnalyzerCategory;
import com.togethersoft.sca.internal.core.AnalyzerDescriptor;
import com.togethersoft.sca.internal.core.AnalyzerRegistry;
import com.togethersoft.sca.internal.core.CodeInspector;
import com.togethersoft.sca.internal.core.Extension;
import com.togethersoft.sca.internal.core.Parameter;
import com.togethersoft.sca.internal.core.ParameterBoolean;
import com.togethersoft.sca.internal.core.ParameterInteger;
import com.togethersoft.sca.internal.core.ParameterList;
import com.togethersoft.sca.internal.core.ParameterReal;
import com.togethersoft.sca.internal.core.ParameterRegistry;
import com.togethersoft.sca.internal.core.ParameterString;
import com.togethersoft.sca.internal.core.ParameterStringEnum;
import com.togethersoft.sca.internal.core.Parser;
import com.togethersoft.sca.internal.core.Plugin;
import com.togethersoft.sca.internal.core.StaticAnalyzer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

class PluginManager {
    private ArrayList plugins = new ArrayList();
    private ArrayList extensions = new ArrayList();
    private ArrayList inspectors = new ArrayList();
    private static final String PLUGIN_MANIFEST = "sapient.xml";
    private static final String PLUGIN_PROPERTIES = "sapient";
    private static final String EXTENSION_PATH = "/plugin/extension";
    private static final String EXTENSION_TAG = "extension";
    private static final String INSPECTOR_PATH = "/plugin/inspector";
    private static final String INSPECTOR_TAG = "inspector";
    private static final String PARAMETER = "parameter";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_MIN_VALUE = "minvalue";
    private static final String ATTR_MAX_VALUE = "maxvalue";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private String[] pluginPath;
    private URL[] pluginPropPath;
    private ClassLoader[] loaders;

    PluginManager(String[] pluginPath, URL[] pluginPropPath, ClassLoader[] loaders) {
        this.pluginPath = pluginPath;
        this.pluginPropPath = pluginPropPath;
        this.loaders = loaders;
    }

    boolean init() {
        if (this.pluginPath == null) {
            String bootPath = this.getBootPath();
            if (bootPath == null) {
                return false;
            }
            this.pluginPath = new String[]{bootPath + "/plugins"};
        }
        this.loadPlugins();
        return true;
    }

    IExtension[] getExtensions() {
        IExtension[] arrExtensions = new IExtension[this.extensions.size()];
        this.extensions.toArray(arrExtensions);
        return arrExtensions;
    }

    ICodeInspector[] getCodeInspectors() {
        ICodeInspector[] arrInspectors = new ICodeInspector[this.inspectors.size()];
        this.inspectors.toArray(arrInspectors);
        return arrInspectors;
    }

    Extension getExtension(String name) {
        int i = 0;
        while (i < this.extensions.size()) {
            Extension ext = (Extension)this.extensions.get(i);
            if (ext.getId().equals(name)) {
                return ext;
            }
            ++i;
        }
        return null;
    }

    CodeInspector getCodeInspector(String name) {
        int i = 0;
        while (i < this.inspectors.size()) {
            CodeInspector insp = (CodeInspector)this.inspectors.get(i);
            if (insp.getId().equals(name)) {
                return insp;
            }
            ++i;
        }
        return null;
    }

    void shutdown() {
        int i = 0;
        while (i < this.numPlugins()) {
            this.getPlugin(i).shutdown();
            ++i;
        }
    }

    private int numPlugins() {
        return this.plugins.size();
    }

    private Plugin getPlugin(int i) {
        return (Plugin)this.plugins.get(i);
    }

    private String getBootPath() {
        String path = System.getProperty("SAPIENT_HOME");
        if (path != null && !path.equals("")) {
            return path;
        }
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            StaticAnalyzer.getInstance().log(3, "PluginManager.1", null);
            return null;
        }
        path = url.getFile();
        if (path.endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/"));
        } else if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
            path = path + "/com/togethersoft/sca/internal/core";
        }
        return path;
    }

    private void loadPlugins() {
        Parser parser = new Parser();
        int i = 0;
        while (i < this.pluginPath.length) {
            URL propFile;
            File file = new File(this.pluginPath[i]);
            URL uRL = propFile = this.pluginPropPath != null && i < this.pluginPropPath.length ? this.pluginPropPath[i] : null;
            if (file.isDirectory()) {
                String[] files = file.list();
                if (files != null) {
                    int j = 0;
                    while (j < files.length) {
                        File manifest;
                        File f = new File(file, files[j]);
                        if (f.isDirectory() && (manifest = new File(f, PLUGIN_MANIFEST)).exists()) {
                            this.processManifestFile(parser, this.getClassLoader(i), manifest, propFile);
                        }
                        ++j;
                    }
                }
            } else {
                this.processManifestFile(parser, this.getClassLoader(i), file, propFile);
            }
            ++i;
        }
    }

    private ClassLoader getClassLoader(int i) {
        return this.loaders != null ? this.loaders[i] : null;
    }

    private void processManifestFile(Parser parser, ClassLoader loader, File manifest, URL manifestProperties) {
        Plugin plugin = null;
        try {
            StaticAnalyzer.getInstance().log(1, "PluginManager.2", new Object[]{manifest.getPath()});
            if (!parser.parse(new InputSource(new FileReader(manifest)))) {
                StaticAnalyzer.getInstance().log(2, "PluginManager.3", new Object[]{manifest.getPath()});
            } else {
                plugin = this.parsePlugin(manifest.getParentFile().toURL(), manifestProperties, parser, loader);
            }
        }
        catch (IOException e) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.3", new Object[]{manifest.getPath()});
        }
        if (plugin != null) {
            this.parseAnalyzers(plugin, manifest);
        }
    }

    private ResourceBundle getResourceBundle(URL location, Locale locale) {
        ResourceBundle resourceBundle = null;
        String localeFileName = PLUGIN_PROPERTIES;
        String localeSuffix = locale.toString();
        if (localeSuffix.length() > 0) {
            localeFileName = localeFileName + "_" + localeSuffix;
        } else if (locale.getVariant().length() > 0) {
            localeFileName = localeFileName + "___" + locale.getVariant();
        }
        resourceBundle = this.getResourceBundle(location, localeFileName);
        if (resourceBundle == null) {
            resourceBundle = this.getResourceBundle(location, PLUGIN_PROPERTIES);
        }
        return resourceBundle;
    }

    private ResourceBundle getResourceBundle(URL location, String fileName) {
        ResourceBundle resourceBundle = null;
        try {
            URL url = new URL(location, fileName + ".properties");
            resourceBundle = this.getResourceBundle(url);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return resourceBundle;
    }

    private ResourceBundle getResourceBundle(URL propLocation) {
        PropertyResourceBundle resourceBundle = null;
        try {
            resourceBundle = new PropertyResourceBundle(propLocation.openStream());
        }
        catch (MissingResourceException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return resourceBundle;
    }

    private Plugin parsePlugin(URL location, URL propLocation, Parser parser, ClassLoader loader) {
        File file;
        Element elDeployment;
        ArrayList<String> requires = null;
        Element elDescription = parser.getElement("/plugin/description");
        if (elDescription == null) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.4", new Object[]{location});
            return null;
        }
        String id = elDescription.getAttribute(ATTR_ID);
        if (id.equals("")) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.5", new Object[]{location});
            return null;
        }
        String name = elDescription.getAttribute(ATTR_NAME);
        if (name.equals("")) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.6", new Object[]{location});
            return null;
        }
        String version = elDescription.getAttribute(ATTR_VERSION);
        if (version.equals("")) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.7", new Object[]{location});
            return null;
        }
        Element elRequires = parser.getElement("/plugin/requires");
        if (elRequires != null) {
            requires = new ArrayList<String>();
            Element node = Parser.getFirstElement(elRequires, EXTENSION_TAG);
            while (node != null) {
                String extension = node.getAttribute(ATTR_ID);
                if (extension.equals("")) {
                    StaticAnalyzer.getInstance().log(2, "PluginManager.8", new Object[]{location});
                } else {
                    requires.add(extension);
                }
                node = Parser.getNextElement(node, EXTENSION_TAG);
            }
        }
        if ((elDeployment = parser.getElement("/plugin/deployment")) == null) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.9", new Object[]{location});
            return null;
        }
        String library = elDeployment.getAttribute("library");
        if (library.equals("")) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.10", new Object[]{location});
            return null;
        }
        String runclass = elDeployment.getAttribute("runclass");
        if (runclass.equals("")) {
            runclass = null;
        }
        URL localizedLocation = null;
        if (propLocation != null && (file = new File(propLocation.getFile()).getParentFile()) != null) {
            try {
                localizedLocation = file.toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        Plugin p = new Plugin(this, location, localizedLocation, id, name, version, library, runclass, requires, loader, propLocation != null ? this.getResourceBundle(propLocation) : this.getResourceBundle(location, Locale.getDefault()));
        this.plugins.add(p);
        this.readExtensions(parser, p, false);
        this.readExtensions(parser, p, true);
        return p;
    }

    private void parseAnalyzers(Plugin plugin, File manifest) {
        Parser parser = new Parser();
        File dir = manifest.getParentFile();
        String[] files = dir.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].length() >= 5 && files[i].substring(files[i].length() - 4).equals(".xml") && !files[i].equals(PLUGIN_MANIFEST)) {
                    try {
                        File file = new File(dir, files[i]);
                        if (parser.parse(new InputSource(new FileReader(file)))) {
                            this.readAnalyzers(plugin, parser);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    private void readAnalyzers(Plugin plugin, Parser parser) {
        Element elem = parser.getElement(INSPECTOR_PATH);
        while (elem != null) {
            String id = elem.getAttribute(ATTR_ID);
            if (id.equals("")) {
                StaticAnalyzer.getInstance().log(2, "PluginManager.11", new Object[]{plugin.getId()});
            } else {
                CodeInspector insp = this.getCodeInspector(id);
                if (insp == null) {
                    StaticAnalyzer.getInstance().log(2, "PluginManager.12", new Object[]{id, plugin.getId()});
                } else {
                    this.readRegistry(plugin, (AnalyzerRegistry)insp.getRegistry(), insp, elem, null, true);
                }
            }
            elem = Parser.getNextElement(elem, INSPECTOR_TAG);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readExtensions(Parser parser, Plugin plugin, boolean readInspectors) {
        if (readInspectors) {
            path = "/plugin/inspector";
            tag = "inspector";
        } else {
            path = "/plugin/extension";
            tag = "extension";
        }
        elem = parser.getElement(path);
        while (elem != null) {
            block12: {
                block13: {
                    block11: {
                        id = elem.getAttribute("id");
                        if (!id.equals("")) break block11;
                        StaticAnalyzer.getInstance().log(2, "PluginManager.13", new Object[]{plugin.getId()});
                        break block12;
                    }
                    if (!readInspectors) break block13;
                    insp = this.getCodeInspector(id);
                    if (insp == null) ** GOTO lbl-1000
                    StaticAnalyzer.getInstance().log(2, "PluginManager.14", new Object[]{id, plugin.getId(), insp.getPlugin().getId()});
                    break block12;
                }
                ext = this.getExtension(id);
                if (ext != null) {
                    StaticAnalyzer.getInstance().log(2, "PluginManager.15", new Object[]{id, plugin.getId(), ext.getPlugin().getId()});
                } else if ((name = elem.getAttribute("name")).equals("")) {
                    StaticAnalyzer.getInstance().log(2, "PluginManager.16", new Object[]{plugin.getId(), id});
                } else {
                    name = plugin.getLocalizedString(name);
                    runclass = elem.getAttribute("runclass");
                    if (runclass.equals("")) {
                        StaticAnalyzer.getInstance().log(2, "PluginManager.17", new Object[]{plugin.getId(), id});
                    } else {
                        parameters = this.readParameters(plugin, name, elem);
                        if (readInspectors) {
                            registry = new AnalyzerRegistry();
                            insp = new CodeInspector(id, name, parameters, runclass, plugin, registry);
                            this.readRegistry(plugin, registry, insp, elem, null, false);
                            this.inspectors.add(insp);
                            this.extensions.add(insp);
                            plugin.addExtension(insp);
                        } else {
                            ext = new Extension(id, name, parameters, runclass, plugin);
                            this.extensions.add(ext);
                            plugin.addExtension(ext);
                        }
                    }
                }
            }
            elem = Parser.getNextElement(elem, tag);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readRegistry(Plugin plugin, AnalyzerRegistry registry, ICodeInspector inspector, Element root, AnalyzerCategory cat, boolean isAddon) {
        node = Parser.getFirstElement(root, "analyzer");
        while (node != null) {
            id = node.getAttribute("id");
            if (id.equals("")) {
                this.error(node, "PluginManager.24", null);
            } else if (registry.getDescriptor(id) != null) {
                this.error(node, "PluginManager.25", id);
            } else {
                if (registry.getCategory(id) != null) {
                    this.error(node, "PluginManager.26", id);
                }
                if ((name = node.getAttribute("name")).equals("")) {
                    this.error(node, "PluginManager.27", null);
                } else {
                    name = plugin.getLocalizedString(name);
                    runclass = node.getAttribute("implementation");
                    if (runclass.equals("")) {
                        this.error(node, "PluginManager.28", null);
                    } else {
                        library = node.getAttribute("library");
                        params = this.readParameters(plugin, inspector.getName(), node);
                        ad = new AnalyzerDescriptor(id, name, runclass, library, params, cat, inspector);
                        registry.addDescriptor(ad);
                        if (cat != null) {
                            cat.addDescriptor(ad);
                        }
                    }
                }
            }
            node = Parser.getNextElement(node, "analyzer");
        }
        node = Parser.getFirstElement(root, "category");
        while (node != null) {
            block19: {
                block20: {
                    block18: {
                        id = node.getAttribute("id");
                        if (!id.equals("")) break block18;
                        this.error(node, "PluginManager.24", null);
                        break block19;
                    }
                    if (!isAddon) break block20;
                    ac = (AnalyzerCategory)registry.getCategory(id);
                    if (ac != null) ** GOTO lbl54
                    this.error(node, "PluginManager.29", id);
                    break block19;
                }
                if (registry.getCategory(id) != null) {
                    this.error(node, "PluginManager.30", id);
                } else {
                    if (registry.getDescriptor(id) != null) {
                        this.error(node, "PluginManager.31", id);
                    }
                    if ((name = node.getAttribute("name")).equals("")) {
                        this.error(node, "PluginManager.27", null);
                    } else {
                        name = plugin.getLocalizedString(name);
                        ac = new AnalyzerCategory(id, name, cat);
                        registry.addCategory(ac);
                        if (cat != null) {
                            cat.addCategory(ac);
                        }
lbl54:
                        // 4 sources

                        this.readRegistry(plugin, registry, inspector, node, ac, isAddon);
                    }
                }
            }
            node = Parser.getNextElement(node, "category");
        }
    }

    private ParameterRegistry readParameters(Plugin plugin, String extension, Element root) {
        ParameterRegistry registry = new ParameterRegistry();
        Element node = Parser.getFirstElement(root, PARAMETER);
        while (node != null) {
            Parameter p = this.parseParameter(plugin, node);
            if (p != null) {
                p.setRemovable(false);
                if (registry.getParameter(p.getId()) != null) {
                    StaticAnalyzer.getInstance().log(2, "PluginManager.18", new Object[]{p.getId(), extension});
                } else {
                    registry.addParameter(p);
                }
            }
            node = Parser.getNextElement(node, PARAMETER);
        }
        return registry;
    }

    private Parameter parseParameter(Plugin plugin, Element el) {
        String type;
        String name = el.getAttribute(ATTR_NAME).intern();
        if (name.equals("")) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.19", null);
            return null;
        }
        String desc = el.getAttribute("description").intern();
        if (!desc.equals("")) {
            desc = plugin.getLocalizedString(desc);
        }
        if ((type = el.getAttribute(ATTR_TYPE).intern()).equals("")) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.20", new Object[]{name});
            return null;
        }
        String value = el.getAttribute(ATTR_VALUE).intern();
        if (value.equals("") && !type.equals("string") && !type.equals("list")) {
            StaticAnalyzer.getInstance().log(2, "PluginManager.21", new Object[]{name});
            return null;
        }
        value = plugin.getLocalizedString(value);
        try {
            if (type.equals("integer")) {
                return new ParameterInteger(name, desc, value, el.getAttribute(ATTR_MIN_VALUE), el.getAttribute(ATTR_MAX_VALUE));
            }
            if (type.equals("boolean")) {
                return new ParameterBoolean(name, desc, value);
            }
            if (type.equals("string")) {
                return new ParameterString(name, desc, value);
            }
            if (type.equals("real")) {
                return new ParameterReal(name, desc, value, el.getAttribute(ATTR_MIN_VALUE), el.getAttribute(ATTR_MAX_VALUE));
            }
            if (type.equals("enum")) {
                int cur;
                ArrayList<String> itemList = new ArrayList<String>();
                Element item = Parser.getFirstElement(el, PARAMETER);
                while (item != null) {
                    if (!item.getAttribute(ATTR_TYPE).equals("string")) {
                        StaticAnalyzer.getInstance().log(2, "PluginManager.23", new Object[]{name});
                    } else {
                        String itemValue = item.getAttribute(ATTR_VALUE).intern();
                        if ("".equals(itemValue)) {
                            StaticAnalyzer.getInstance().log(2, "PluginManager.21", new Object[]{name});
                        } else {
                            itemList.add(plugin.getLocalizedString(item.getAttribute(ATTR_VALUE).intern()));
                        }
                    }
                    item = Parser.getNextElement(item, PARAMETER);
                }
                ParameterStringEnum parameterStringEnum = new ParameterStringEnum(name, desc, itemList.toArray(new String[itemList.size()]));
                if (!parameterStringEnum.setValue(cur = Integer.parseInt(value))) {
                    StaticAnalyzer.getInstance().log(2, "PluginManager.22", new Object[]{name});
                    return null;
                }
                return parameterStringEnum;
            }
            if (type.equals("list")) {
                ArrayList<Parameter> itemList = new ArrayList<Parameter>();
                Element item = Parser.getFirstElement(el, PARAMETER);
                while (item != null) {
                    Parameter p = this.parseParameter(plugin, item);
                    if (p != null) {
                        itemList.add(p);
                    }
                    item = Parser.getNextElement(item, PARAMETER);
                }
                return new ParameterList(name, desc, itemList.toArray(new IParameter[itemList.size()]));
            }
            StaticAnalyzer.getInstance().log(2, "PluginManager.23", new Object[]{name});
            return null;
        }
        catch (IllegalArgumentException e) {
            StaticAnalyzer.getInstance().log(2, "%s", new Object[]{e.getMessage()});
            return null;
        }
    }

    private void error(Element el, String message, Object value) {
        Object[] objectArray;
        if (value != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = el.getNodeName();
            objectArray = objectArray2;
            objectArray2[1] = value;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = el.getNodeName();
        }
        Object[] values = objectArray;
        StaticAnalyzer.getInstance().log(2, message, values);
    }
}

