/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import java.net.URL;
import java.net.URLClassLoader;

public class PluginLoader
extends URLClassLoader {
    private PluginLoader[] imports;

    public PluginLoader(URL url, ClassLoader parent, PluginLoader[] imports) {
        super(new URL[]{url}, parent);
        this.imports = imports;
    }

    public void setImports(PluginLoader[] imports) {
        this.imports = imports;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.loadClassSelf(name, resolve);
        if (clazz != null) {
            return clazz;
        }
        int i = 0;
        while (i < this.imports.length) {
            clazz = this.imports[i].loadClassSelf(name, resolve);
            if (clazz != null) {
                return clazz;
            }
            ++i;
        }
        throw new ClassNotFoundException(name);
    }

    private Class loadClassSelf(String name, boolean resolve) {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

