/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.ICodeInspectorExecutable;
import com.togethersoft.sca.core.IExtensionExecutable;
import com.togethersoft.sca.core.IPluginExecutable;
import com.togethersoft.sca.internal.core.Extension;
import com.togethersoft.sca.internal.core.PluginLoader;
import com.togethersoft.sca.internal.core.PluginManager;
import com.togethersoft.sca.internal.core.StaticAnalyzer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Plugin {
    private PluginManager pluginManager;
    private URL location;
    private URL localizedLocation;
    private ClassLoader loader;
    private IPluginExecutable executable;
    private ResourceBundle resourceBundle;
    private boolean initialized;
    private String id;
    private String name;
    private String version;
    private String library;
    private String runclass;
    private ArrayList extensions = new ArrayList();
    private ArrayList requires;
    static /* synthetic */ Class class$com$togethersoft$sca$core$IExtensionExecutable;
    static /* synthetic */ Class class$com$togethersoft$sca$core$ICodeInspectorExecutable;
    static /* synthetic */ Class class$com$togethersoft$sca$core$IPluginExecutable;

    public Plugin(PluginManager pluginManager, URL location, URL localizedLocation, String id, String name, String version, String library, String runclass, ArrayList requires, ClassLoader loader, ResourceBundle resourceBundle) {
        this.pluginManager = pluginManager;
        this.location = location;
        this.localizedLocation = localizedLocation;
        this.id = id;
        this.version = version;
        this.library = library;
        this.runclass = runclass;
        this.requires = requires;
        this.loader = loader;
        this.resourceBundle = resourceBundle;
        this.name = this.getLocalizedString(name);
    }

    String getId() {
        return this.id;
    }

    private String getName() {
        return this.name;
    }

    URL getLocation() {
        return this.location;
    }

    URL getLocalizedLocation() {
        return this.localizedLocation;
    }

    URL find(String path, String extention) {
        URL url = null;
        Locale locale = Locale.getDefault();
        if (this.localizedLocation != null) {
            url = this.find(this.localizedLocation, path, locale, extention);
        }
        if (url == null) {
            url = this.find(this.location, path, locale, extention);
        }
        if (url == null) {
            try {
                url = new URL(this.location, path + extention);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return url;
    }

    URL find(URL urlBase, String path, String extention) {
        URL url = null;
        try {
            url = new URL(urlBase, path + extention);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (!new File(url.getFile()).exists()) {
            return null;
        }
        return url;
    }

    URL find(URL urlBase, String path, Locale locale, String extention) {
        URL url = null;
        url = this.find(urlBase, path + "_" + locale.getLanguage(), extention);
        if (url == null) {
            url = this.find(urlBase, path + "_" + locale.toString(), extention);
        }
        if (url == null) {
            url = this.find(urlBase, path, extention);
        }
        return url;
    }

    void addExtension(Extension ext) {
        this.extensions.add(ext);
    }

    IExtensionExecutable createExtensionExecutable(String runclass) {
        if (!this.initialized) {
            this.initialize();
        }
        return (IExtensionExecutable)this.createExecutable(runclass, class$com$togethersoft$sca$core$IExtensionExecutable == null ? (class$com$togethersoft$sca$core$IExtensionExecutable = Plugin.class$("com.togethersoft.sca.core.IExtensionExecutable")) : class$com$togethersoft$sca$core$IExtensionExecutable);
    }

    ICodeInspectorExecutable createCodeInspectorExecutable(String runclass) {
        if (!this.initialized) {
            this.initialize();
        }
        return (ICodeInspectorExecutable)this.createExecutable(runclass, class$com$togethersoft$sca$core$ICodeInspectorExecutable == null ? (class$com$togethersoft$sca$core$ICodeInspectorExecutable = Plugin.class$("com.togethersoft.sca.core.ICodeInspectorExecutable")) : class$com$togethersoft$sca$core$ICodeInspectorExecutable);
    }

    void shutdown() {
        if (this.executable != null) {
            this.executable.shutdown();
        }
    }

    public String getLocalizedString(String stringId) {
        if (this.resourceBundle != null && stringId.startsWith("%")) {
            stringId = stringId.substring(1);
            try {
                return this.resourceBundle.getString(stringId);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return stringId;
    }

    private URL getURL() {
        try {
            return new URL(this.location + "/" + this.library);
        }
        catch (MalformedURLException e) {
            StaticAnalyzer.getInstance().log(2, "Plugin.1", new Object[]{this.name, this.library});
            return null;
        }
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.loader == null) {
            this.createLoader();
        }
        if (this.runclass != null) {
            this.executable = (IPluginExecutable)this.createExecutable(this.runclass, class$com$togethersoft$sca$core$IPluginExecutable == null ? (class$com$togethersoft$sca$core$IPluginExecutable = Plugin.class$("com.togethersoft.sca.core.IPluginExecutable")) : class$com$togethersoft$sca$core$IPluginExecutable);
            if (this.executable != null) {
                this.executable.startup();
            } else {
                StaticAnalyzer.getInstance().log(2, "Plugin.2", new Object[]{this.getName()});
            }
        }
    }

    private ClassLoader getLoader() {
        if (this.loader == null) {
            this.loader = new PluginLoader(this.getURL(), this.getClass().getClassLoader(), new PluginLoader[0]);
        }
        return this.loader;
    }

    private void createLoader() {
        HashSet imports = new HashSet();
        this.addImports(imports);
        PluginLoader[] loaders = new PluginLoader[imports.size()];
        int i = 0;
        Iterator iter = imports.iterator();
        while (iter.hasNext()) {
            Plugin plugin = (Plugin)iter.next();
            loaders[i++] = (PluginLoader)plugin.getLoader();
        }
        ((PluginLoader)this.loader).setImports(loaders);
        this.initialized = true;
        Iterator iter2 = imports.iterator();
        while (iter2.hasNext()) {
            Plugin plugin = (Plugin)iter2.next();
            plugin.initialize();
        }
    }

    private void addImports(HashSet imports) {
        if (!imports.contains(this)) {
            imports.add(this);
            if (this.requires != null) {
                int i = 0;
                while (i < this.requires.size()) {
                    String extension = (String)this.requires.get(i);
                    Extension ext = this.pluginManager.getExtension(extension);
                    if (ext == null) {
                        StaticAnalyzer.getInstance().log(2, "Plugin.3", new Object[]{extension, this.getId()});
                    } else {
                        ext.getPlugin().addImports(imports);
                    }
                    ++i;
                }
            }
        }
    }

    private Object createExecutable(String className, Class requiredClass) {
        Object obj;
        Class<?> cls;
        if (className == null || this.loader == null) {
            return null;
        }
        try {
            cls = this.loader.loadClass(className);
        }
        catch (Throwable e) {
            StaticAnalyzer.getInstance().log(2, "Plugin.4", new Object[]{className});
            return null;
        }
        try {
            obj = cls.newInstance();
        }
        catch (Exception e) {
            StaticAnalyzer.getInstance().log(2, "Plugin.5", new Object[]{className, e});
            return null;
        }
        catch (NoClassDefFoundError e) {
            StaticAnalyzer.getInstance().log(2, "Plugin.5", new Object[]{className, e});
            return null;
        }
        if (!requiredClass.isInstance(obj)) {
            StaticAnalyzer.getInstance().log(2, "Plugin.6", new Object[]{className, requiredClass.getName()});
            return null;
        }
        return obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

