/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parser {
    DocumentBuilder parser;
    Document document;

    public Parser() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.parser = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean parse(InputSource in) {
        try {
            this.document = this.parser.parse(in);
        }
        catch (SAXException se) {
            se.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    public Element getElement(String path) {
        if (this.document == null) {
            return null;
        }
        return Parser.getElement(this.document.getDocumentElement(), path);
    }

    public static Element getElement(Element node, String path) {
        if (path.equals("/")) {
            return node;
        }
        if (path.startsWith("/" + node.getNodeName())) {
            Node child;
            int pos = node.getNodeName().length() + 1;
            if (pos == path.length()) {
                return node;
            }
            if (path.charAt(pos++) != '/') {
                return null;
            }
            do {
                int index;
                String tag = (index = path.indexOf(47, pos)) >= 0 ? path.substring(pos, index) : path.substring(pos);
                child = node.getFirstChild();
                while (child != null && !Parser.matchTag(child, tag)) {
                    child = child.getNextSibling();
                }
                pos = index + 1;
            } while ((node = (Element)child) != null && pos > 0);
            return node;
        }
        return null;
    }

    public static Element getFirstElement(Node node) {
        node = node.getFirstChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static Element getFirstElement(Node node, String tag) {
        node = node.getFirstChild();
        while (node != null && !Parser.matchTag(node, tag)) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static Element getNextElement(Node node) {
        while ((node = node.getNextSibling()) != null && node.getNodeType() != 1) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node node, String tag) {
        while ((node = node.getNextSibling()) != null && !Parser.matchTag(node, tag)) {
        }
        return (Element)node;
    }

    public static boolean matchTag(Node node, String tag) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        return tag.equals(node.getNodeName());
    }
}

