/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.core.IParameterBoolean;
import com.togethersoft.sca.core.IParameterInteger;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.internal.core.Parameter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;

public class ParameterRegistry
implements IParameterRegistry {
    private HashMap parameterMap = new HashMap();
    private ArrayList parameterList = new ArrayList();

    public boolean addParameter(IParameter entry) {
        if (this.parameterMap.get(entry.getId()) != null) {
            return false;
        }
        this.parameterMap.put(entry.getId(), entry);
        this.parameterList.add(entry);
        return true;
    }

    public boolean removeParameter(String id, boolean force) {
        Parameter p = (Parameter)this.parameterMap.get(id);
        if (p != null && (force || p.isRemovable())) {
            this.parameterMap.remove(id);
            ((AbstractCollection)this.parameterList).remove(p);
            return true;
        }
        return false;
    }

    public IParameter[] getParameters() {
        return this.parameterList.toArray(new IParameter[this.parameterList.size()]);
    }

    public IParameter getParameter(String id, int type) {
        IParameter p = (IParameter)this.parameterMap.get(id);
        if (p != null && (type < 0 || p.getType() == type)) {
            return p;
        }
        return null;
    }

    public IParameter getParameter(String id) {
        return (IParameter)this.parameterMap.get(id);
    }

    public boolean getBooleanValue(String id, boolean defaultValue) {
        IParameterBoolean param = (IParameterBoolean)this.getParameter(id, 1);
        return param != null ? param.getValue() : defaultValue;
    }

    public long getIntegerValue(String id, long defaultValue) {
        IParameterInteger param = (IParameterInteger)this.getParameter(id, 0);
        return param != null ? param.getValue() : defaultValue;
    }

    public Object clone() throws CloneNotSupportedException {
        ParameterRegistry cl = new ParameterRegistry();
        IParameter[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            cl.addParameter((IParameter)params[i].clone());
            ++i;
        }
        return cl;
    }
}

