/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.IParameterReal;
import com.togethersoft.sca.internal.core.Parameter;

public class ParameterReal
extends Parameter
implements IParameterReal {
    private Double defValue;
    private Double value;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    public ParameterReal(String name, String desc, String value, String minValue, String maxValue) throws IllegalArgumentException {
        super(name, desc);
        this.defValue = this.value = new Double(this.parseValue(value));
        if (minValue != null && !minValue.equals("")) {
            this.minValue = this.parseValue(minValue);
        }
        if (maxValue != null && !maxValue.equals("")) {
            this.maxValue = this.parseValue(maxValue);
        }
    }

    public int getType() {
        return 3;
    }

    public double getValue() {
        return this.value;
    }

    public double getDefaultValue() {
        return this.defValue;
    }

    public void setValue(double newValue) {
        this.value = new Double(newValue);
    }

    public String toString() {
        return this.value.toString();
    }

    private double parseValue(String s) throws IllegalArgumentException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid value '" + s + "' is specified for parameter " + this.getId());
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public Object clone() throws CloneNotSupportedException {
        ParameterReal cl = (ParameterReal)super.clone();
        cl.defValue = new Double(this.defValue);
        cl.value = new Double(this.value);
        return cl;
    }
}

