/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.IParameterInteger;
import com.togethersoft.sca.internal.core.Parameter;

public class ParameterInteger
extends Parameter
implements IParameterInteger {
    private Long defValue;
    private Long value;
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MAX_VALUE;

    public ParameterInteger(String name, String desc, String value, String minValue, String maxValue) throws IllegalArgumentException {
        super(name, desc);
        this.defValue = this.value = new Long(this.parseValue(value));
        if (minValue != null && !minValue.equals("")) {
            this.minValue = this.parseValue(minValue);
        }
        if (maxValue != null && !maxValue.equals("")) {
            this.maxValue = this.parseValue(maxValue);
        }
    }

    public int getType() {
        return 0;
    }

    public long getValue() {
        return this.value;
    }

    public long getDefaultValue() {
        return this.defValue;
    }

    public void setValue(long newValue) {
        this.value = new Long(newValue);
    }

    public String toString() {
        return this.getId() + ": " + this.value.toString();
    }

    private long parseValue(String s) throws IllegalArgumentException {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid value '" + s + "' is specified for parameter " + this.getId());
        }
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public Object clone() throws CloneNotSupportedException {
        ParameterInteger cl = (ParameterInteger)super.clone();
        cl.defValue = new Long(this.defValue);
        cl.value = new Long(this.value);
        return cl;
    }
}

