/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.IAnalyzerCategory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IAnalyzerRegistry;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.IExtension;
import com.togethersoft.sca.core.ILogListener;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.core.IParameterBoolean;
import com.togethersoft.sca.core.IParameterInteger;
import com.togethersoft.sca.core.IParameterReal;
import com.togethersoft.sca.core.IParameterString;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.core.IStaticAnalyzer;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.ParameterFactory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.ClientSourceBase;
import com.togethersoft.sca.internal.core.Parser;
import com.togethersoft.sca.internal.core.Project;
import com.togethersoft.sca.internal.core.StaticAnalyzer;
import com.togethersoft.sca.internal.jparser.ast.Model;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Loader
implements ILogListener {
    private static IStaticAnalyzer platform;
    private ArrayList files = new ArrayList();
    private ArrayList include = new ArrayList();
    private ArrayList exclude = new ArrayList();
    private ArrayList paramNames = new ArrayList();
    private ArrayList paramValues = new ArrayList();
    private String[] pluginPath;
    private String[] inspectors;
    private String classpath;
    private String filename;
    private String configFile;
    private Writer flog;
    private boolean quiet;
    private boolean xml;
    private boolean assertEnabled;
    private boolean nolog;
    private boolean autofixEnabled;
    private boolean list;
    private static boolean debug;

    public static void setPlatform(IStaticAnalyzer sa) {
        platform = sa;
    }

    private void parseArgs(String[] args) {
        if (args.length < 2) {
            this.usage();
        }
        ArrayList<String> inspList = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--inspector")) {
                if (i == args.length - 1) {
                    this.usage();
                }
                inspList.add(args[++i]);
            } else if (args[i].equals("--help")) {
                this.usage();
            } else if (args[i].equals("--list")) {
                this.list = true;
            } else if (args[i].equals("--quiet")) {
                this.quiet = true;
            } else if (args[i].equals("--nolog")) {
                this.nolog = true;
            } else if (args[i].equals("--xml")) {
                this.xml = true;
            } else if (args[i].equals("--assert")) {
                this.assertEnabled = true;
            } else if (args[i].equals("--autofix")) {
                this.autofixEnabled = true;
            } else if (args[i].equals("--plugins")) {
                if (i == args.length - 1) {
                    this.usage();
                }
                this.pluginPath = new String[]{args[++i]};
            } else if (args[i].equals("--p")) {
                String str;
                int eq;
                if (i == args.length - 1) {
                    this.usage();
                }
                if ((eq = (str = args[++i]).indexOf(61)) == 0 || eq == -1 || eq == str.length() - 1) {
                    this.usage();
                }
                this.paramNames.add(str.substring(0, eq));
                this.paramValues.add(str.substring(eq + 1, str.length()));
            } else if (args[i].equals("--f")) {
                if (i == args.length - 1) {
                    this.usage();
                }
                this.filename = args[++i];
                System.setProperty("SAPIENT.FILENAME", this.filename);
            } else if (args[i].equals("--cfg")) {
                if (i == args.length - 1) {
                    this.usage();
                }
                this.configFile = args[++i];
            } else if (args[i].equals("--cp")) {
                if (i == args.length - 1) {
                    this.usage();
                }
                this.classpath = args[++i];
            } else if (args[i].charAt(0) == '-') {
                this.exclude.add(args[i].substring(1, args[i].length()));
            } else if (args[i].charAt(0) == '+') {
                this.include.add(args[i].substring(1, args[i].length()));
            } else {
                this.files.add(args[i]);
            }
            ++i;
        }
        if (inspList.size() == 0 || this.files.size() == 0 && !this.list) {
            this.usage();
        }
        this.inspectors = inspList.toArray(new String[inspList.size()]);
    }

    private void usage() {
        System.err.println("Usage: Loader --inspector id [options] file1 [file2 ...]");
        System.err.println("  where options are:");
        System.err.println("  {+|-}analyzer      enable/disable analyzer");
        System.err.println("  --p <name>=<value> set inspector parameter");
        System.err.println("  --f file           redirect output to file");
        System.err.println("  --cfg file         read settings from file");
        System.err.println("  --cp path          use path for CLASSPATH");
        System.err.println("  --xml              generate XML output");
        System.err.println("  --quiet            quiet mode");
        System.err.println("  --assert           process assert as a keyword");
        System.err.println("  --list             show list of inspector analyzers");
        System.err.println("  --help             display help information");
        System.err.println();
        System.exit(1);
    }

    private void list() {
        int i = 0;
        while (i < this.inspectors.length) {
            ICodeInspector desc = platform.getCodeInspector(this.inspectors[i]);
            if (desc == null) {
                this.log(2, "Code inspector " + this.inspectors[i] + " was not found");
            } else {
                IAnalyzerRegistry registry = desc.getRegistry();
                IAnalyzerDescriptor[] analyzers = registry.getDescriptors();
                int j = 0;
                while (j < analyzers.length) {
                    System.out.println(analyzers[j]);
                    ++j;
                }
            }
            ++i;
        }
        platform.shutdown();
        System.exit(0);
    }

    private boolean initialize() {
        if (platform != null) {
            return true;
        }
        platform = Factory.getStaticAnalyzer();
        platform.getLog().addLogListener(this);
        if (!platform.init(this.pluginPath, null, null)) {
            return false;
        }
        IExtension[] extensions = platform.getExtensions();
        this.log(1, "Loaded " + extensions.length + " extension(s)");
        ICodeInspector[] inspectors = platform.getCodeInspectors();
        this.log(1, "Loaded " + inspectors.length + " code inspector(s)");
        return true;
    }

    private void run() {
        if (!this.initialize()) {
            return;
        }
        if (this.list) {
            this.list();
        }
        Project project = this.createProject();
        project.enableAssert(this.assertEnabled);
        project.getLog().addLogListener(this);
        if (this.xml) {
            project.getLog().setXML();
        }
        final JobControl jobControl = new JobControl(){

            public void start(String task) {
            }

            public void complete(int completed) {
                System.err.println("JOB: " + completed + '%');
            }
        };
        new Thread(new Runnable(){

            public void run() {
                System.err.println("Processing, press Enter to cancel...");
                try {
                    System.in.read();
                    jobControl.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        int i = 0;
        while (i < this.inspectors.length) {
            ICodeInspector desc = this.getCodeInspector(platform, this.inspectors[i]);
            if (desc != null) {
                platform.run(project, this.getAnalyzers(desc), jobControl);
                if (this.autofixEnabled) {
                    try {
                        ((Model)project.getModel()).print();
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
            }
            ++i;
        }
        platform.shutdown();
    }

    private List getAnalyzers(ICodeInspector inspector) {
        IAnalyzerDescriptor analyzer;
        int i;
        IAnalyzerDescriptor[] analyzers;
        IAnalyzerCategory category;
        String id;
        Iterator iter;
        IAnalyzerRegistry registry = inspector.getRegistry();
        ArrayList<IAnalyzerDescriptor> runList = new ArrayList<IAnalyzerDescriptor>();
        if (this.include.size() > 0) {
            iter = ((AbstractList)this.include).iterator();
            while (iter.hasNext()) {
                id = (String)iter.next();
                category = registry.getCategory(id);
                if (category != null) {
                    analyzers = category.getDescriptors();
                    i = 0;
                    while (i < analyzers.length) {
                        runList.add(analyzers[i]);
                        ++i;
                    }
                }
                if ((analyzer = registry.getDescriptor(id)) != null) {
                    runList.add(analyzer);
                }
                if (this.inspectors.length != 1 || category != null || analyzer != null) continue;
                this.log(2, "Analyzer " + id + " was not found");
            }
        } else {
            IAnalyzerDescriptor[] analyzers2 = registry.getDescriptors();
            int i2 = 0;
            while (i2 < analyzers2.length) {
                runList.add(analyzers2[i2]);
                ++i2;
            }
        }
        iter = ((AbstractList)this.exclude).iterator();
        while (iter.hasNext()) {
            id = (String)iter.next();
            category = registry.getCategory(id);
            if (category != null) {
                analyzers = category.getDescriptors();
                i = 0;
                while (i < analyzers.length) {
                    runList.remove(analyzers[i].getId());
                    ++i;
                }
            }
            if ((analyzer = registry.getDescriptor(id)) != null) {
                runList.remove(id);
            }
            if (this.inspectors.length != 1 || category != null || analyzer != null) continue;
            this.log(2, "Analyzer " + id + " was not found");
        }
        if (this.configFile != null) {
            this.configureDescriptors(inspector.getId(), runList);
        }
        return runList;
    }

    private void configureDescriptors(String inspectorId, List analyzers) {
        try {
            Parser parser = new Parser();
            if (parser.parse(new InputSource(new FileReader(new File(this.configFile))))) {
                Element root = parser.getElement("/AuditRuleConfiguration");
                if (root == null) {
                    StaticAnalyzer.getInstance().log(2, "Loader.1", new Object[]{this.configFile});
                    return;
                }
                Element node = Parser.getFirstElement(root, "rule");
                while (node != null) {
                    String id = node.getAttribute("id");
                    String inspector = node.getAttribute("inspector");
                    if (inspector == null || id == null) {
                        StaticAnalyzer.getInstance().log(2, "Loader.1", new Object[]{this.configFile});
                        return;
                    }
                    if (inspector.equals(inspectorId)) {
                        int i = 0;
                        while (i < analyzers.size()) {
                            IAnalyzerDescriptor desc = (IAnalyzerDescriptor)analyzers.get(i);
                            if (desc.getId().equals(id)) {
                                if (this.setParameters(desc, Parser.getFirstElement(node, "parameters"))) {
                                    if (desc.getParameterRegistry().getBooleanValue("enabled", true)) break;
                                    analyzers.remove(id);
                                    break;
                                }
                                StaticAnalyzer.getInstance().log(2, "Loader.2", new Object[]{id});
                                break;
                            }
                            ++i;
                        }
                    }
                    node = Parser.getNextElement(node, "rule");
                }
            }
        }
        catch (Exception e) {
            StaticAnalyzer.getInstance().log(2, "Loader.3", new Object[]{this.configFile});
        }
    }

    private void setParameters(ICodeInspector inspector) {
        IParameter[] params = inspector.getParameterRegistry().getParameters();
        int i = 0;
        while (i < this.paramNames.size()) {
            String name = (String)this.paramNames.get(i);
            String value = (String)this.paramValues.get(i);
            int j = 0;
            while (j < params.length) {
                if (params[j].getType() == 2 && params[j].getId().equals(name)) {
                    ((IParameterString)params[j]).setValue(value);
                    break;
                }
                this.log(2, "Parameter " + name + " was not found");
                ++j;
            }
            ++i;
        }
    }

    private boolean setParameters(IAnalyzerDescriptor desc, Element root) {
        if (root == null) {
            System.err.println("##");
            return false;
        }
        Element node = Parser.getFirstElement(root, "parameter");
        while (node != null) {
            int parType;
            String id = node.getAttribute("id");
            String type = node.getAttribute("type");
            String value = node.getAttribute("value");
            if (id == null || type == null || value == null) {
                return false;
            }
            try {
                parType = Integer.parseInt(type);
            }
            catch (NumberFormatException e) {
                return false;
            }
            IParameter par = desc.getParameterRegistry().getParameter(id, parType);
            if (par != null) {
                if (!this.configureParameter(par, value)) {
                    return false;
                }
            } else {
                par = ParameterFactory.createStringParameter(id);
                ((IParameterString)par).setValue(value);
                desc.getParameterRegistry().addParameter(par);
            }
            node = Parser.getNextElement(node, "parameter");
        }
        return true;
    }

    private boolean configureParameter(IParameter par, String value) {
        switch (par.getType()) {
            case 2: {
                ((IParameterString)par).setValue(value);
                break;
            }
            case 4: {
                try {
                    ((IParameterStringEnum)par).setValue(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 0: {
                try {
                    ((IParameterInteger)par).setValue(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 3: {
                try {
                    ((IParameterReal)par).setValue(Double.parseDouble(value));
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 1: {
                ((IParameterBoolean)par).setValue(new Boolean(value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void openLogFile() {
        if (this.filename != null && !this.nolog) {
            try {
                this.flog = new BufferedWriter(new FileWriter(this.filename));
            }
            catch (Exception e) {
                this.log(2, "Cannot open output file: " + e.getMessage());
            }
        }
    }

    private void closeLogFile() {
        if (this.flog != null) {
            try {
                this.flog.close();
            }
            catch (Exception e) {
                this.log(2, "Cannot close output file: " + e.getMessage());
            }
        }
    }

    private Project createProject() {
        Project project = new Project(null, 4, this.classpath);
        ClientSourceBase base = Factory.createLocalSourceBase();
        project.addSourceBase(base);
        int i = 0;
        while (i < this.files.size()) {
            this.doFile(new File((String)this.files.get(i)), base, false);
            ++i;
        }
        return project;
    }

    private ICodeInspector getCodeInspector(IStaticAnalyzer platform, String id) {
        ICodeInspector desc = platform.getCodeInspector(id);
        if (desc == null) {
            this.log(2, "Code inspector " + id + " was not found");
        }
        return desc;
    }

    private void doFile(File f, ClientSourceBase base, boolean javaFilesOnly) {
        try {
            String name = f.getName();
            if (f.isDirectory()) {
                String[] files = f.list();
                if (files != null) {
                    int i = 0;
                    while (i < files.length) {
                        this.doFile(new File(f, files[i]), base, true);
                        ++i;
                    }
                }
            } else if (!javaFilesOnly || name.length() > 5 && name.substring(name.length() - 5).equals(".java")) {
                base.addFile(f.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void receive(IMessage message) {
        AutoFix[] fixes;
        this.log(message.getSeverity(), message.getMessage(this.xml));
        if (this.autofixEnabled && message instanceof IAuditMessage && (fixes = ((IAuditMessage)message).getAutoFixes()).length > 0) {
            fixes[0].fix();
        }
    }

    private void log(int severity, String text) {
        if (severity == 0 && this.nolog) {
            return;
        }
        if (severity == 1 && !debug) {
            return;
        }
        if (severity != 0 && this.quiet) {
            return;
        }
        String msg = Loader.getPrefix(severity) + text;
        if (this.flog != null) {
            try {
                this.flog.write(msg);
                this.flog.write(10);
            }
            catch (Exception e) {
                this.flog = null;
                this.log(2, "Cannot write to output file: " + e.getMessage());
            }
        } else {
            System.out.println(msg);
        }
    }

    private static String getPrefix(int severity) {
        String s;
        switch (severity) {
            case 3: {
                s = "FATAL: ";
                break;
            }
            case 2: {
                s = "ERROR: ";
                break;
            }
            case 1: {
                s = "DEBUG: ";
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }

    public static void main(String[] args) {
        Loader loader = new Loader();
        loader.parseArgs(args);
        loader.openLogFile();
        loader.run();
        loader.closeLogFile();
        System.exit(0);
    }

    static {
        debug = Boolean.getBoolean("DEBUG");
    }
}

