/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.IExtension;
import com.togethersoft.sca.core.IExtensionExecutable;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.internal.core.ParameterRegistry;
import com.togethersoft.sca.internal.core.Plugin;
import com.togethersoft.sca.internal.core.StaticAnalyzer;
import java.net.URL;

class Extension
implements IExtension {
    private String id;
    private String name;
    protected ParameterRegistry registry;
    protected String runclass;
    protected Plugin plugin;

    Extension(String id, String name, ParameterRegistry registry, String runclass, Plugin plugin) {
        this.id = id;
        this.name = name;
        this.registry = registry;
        this.runclass = runclass;
        this.plugin = plugin;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URL getLocation() {
        return this.plugin.getLocation();
    }

    public URL getLocalizedLocation() {
        return this.plugin.getLocalizedLocation();
    }

    public URL find(String path) {
        int extPoint = path.lastIndexOf(46);
        if (extPoint > 0) {
            return this.plugin.find(path.substring(0, extPoint), path.substring(extPoint));
        }
        return this.plugin.find(path, null);
    }

    public IParameterRegistry getParameterRegistry() {
        return this.registry;
    }

    public IExtensionExecutable createExecutableExtension() {
        IExtensionExecutable executable = this.plugin.createExtensionExecutable(this.runclass);
        if (executable == null) {
            StaticAnalyzer.getInstance().log(2, "Extention.1", new Object[]{this.name});
        } else {
            executable.setParameters(this.registry);
        }
        return executable;
    }

    Plugin getPlugin() {
        return this.plugin;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IExtension) {
            return this.getId().equals(((IExtension)obj).getId());
        }
        return false;
    }
}

