/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

public class ErrorLog {
    public static final int ERRLEVEL_FATAL = 0;
    public static final int ERRLEVEL_ERROR = 1;
    public static final int ERRLEVEL_WARNING = 2;
    public static final int ERRLEVEL_INFO = 3;
    public static final int ERRLEVEL_DEBUG = 4;
    public static boolean debug = Boolean.getBoolean("DEBUG");

    public static void log(int severity, String msg) {
        if (severity != 4 || debug) {
            System.err.println(ErrorLog.getPrefix(severity) + msg);
        }
        if (severity == 0) {
            System.exit(1);
        }
    }

    private static String getPrefix(int severity) {
        String s;
        switch (severity) {
            case 0: {
                s = "FATAL: ";
                break;
            }
            case 1: {
                s = "ERROR: ";
                break;
            }
            case 2: {
                s = "WARNING: ";
                break;
            }
            case 3: {
                s = "INFO: ";
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }
}

