/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.core;

import com.togethersoft.sca.core.IAnalyzerCategory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.core.AnalyzerDescriptor;
import java.util.ArrayList;

public final class AnalyzerCategory
implements IAnalyzerCategory,
Cloneable {
    private String id;
    private String name;
    private IAnalyzerCategory category;
    private ArrayList analyzers;
    private ArrayList categories;

    public AnalyzerCategory(String id, String name, IAnalyzerCategory category) {
        this.id = id;
        this.name = name;
        this.category = category;
        this.analyzers = new ArrayList();
        this.categories = new ArrayList();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IAnalyzerCategory getCategory() {
        return this.category;
    }

    public void addDescriptor(IAnalyzerDescriptor entry) {
        ((AnalyzerDescriptor)entry).setCategory(this);
        this.analyzers.add(entry);
    }

    public void addCategory(IAnalyzerCategory entry) {
        ((AnalyzerCategory)entry).setCategory(this);
        this.categories.add(entry);
    }

    public IAnalyzerDescriptor[] getDescriptors() {
        return this.analyzers.toArray(new IAnalyzerDescriptor[this.analyzers.size()]);
    }

    public IAnalyzerCategory[] getCategories() {
        return this.categories.toArray(new IAnalyzerCategory[this.categories.size()]);
    }

    public String toString() {
        return "<AnalyzerCategory id=" + this.id + " name=" + this.name + " />";
    }

    public Object clone() throws CloneNotSupportedException {
        AnalyzerCategory ret = new AnalyzerCategory(new String(this.id), new String(this.name), this.category);
        IAnalyzerDescriptor[] descs = this.getDescriptors();
        int i = 0;
        while (i < descs.length) {
            ret.addDescriptor((IAnalyzerDescriptor)descs[i].clone());
            ++i;
        }
        IAnalyzerCategory[] cats = this.getCategories();
        int i2 = 0;
        while (i2 < cats.length) {
            ret.addCategory((AnalyzerCategory)cats[i2].clone());
            ++i2;
        }
        return ret;
    }

    private void setCategory(IAnalyzerCategory category) {
        this.category = category;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IAnalyzerCategory) {
            return this.getId().equals(((IAnalyzerCategory)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

