/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core.plugin.report;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.core.plugin.report.IReportMessage;

public class ReportMessage
implements IReportMessage {
    private String projectName;
    private String packageName;
    private String cuName;
    private String className;
    private String methodName;
    private IAnalyzerDescriptor analyzer;
    private IReportMessage[] subMessages;
    private String message;
    private String problemSeverity;
    private int endColumn = 0;
    private int endLine = 0;
    private int startColumn = 0;
    private int startLine = 0;
    private String fileName = "";
    private int objectKind = 0;

    public ReportMessage(String projectName, IAuditMessage msg) {
        this.projectName = projectName;
        AstObject obj = msg.getAstObject();
        if (obj != null) {
            AstSourcePosition position = obj.getPosition();
            if (position != null) {
                this.endColumn = position.getEndColumn();
                this.endLine = position.getEndLine();
                this.startColumn = position.getStartColumn();
                this.startLine = position.getStartLine();
                this.fileName = position.getFileName();
            }
            this.objectKind = obj.getObjectKind();
        }
        this.message = msg.getMessage();
        this.analyzer = msg.getAnalyzer();
        this.problemSeverity = msg.getProblemSeverity();
        IAuditMessage[] subMessages = msg.getSubMessages();
        if (subMessages != null) {
            this.subMessages = new IReportMessage[subMessages.length];
            int i = 0;
            while (i < subMessages.length) {
                this.subMessages[i] = new ReportMessage(projectName, subMessages[i]);
                ++i;
            }
        }
        while (obj != null) {
            if (obj instanceof AstMethod) {
                if (this.methodName == null) {
                    this.methodName = ((AstMethod)obj).getQualifiedName();
                }
            } else if (obj instanceof AstType) {
                if (this.className == null) {
                    this.className = ((AstType)obj).getTypeName();
                }
            } else if (obj instanceof AstCompilationUnit) {
                this.cuName = ((AstCompilationUnit)obj).getElementName();
            } else if (obj instanceof AstPackage && this.packageName == null) {
                this.packageName = ((AstPackage)obj).getQualifiedName();
            }
            obj = obj.getParent();
        }
    }

    public IAnalyzerDescriptor getAnalyzer() {
        return this.analyzer;
    }

    public String getCompilationUnitName() {
        return this.cuName;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getProblemSeverity() {
        return this.problemSeverity;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public IReportMessage[] getSubMessages() {
        return this.subMessages;
    }

    public String getTypeName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getAstObjectKind() {
        return this.objectKind;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

