/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core.plugin.report;

import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IAnalyzerRegistry;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.ICodeInspectorExecutable;
import com.togethersoft.sca.core.IExtension;
import com.togethersoft.sca.core.IExtensionExecutable;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.IStaticAnalyzer;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.plugin.report.IMessageFilter;
import com.togethersoft.sca.core.plugin.report.IReportMessage;
import com.togethersoft.sca.core.plugin.report.IReporter;
import com.togethersoft.sca.core.plugin.report.MessageList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ReportManager
implements ICodeInspectorExecutable {
    private IReporter[] allReporters = new IReporter[0];
    private IMessageFilter[] allFilters = new IMessageFilter[0];

    public void setParameters(IParameterRegistry registry) {
        this.loadModules();
    }

    public void configureRegistry(IAnalyzerRegistry registry) {
    }

    public void run(IProject project, IAnalyzerDescriptor[] analyzers, JobControl jobControl) {
        String filename = System.getProperty("SAPIENT.FILENAME");
        if (filename == null) {
            filename = "out.html";
        }
        this.run(new IProject[]{project}, null, null, null, new File(filename), jobControl);
    }

    public void run(IProject[] projects, IAnalyzerDescriptor[] analyzers, IReporter[] reportersSelected, IMessageFilter[] filtersSelected, File output, JobControl jobControl) {
        List<IAnalyzerDescriptor> analyzerList;
        if (reportersSelected == null) {
            reportersSelected = this.allReporters;
        }
        if (filtersSelected == null) {
            filtersSelected = this.allFilters;
        }
        IStaticAnalyzer sa = Factory.getStaticAnalyzer();
        MessageList mList = new MessageList();
        if (analyzers != null) {
            analyzerList = Arrays.asList(analyzers);
        } else {
            String[] analyzerNames = this.analyzersRequired(reportersSelected, filtersSelected);
            ICodeInspector[] inspectors = new ICodeInspector[analyzerNames.length];
            int i = 0;
            while (i < inspectors.length) {
                inspectors[i] = sa.getCodeInspector(analyzerNames[i]);
                ++i;
            }
            analyzerList = new ArrayList<IAnalyzerDescriptor>();
            int i2 = 0;
            while (i2 < inspectors.length) {
                if (inspectors[i2] != null) {
                    analyzerList.addAll(Arrays.asList(inspectors[i2].getRegistry().getDescriptors()));
                }
                ++i2;
            }
        }
        if (jobControl != null) {
            jobControl.setScale(1.0 / (double)(projects.length + 1));
        }
        int j = 0;
        while (j < projects.length) {
            ILog theLog = projects[j].getLog();
            mList.setCurrentProjectName(projects[j].getProjectName());
            theLog.addLogListener(mList);
            sa.run(projects[j], analyzerList, jobControl);
            theLog.removeLogListener(mList);
            ++j;
        }
        if (jobControl != null) {
            jobControl.setScale(projects.length + 1);
        }
        this.run(projects, reportersSelected, filtersSelected, output, mList, jobControl);
    }

    public void run(IProject[] projects, File output, IReportMessage[] messages, JobControl jobControl) {
        this.run(projects, this.allReporters, this.allFilters, output, new MessageList(messages), jobControl);
    }

    protected void run(IProject[] projects, IReporter[] reportersSelected, IMessageFilter[] filtersSelected, File output, MessageList mList, JobControl jobControl) {
        PrintStream stream;
        try {
            if (output.getParentFile() != null) {
                output.getParentFile().mkdirs();
            }
            stream = new PrintStream(new BufferedOutputStream(new FileOutputStream(output)));
        }
        catch (IOException e) {
            return;
        }
        String theProjectName = projects.length > 0 ? projects[0].getProjectName() : "[The Project]";
        int i = 0;
        while (i < filtersSelected.length) {
            mList = filtersSelected[i].apply(mList);
            ++i;
        }
        if (jobControl != null) {
            jobControl.setScale(mList.elementsUsed() > 0 ? (double)mList.elementsUsed() : 1.0);
        }
        int i2 = 0;
        while (i2 < reportersSelected.length) {
            MessageList inList = mList;
            IMessageFilter[] specialFilters = reportersSelected[i2].filtersRequired();
            int j = 0;
            while (j < specialFilters.length) {
                inList = specialFilters[j].apply(inList);
                ++j;
            }
            reportersSelected[i2].generate(output, stream, inList, theProjectName, jobControl);
            ++i2;
        }
        if (jobControl == null || !jobControl.isCanceled()) {
            stream.close();
        }
    }

    public void loadModules() {
        IExtension[] ext = Factory.getStaticAnalyzer().getExtensions();
        ArrayList<IExtensionExecutable> reporterList = new ArrayList<IExtensionExecutable>();
        ArrayList<IExtensionExecutable> filterList = new ArrayList<IExtensionExecutable>();
        int i = 0;
        while (i < ext.length) {
            IExtensionExecutable module;
            if (ext[i].getId().endsWith("Report")) {
                module = ext[i].createExecutableExtension();
                if (module != null) {
                    reporterList.add(module);
                }
            } else if (ext[i].getId().endsWith("Filter") && (module = ext[i].createExecutableExtension()) != null) {
                filterList.add(module);
            }
            ++i;
        }
        this.allReporters = reporterList.toArray(new IReporter[reporterList.size()]);
        this.allFilters = filterList.toArray(new IMessageFilter[filterList.size()]);
    }

    public IReporter[] reportersAvailable() {
        return this.allReporters;
    }

    public IMessageFilter[] filtersAvailable() {
        return this.allFilters;
    }

    private final String[] analyzersRequired(IReporter[] reportersSelected, IMessageFilter[] filtersSelected) {
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < reportersSelected.length) {
            String[] w = reportersSelected[i].analyzersRequired();
            if (w != null) {
                int j = 0;
                while (j < w.length) {
                    names.add(w[j]);
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < filtersSelected.length) {
            String[] w = filtersSelected[i2].analyzersRequired();
            if (w != null) {
                int j = 0;
                while (j < w.length) {
                    names.add(w[j]);
                    ++j;
                }
            }
            ++i2;
        }
        return ((AbstractCollection)names).toArray(new String[names.size()]);
    }
}

