/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core.plugin.report;

import com.togethersoft.sca.core.ILogListener;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.core.plugin.report.IReportMessage;
import com.togethersoft.sca.core.plugin.report.ReportMessage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class MessageList
implements ILogListener {
    private static final int initialSize = 1000;
    private static final int sizeIncrement = 2000;
    private int current;
    private int used;
    private IReportMessage[] messages;
    private String projectName;

    MessageList() {
        this(1000);
    }

    MessageList(int capacity) {
        this.messages = new IReportMessage[capacity];
        this.used = 0;
    }

    MessageList(MessageList list) {
        this.messages = new IReportMessage[list.messages.length];
        this.used = list.used;
        int i = 0;
        while (i < this.used) {
            this.messages[i] = list.messages[i];
            ++i;
        }
    }

    MessageList(IReportMessage[] messages) {
        this.messages = new IReportMessage[messages.length];
        System.arraycopy(messages, 0, this.messages, 0, messages.length);
        this.used = messages.length;
    }

    public void setCurrentProjectName(String projectName) {
        this.projectName = projectName;
    }

    public IReportMessage[] asArray() {
        return this.messages;
    }

    public int elementsUsed() {
        return this.used;
    }

    public void receive(IReportMessage message) {
        if (this.used == this.messages.length) {
            IReportMessage[] newMessages = new IReportMessage[this.messages.length + 2000];
            int i = 0;
            while (i < this.used) {
                newMessages[i] = this.messages[i];
                ++i;
            }
            this.messages = newMessages;
        }
        this.messages[this.used] = message;
        ++this.used;
    }

    public void receive(IMessage m) {
        if (m.getSeverity() != 0 || !(m instanceof IAuditMessage)) {
            return;
        }
        this.receive(new ReportMessage(this.projectName, (IAuditMessage)m));
    }

    public IReportMessage getCurrentMessage() {
        if (this.current >= this.used) {
            return null;
        }
        return this.messages[this.current];
    }

    public IReportMessage getFirstMessage() {
        this.current = 0;
        return this.getCurrentMessage();
    }

    public IReportMessage getNextMessage() {
        ++this.current;
        return this.getCurrentMessage();
    }

    public void dumpToFile(String fileName, JobControl jobControl) {
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(fileName));
            this.dumpToStream(out, jobControl);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (out != null) {
            out.close();
        }
    }

    public void dumpToStream(PrintStream out, JobControl jobControl) {
        out.println("<audit>");
        int i = 0;
        while (i < this.used) {
            out.println(this.messages[i].toString());
            jobControl.update((double)this.used / 100.0);
            ++i;
        }
        out.println("</audit>");
    }
}

