/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core.plugin.audit;

import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class AutoFix {
    public abstract String getName();

    public abstract boolean fix(InputStream var1, OutputStream var2);

    public abstract boolean fix();

    public static AutoFix[] decodeAutoFixes(String s) {
        ArrayList<ESAutoFix> fixes = new ArrayList<ESAutoFix>();
        StringTokenizer tokenizer = new StringTokenizer(s, "\u0000");
        while (tokenizer.hasMoreTokens()) {
            ESAutoFix fix = ESAutoFix.fromString(tokenizer.nextToken());
            if (fix == null) continue;
            fixes.add(fix);
        }
        return fixes.toArray(new AutoFix[fixes.size()]);
    }

    public static String encodeAutoFixes(AutoFix[] fixes) {
        if (fixes == null || fixes.length == 0) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < fixes.length) {
            if (i > 0) {
                sbuf.append('\u0000');
            }
            if (fixes[i] instanceof ESAutoFix) {
                sbuf.append(fixes[i].toString());
            }
            ++i;
        }
        return sbuf.toString();
    }
}

