/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core.plugin;

import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.plugin.ITemplateFormatter;
import com.togethersoft.sca.core.plugin.TemplateFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TemplateManager {
    public static final String TMPL_EXT = ".tmpl";
    public static final char ORDINARY_CHAR = '%';
    private String DOC_PATH = "docs/";
    private String DOC_EXT = ".tmpl";
    private HashMap messagesCache;
    private ITemplateFormatter formatter;
    private HashMap resourcesBundle;
    private static TemplateManager templateManager = null;

    private TemplateManager() {
        this.messagesCache = new HashMap();
        this.resourcesBundle = null;
    }

    public TemplateManager(ITemplateFormatter formatter) {
        this.formatter = formatter;
        this.messagesCache = new HashMap();
    }

    public static TemplateManager getTemplateManager() {
        if (templateManager == null) {
            templateManager = new TemplateManager();
        }
        return templateManager;
    }

    public void setTemplateFormatter(ITemplateFormatter templateFormatter) {
        this.formatter = templateFormatter;
    }

    public ITemplateFormatter getTemplateFormatter() {
        if (this.formatter == null) {
            this.formatter = new TemplateFormatter();
        }
        return this.formatter;
    }

    public String format(String baseName, String template, Object[] values) {
        return this.format(this.getResourceBundle(baseName, Locale.getDefault()), template, values);
    }

    public String format(String baseName, Locale locale, String template, Object[] values) {
        return this.format(this.getResourceBundle(baseName, locale), template, values);
    }

    public String format(ResourceBundle resourceBundle, String template, Object[] values) {
        if (template == null) {
            return null;
        }
        if (resourceBundle != null) {
            try {
                template = resourceBundle.getString(template);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return this.substValues(template, values);
    }

    public String format(String template, Object[] values) {
        return this.substValues(template, values);
    }

    public String formatTemplateFile(String fileName, IAnalyzerDescriptor analyzer, Object[] values) {
        ICodeInspector ext = analyzer.getInspector();
        if (ext != null) {
            fileName = ext.find(this.DOC_PATH + fileName).getFile();
        }
        return this.formatTemplateFile(fileName, null, Locale.getDefault(), values);
    }

    public String formatTemplateFile(String fileName, ClassLoader loader, Object[] values) {
        return this.formatTemplateFile(fileName, loader, Locale.getDefault(), values);
    }

    /*
     * WARNING - void declaration
     */
    public String formatTemplateFile(String fileName, ClassLoader loader, Locale locale, Object[] values) {
        String message = (String)this.messagesCache.get(fileName);
        if (message == null) {
            String localeFileName = fileName;
            String localeSuffix = locale.toString();
            if (localeSuffix.length() > 0) {
                localeFileName = localeFileName + "_" + localeSuffix;
            } else if (locale.getVariant().length() > 0) {
                localeFileName = localeFileName + "___" + locale.getVariant();
            }
            InputStream in = this.loadTemplateFile(loader, fileName + "_" + locale.getLanguage());
            if (in == null) {
                in = this.loadTemplateFile(loader, localeFileName);
            }
            if (in == null) {
                in = this.loadTemplateFile(loader, fileName);
            }
            if (in == null) {
                return null;
            }
            try {
                int rc;
                StringBuffer sb = new StringBuffer();
                byte[] buf = new byte[4096];
                while ((rc = in.read(buf, 0, 4096)) >= 0) {
                    void var9_11;
                    sb.append(new String(buf, 0, (int)var9_11));
                }
                in.close();
                message = sb.toString();
                this.messagesCache.put(fileName, message);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this.substValues(message, values);
    }

    /*
     * WARNING - void declaration
     */
    protected String substValues(String template, Object[] values) {
        if (values == null) {
            return template;
        }
        StringReader sr = new StringReader(template);
        StreamTokenizer st = new StreamTokenizer(sr);
        StringBuffer result = new StringBuffer();
        st.resetSyntax();
        st.wordChars(0, 255);
        st.ordinaryChar(37);
        int numArg = 0;
        try {
            int ttype;
            while ((ttype = st.nextToken()) != -1) {
                void var6_7;
                if (var6_7 == 37) {
                    ttype = st.nextToken();
                    if (ttype == -1) break;
                    if (st.sval != null) {
                        int i = 0;
                        int numSelectedArg = -1;
                        char ch = st.sval.charAt(i);
                        while (ch >= '0' && ch <= '9') {
                            ch = st.sval.charAt(++i);
                        }
                        if (i > 0) {
                            try {
                                numSelectedArg = Integer.parseInt(st.sval.substring(0, i));
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if (i < st.sval.length()) {
                            char formatChar = st.sval.charAt(i);
                            boolean isQualified = false;
                            int nArg = numArg++;
                            if (numSelectedArg > 0) {
                                nArg = numSelectedArg - 1;
                            }
                            if (formatChar == 'q' && i + 1 < st.sval.length()) {
                                isQualified = true;
                                formatChar = st.sval.charAt(++i);
                            }
                            if (nArg >= 0 && nArg < values.length && values[nArg] != null) {
                                try {
                                    String formattedString = this.getTemplateFormatter().format(isQualified, formatChar, values[nArg]);
                                    if (formattedString != null) {
                                        result.append(formattedString);
                                    }
                                }
                                catch (ClassCastException e) {
                                    System.err.println("ClassCastException in template " + template + " char " + formatChar + " from object " + values[nArg]);
                                }
                            }
                        }
                        if (i + 1 >= st.sval.length()) continue;
                        result.append(st.sval.substring(i + 1));
                        continue;
                    }
                    result.append('%');
                    continue;
                }
                result.append(st.sval);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return result.toString();
    }

    protected InputStream loadTemplateFile(ClassLoader loader, String fileName) {
        if (loader == null) {
            try {
                return new URL(fileName + TMPL_EXT).openStream();
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return loader.getResourceAsStream(fileName.replace('.', '/') + TMPL_EXT);
    }

    protected ResourceBundle getResourceBundle(String baseName, Locale locale) {
        ResourceBundle resourceBundle;
        if (this.resourcesBundle == null) {
            this.resourcesBundle = new HashMap();
        }
        if ((resourceBundle = (ResourceBundle)this.resourcesBundle.get(baseName)) == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale);
                this.resourcesBundle.put(baseName, resourceBundle);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return resourceBundle;
    }
}

