/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core.plugin;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.plugin.ITemplateFormatter;

public class TemplateFormatter
implements ITemplateFormatter {
    public String format(boolean isQualified, char key, Object printObject) {
        switch (key) {
            case 'h': {
                return "0x" + Long.toHexString((Long)printObject);
            }
            case 'i': 
            case 's': {
                return printObject.toString();
            }
            case 'm': {
                if (isQualified) {
                    return ((AstMethod)printObject).getQualifiedName().replace('/', '.');
                }
                return ((AstMethod)printObject).getElementName();
            }
            case 'f': {
                if (isQualified) {
                    return ((AstField)printObject).getQualifiedName().replace('/', '.');
                }
                return ((AstField)printObject).getElementName();
            }
            case 't': {
                if (printObject instanceof AstType) {
                    if (isQualified) {
                        return ((AstType)printObject).getQualifiedName().replace('/', '.');
                    }
                    return ((AstType)printObject).getElementName();
                }
                if (((AstTypeReference)printObject).getBaseType() != null) {
                    if (isQualified) {
                        return ((AstTypeReference)printObject).getBaseType().getQualifiedName().replace('/', '.');
                    }
                    return ((AstTypeReference)printObject).getBaseType().getElementName();
                }
                return "?";
            }
            case 'c': {
                if (isQualified) {
                    return ((AstType)printObject).getQualifiedName().replace('/', '.');
                }
                return ((AstType)printObject).getElementName();
            }
            case 'p': {
                if (isQualified) {
                    return ((AstPackage)printObject).getQualifiedName().replace('/', '.');
                }
                return ((AstPackage)printObject).getElementName();
            }
            case 'v': {
                return ((AstVariable)printObject).getElementName();
            }
            case 'd': {
                return ((AstDeclaration)printObject).getElementName();
            }
            case 'a': {
                Object[] values = (Object[])printObject;
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(values[i]);
                    ++i;
                }
                return sb.toString();
            }
        }
        return null;
    }
}

