/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core.plugin;

import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.plugin.ITemplateFormatter;
import com.togethersoft.sca.core.plugin.TemplateFormatter;
import java.io.File;
import java.net.URL;

public class HTMLTemplateFormatter
extends TemplateFormatter
implements ITemplateFormatter {
    private String DOC_PATH = "docs/";
    private String DOC_EXT = ".html";

    protected String getDocPath(IAnalyzerDescriptor analyzer) {
        ICodeInspector ext = analyzer.getInspector();
        if (ext != null) {
            return ext.find(this.DOC_PATH + analyzer.getId() + this.DOC_EXT).getFile();
        }
        return null;
    }

    public String format(boolean isQualified, char key, Object printObject) {
        switch (key) {
            case 'A': {
                IAnalyzerDescriptor analyzer = (IAnalyzerDescriptor)printObject;
                String analyzerName = analyzer.getName() + " (" + analyzer.getId() + ")";
                if (isQualified && this.getDocPath(analyzer) != null) {
                    return "<A HREF=\"" + this.getDocPath(analyzer) + "\"> " + analyzerName + "</a>";
                }
                return analyzerName;
            }
            case 'U': {
                IAnalyzerDescriptor analyzer = (IAnalyzerDescriptor)printObject;
                ICodeInspector ext = analyzer.getInspector();
                if (ext != null) {
                    URL location = ext.getLocalizedLocation();
                    if (location == null || !new File(location.getFile() + this.DOC_PATH).exists()) {
                        location = ext.getLocation();
                    }
                    return location.toString() + this.DOC_PATH;
                }
                return null;
            }
        }
        return super.format(isQualified, key, printObject);
    }
}

