/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.core;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IExtension;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.plugin.TemplateManager;
import java.util.HashMap;

public class Message
implements IMessage {
    private int severity;
    protected String message;
    private HashMap properties;
    private IExtension extension;
    private IAnalyzerDescriptor analyzer;
    protected AstObject ast;
    protected Object[] values;

    public Message(int severity, String message, Object[] values) {
        this.severity = severity;
        this.message = message;
        this.values = values;
    }

    public Message(int severity, IExtension extension, IAnalyzerDescriptor analyzer, AstObject ast, String message, Object[] values) {
        this(severity, message, values);
        this.extension = extension;
        this.analyzer = analyzer;
        this.ast = ast;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return TemplateManager.getTemplateManager().format(this.message, this.values);
    }

    public String getMessage(boolean isXML) {
        return this.getMessage();
    }

    public String getExplainMessage() {
        return null;
    }

    public Object getProperty(String id) {
        if (this.properties != null) {
            return this.properties.get(id);
        }
        return null;
    }

    public void setProperty(String id, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(id, value);
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public IExtension getExtension() {
        return this.extension;
    }

    public IAnalyzerDescriptor getAnalyzer() {
        return this.analyzer;
    }

    public AstObject getAstObject() {
        return this.ast;
    }

    public String getFileName() {
        AstSourcePosition pos;
        if (this.ast != null && (pos = this.ast.getPosition()) != null) {
            return pos.getFileName();
        }
        return "";
    }

    public int getStartLine() {
        AstSourcePosition pos;
        if (this.ast != null && (pos = this.ast.getPosition()) != null) {
            return pos.getStartLine();
        }
        return 0;
    }

    public int getStartColumn() {
        AstSourcePosition pos;
        if (this.ast != null && (pos = this.ast.getPosition()) != null) {
            return pos.getStartColumn();
        }
        return 0;
    }

    public int getEndLine() {
        AstSourcePosition pos;
        if (this.ast != null && (pos = this.ast.getPosition()) != null) {
            return pos.getEndLine();
        }
        return 0;
    }

    public int getEndColumn() {
        AstSourcePosition pos;
        if (this.ast != null && (pos = this.ast.getPosition()) != null) {
            return pos.getEndColumn();
        }
        return 0;
    }

    public String toString() {
        return this.message;
    }
}

