/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.win32;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.help.ui.internal.WorkbenchHelpPlugin;
import org.eclipse.help.ui.internal.browser.win32.HelpControlSite;
import org.eclipse.help.ui.internal.browser.win32.ICommandStateChangedListener;
import org.eclipse.help.ui.internal.browser.win32.IDocumentCompleteListener;
import org.eclipse.help.ui.internal.browser.win32.IEHost;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.help.ui.internal.util.HelpWorkbenchException;
import org.eclipse.help.ui.internal.util.WorkbenchResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WebBrowser
implements OleListener {
    public static final short CSC_UPDATECOMMANDS = -1;
    public static final short CSC_NAVIGATEFORWARD = 1;
    public static final short CSC_NAVIGATEBACK = 2;
    public static final int BeforeNavigate = 100;
    public static final int NavigateComplete = 101;
    public static final int StatusTextChange = 102;
    public static final int ProgressChange = 108;
    public static final int DownloadComplete = 104;
    public static final int CommandStateChange = 105;
    public static final int DownloadBegin = 106;
    public static final int NewWindow = 107;
    public static final int TitleChange = 113;
    public static final int FrameBeforeNavigate = 200;
    public static final int FrameNavigateComplete = 201;
    public static final int FrameNewWindow = 204;
    public static final int Quit = 103;
    public static final int WindowMove = 109;
    public static final int WindowResize = 110;
    public static final int WindowActivate = 111;
    public static final int PropertyChange = 112;
    public static final int BeforeNavigate2 = 250;
    public static final int NewWindow2 = 251;
    public static final int DocumentComplete = 259;
    public static final int DISPID_READYSTATE = -525;
    public static final int READYSTATE_UNINITIALIZED = 0;
    public static final int READYSTATE_LOADING = 1;
    public static final int READYSTATE_LOADED = 2;
    public static final int READYSTATE_INTERACTIVE = 3;
    public static final int READYSTATE_COMPLETE = 4;
    private boolean backwardEnabled;
    private boolean forwardEnabled;
    private OleAutomation oleObject;
    private HelpControlSite controlSite;
    private OleFrame controlFrame;
    private ArrayList documentCompleteListeners;
    private ArrayList commandStateChangedListeners;

    public WebBrowser(Composite parent) throws Exception {
        this.controlFrame = this.createOleFrame(parent);
        try {
            this.controlSite = new HelpControlSite((Composite)this.controlFrame, 0, "Shell.Explorer");
            this.oleObject = new OleAutomation((OleClientSite)this.controlSite);
            this.backwardEnabled = false;
            this.forwardEnabled = false;
            this.documentCompleteListeners = new ArrayList();
            this.commandStateChangedListeners = new ArrayList();
            this.controlSite.addEventListener(105, this);
            this.controlSite.addEventListener(259, this);
            this.controlSite.doVerb(-1);
            if (!IEHost.DEBUG) {
                this.setSilent();
            }
        }
        catch (Exception e) {
            String msg = WorkbenchResources.getString((String)"WE001");
            ErrorUtil.displayErrorDialog((String)msg, (Throwable)e);
            throw new HelpWorkbenchException(msg);
        }
    }

    public void addDocumentCompleteListener(IDocumentCompleteListener listener) {
        this.documentCompleteListeners.add(listener);
    }

    public void addCommandStateChangedListener(ICommandStateChangedListener listener) {
        this.commandStateChangedListeners.add(listener);
    }

    public void removeDocumentCompleteListener(IDocumentCompleteListener listener) {
        ((AbstractCollection)this.documentCompleteListeners).remove(listener);
    }

    public void removeCommandStateChangedListener(ICommandStateChangedListener listener) {
        ((AbstractCollection)this.commandStateChangedListeners).remove(listener);
    }

    public void setSilent() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"Silent"});
        if (rgdispid == null || rgdispid.length == 0) {
            return;
        }
        int dispIdMember = rgdispid[0];
        Variant silentVar = new Variant(true);
        this.oleObject.setProperty(dispIdMember, silentVar);
    }

    public int back() {
        if (!this.backwardEnabled) {
            return 1;
        }
        this.forwardEnabled = true;
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"GoBack"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleObject.invoke(dispIdMember);
        if (pVarResult == null || pVarResult.getType() == 0) {
            return 0;
        }
        return pVarResult.getInt();
    }

    public int copy() {
        int result = this.controlSite.queryStatus(12);
        if ((result & 2) == 2) {
            result = this.controlSite.exec(12, 0, null, null);
        }
        return result;
    }

    protected OleFrame createOleFrame(Composite parent) {
        if (this.controlFrame == null) {
            this.controlFrame = new OleFrame(parent, 0);
            this.controlFrame.setLayoutData((Object)new GridData(1808));
        }
        return this.controlFrame;
    }

    public void dispose() {
        int i;
        if (this.commandStateChangedListeners != null) {
            i = 0;
            while (i < this.commandStateChangedListeners.size()) {
                this.removeCommandStateChangedListener((ICommandStateChangedListener)this.commandStateChangedListeners.get(i--));
                ++i;
            }
        }
        if (this.documentCompleteListeners != null) {
            i = 0;
            while (i < this.documentCompleteListeners.size()) {
                this.removeDocumentCompleteListener((IDocumentCompleteListener)this.documentCompleteListeners.get(i--));
                ++i;
            }
        }
        if (this.oleObject != null) {
            this.oleObject.dispose();
        }
        this.oleObject = null;
        if (this.controlSite != null) {
            this.controlSite.dispose();
        }
        this.controlSite = null;
        if (this.controlFrame != null) {
            this.controlFrame.dispose();
        }
        this.controlFrame = null;
    }

    public int forward() {
        if (!this.forwardEnabled) {
            return 1;
        }
        this.backwardEnabled = true;
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"GoForward"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleObject.invoke(dispIdMember);
        if (pVarResult == null || pVarResult.getType() == 0) {
            return 0;
        }
        return pVarResult.getInt();
    }

    public Control getControl() {
        return this.controlFrame;
    }

    public String getLocationName() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"LocationName"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleObject.getProperty(dispIdMember);
        if (pVarResult == null) {
            return null;
        }
        return pVarResult.getString();
    }

    public String getLocationURL() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"LocationURL"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleObject.getProperty(dispIdMember);
        if (pVarResult == null) {
            return null;
        }
        return pVarResult.getString();
    }

    protected OleFrame getOleFrame() {
        return this.controlFrame;
    }

    public int getReadyState() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"ReadyState"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleObject.getProperty(dispIdMember);
        if (pVarResult == null || pVarResult.getType() == 0) {
            return -1;
        }
        return pVarResult.getInt();
    }

    public void handleEvent(OleEvent event) {
        switch (event.type) {
            case 105: {
                int command = 0;
                boolean enabled = false;
                Variant varResult = event.arguments[0];
                if (varResult != null) {
                    command = varResult.getInt();
                }
                if ((varResult = event.arguments[1]) != null) {
                    enabled = varResult.getBoolean();
                }
                if (command == 2) {
                    this.backwardEnabled = enabled;
                }
                if (command == 1) {
                    this.forwardEnabled = enabled;
                }
                ArrayList currentStateChangedListeners = new ArrayList(this.commandStateChangedListeners.size());
                currentStateChangedListeners.addAll(this.commandStateChangedListeners);
                Iterator it = currentStateChangedListeners.iterator();
                while (it.hasNext()) {
                    ICommandStateChangedListener listener = (ICommandStateChangedListener)it.next();
                    listener.commandStateChanged(this.backwardEnabled, this.forwardEnabled);
                }
                return;
            }
            case 259: {
                Variant varResult = event.arguments[1];
                String url = varResult.getString();
                ArrayList currentListeners = new ArrayList(this.documentCompleteListeners.size());
                currentListeners.addAll(this.documentCompleteListeners);
                Iterator it = currentListeners.iterator();
                while (it.hasNext()) {
                    IDocumentCompleteListener listener = (IDocumentCompleteListener)it.next();
                    listener.documentComplete(url);
                }
                return;
            }
        }
    }

    public int home() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"GoHome"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleObject.invoke(dispIdMember);
        if (pVarResult == null || pVarResult.getType() == 0) {
            return 0;
        }
        return pVarResult.getInt();
    }

    public int navigate(String url) {
        return this.navigate(this.oleObject, url);
    }

    protected int navigate(OleAutomation aOleAutomation, String url) {
        int[] rgdispidNamedArgs;
        Variant[] rgvarg;
        int[] rgdispid;
        int dispIdMember;
        Variant pVarResult;
        if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER) {
            System.out.println("WebBrowser: navigate to: " + url);
        }
        if ((pVarResult = aOleAutomation.invoke(dispIdMember = (rgdispid = aOleAutomation.getIDsOfNames(new String[]{"Navigate", "URL"}))[0], rgvarg = new Variant[]{new Variant(url)}, rgdispidNamedArgs = new int[]{rgdispid[1]})) == null || pVarResult.getType() == 0) {
            return 0;
        }
        return pVarResult.getInt();
    }

    public int print(boolean showPrintDialog) {
        return this.print(this.controlSite, showPrintDialog);
    }

    protected int print(HelpControlSite aControlSite, boolean promptuser) {
        int result = aControlSite.queryStatus(6);
        if ((result & 2) == 2) {
            result = promptuser ? aControlSite.exec(6, 1, null, null) : aControlSite.exec(6, 2, null, null);
        }
        if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER) {
            System.out.println("WebBrowser: exec returns: " + Integer.toString(result));
        }
        return result;
    }

    public void refresh() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"Refresh"});
        int dispIdMember = rgdispid[0];
        this.oleObject.invokeNoReply(dispIdMember);
    }

    public int search() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"GoSearch"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleObject.invoke(dispIdMember);
        if (pVarResult == null || pVarResult.getType() == 0) {
            return 0;
        }
        return pVarResult.getInt();
    }

    public void stop() {
        int[] rgdispid = this.oleObject.getIDsOfNames(new String[]{"Stop"});
        int dispIdMember = rgdispid[0];
        this.oleObject.invoke(dispIdMember);
    }
}

