/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.win32;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.help.ui.internal.WorkbenchHelpPlugin;
import org.eclipse.help.ui.internal.browser.win32.IEResources;
import org.eclipse.help.ui.internal.browser.win32.IEStore;
import org.eclipse.help.ui.internal.browser.win32.WebBrowser;
import org.eclipse.help.ui.internal.util.HelpWorkbenchException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class IEHost
implements Runnable {
    public static final String SYS_PROPERTY_DEBUG = "debug";
    public static final String SYS_PROPERTY_LOCALE = "locale";
    public static final String SYS_PROPERTY_INSTALLURL = "installURL";
    public static final String SYS_PROPERTY_PRODUCTIMAGEURL = "windowImage";
    public static final String SYS_PROPERTY_PRODUCTNAME = "name";
    public static final String SYS_PROPERTY_STATELOCATION = "stateLocation";
    public static final String CMD_CLOSE = "close";
    public static final String CMD_DISPLAY_URL = "displayURL";
    public static final String CMD_SET_LOCATION = "setLocation";
    public static final String CMD_SET_SIZE = "setSize";
    private static final String BROWSER_X = "browser.x";
    private static final String BROWSER_Y = "browser.y";
    private static final String BROWSER_WIDTH = "browser.w";
    private static final String BROWSER_HEIGTH = "browser.h";
    private static final String BROWSER_MAXIMIZED = "browser.maximized";
    public static boolean DEBUG = false;
    private static String locale;
    private static String installURL;
    private static String productName;
    private static String productImageURL;
    private static String stateLocation;
    private Display display;
    private Image shellImg;
    private Shell shell;
    private WebBrowser webBrowser;
    private IEResources ieResources;
    private IEStore store;
    int x;
    int y;
    int w;
    int h;
    private boolean closing = false;
    Thread inputReader;
    private boolean firstopenning = true;

    public IEHost(String installURL, String productImageURL) {
        if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER) {
            DEBUG = true;
        }
        locale = BootLoader.getNL();
        IEHost.installURL = installURL;
        IEHost.productImageURL = productImageURL;
        productName = "IN-PROCESS DEBUG MODE";
        stateLocation = WorkbenchHelpPlugin.getDefault().getStateLocation().toOSString();
        this.ieResources = new IEResources(locale, installURL);
        this.store = new IEStore(new File(stateLocation, ".iestore").toString());
        this.store.restore();
        this.createImages();
        this.createShell();
    }

    private IEHost() {
        this.display = new Display();
        this.ieResources = new IEResources(locale, installURL);
        this.store = new IEStore(new File(stateLocation, ".iestore").toString());
        this.store.restore();
        this.createImages();
        this.createShell();
        this.inputReader = new Thread(this);
        this.inputReader.setDaemon(true);
        this.inputReader.setName("IE Command Interpreter");
        this.inputReader.start();
    }

    private void runUI() {
        while (!this.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public static void main(String[] args) throws Throwable {
        String debug = System.getProperty(SYS_PROPERTY_DEBUG);
        if (debug != null && debug.length() >= 0) {
            DEBUG = true;
        }
        if ((locale = System.getProperty(SYS_PROPERTY_LOCALE)) == null || locale.length() <= 0) {
            System.err.println("Property locale not set, using default.");
            locale = Locale.getDefault().toString();
        }
        if ((installURL = System.getProperty(SYS_PROPERTY_INSTALLURL)) == null || installURL.length() <= 0) {
            System.err.println("Property installURL must be set.");
            return;
        }
        productImageURL = System.getProperty(SYS_PROPERTY_PRODUCTIMAGEURL);
        if (productImageURL == null) {
            System.err.println("Property windowImage must be set.");
            return;
        }
        productName = System.getProperty(SYS_PROPERTY_PRODUCTNAME);
        if (productName == null) {
            System.err.println("Property name must be set.");
            return;
        }
        stateLocation = System.getProperty(SYS_PROPERTY_STATELOCATION);
        if (stateLocation == null || stateLocation.length() <= 0) {
            System.err.println("Property stateLocation must be set.");
            return;
        }
        IEHost ie = new IEHost();
        ie.runUI();
        ie.dispose();
    }

    private void createImages() {
        block2: {
            try {
                this.shellImg = ImageDescriptor.createFromURL((URL)new URL(productImageURL)).createImage();
            }
            catch (MalformedURLException malformedURLException) {
                if ("".equals(productImageURL)) break block2;
                System.out.println("Invalid URL of product image.");
            }
        }
    }

    private void dispose() {
        if (this.shellImg != null) {
            this.shellImg.dispose();
        }
        if (this.webBrowser != null) {
            this.webBrowser.dispose();
        }
        if (!WorkbenchHelpPlugin.DEBUG_IE_ADAPTER_IN_PROCESS) {
            this.display.dispose();
        }
    }

    private void createShell() {
        this.shell = new Shell();
        if (this.shellImg != null) {
            this.shell.setImage(this.shellImg);
        }
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IEHost.this.closing = true;
                ((Hashtable)IEHost.this.store).put(IEHost.BROWSER_X, Integer.toString(IEHost.this.x));
                ((Hashtable)IEHost.this.store).put(IEHost.BROWSER_Y, Integer.toString(IEHost.this.y));
                ((Hashtable)IEHost.this.store).put(IEHost.BROWSER_WIDTH, Integer.toString(IEHost.this.w));
                ((Hashtable)IEHost.this.store).put(IEHost.BROWSER_HEIGTH, Integer.toString(IEHost.this.h));
                ((Hashtable)IEHost.this.store).put(IEHost.BROWSER_MAXIMIZED, new Boolean(IEHost.this.shell.getMaximized()).toString());
                IEHost.this.store.save();
                if (!WorkbenchHelpPlugin.DEBUG_IE_ADAPTER_IN_PROCESS && IEHost.this.inputReader.isAlive() && !WorkbenchHelpPlugin.DEBUG_IE_ADAPTER_IN_PROCESS) {
                    try {
                        IEHost.this.inputReader.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!IEHost.this.shell.getMaximized()) {
                    Point location = IEHost.this.shell.getLocation();
                    IEHost.this.x = location.x;
                    IEHost.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!IEHost.this.shell.getMaximized()) {
                    Point size = IEHost.this.shell.getSize();
                    IEHost.this.w = size.x;
                    IEHost.this.h = size.y;
                }
            }
        });
        this.shell.setText(IEResources.getString("browserTitle", productName));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.shell.setLayout((Layout)layout);
        this.createContents((Composite)this.shell);
        this.x = this.store.getInt(BROWSER_X);
        this.y = this.store.getInt(BROWSER_Y);
        this.w = this.store.getInt(BROWSER_WIDTH);
        this.h = this.store.getInt(BROWSER_HEIGTH);
        if (this.w == 0 || this.h == 0) {
            this.w = 800;
            this.h = 600;
        } else {
            this.shell.setLocation(this.x, this.y);
        }
        this.shell.setSize(this.w, this.h);
        if (this.store.getBoolean(BROWSER_MAXIMIZED)) {
            this.shell.setMaximized(true);
        }
        this.shell.open();
    }

    private Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        try {
            this.webBrowser = new WebBrowser(composite);
            int i = 0;
            while (i < 20 && this.webBrowser.getReadyState() != 4) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            if (this.webBrowser.getReadyState() != 4) {
                throw new HelpWorkbenchException(IEResources.getString("WE034"));
            }
            this.webBrowser.navigate("about:blank");
        }
        catch (Exception e) {
            System.err.println(IEResources.getString("WE027", e.getMessage()));
            e.printStackTrace();
        }
        return composite;
    }

    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            while (!this.closing && (line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                this.executeCommand(line);
                while (!this.closing && System.in.available() <= 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println(IEResources.getString("WE026", e.getMessage()));
            return;
        }
    }

    public void executeCommand(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        String command = tokenizer.nextToken();
        String[] pars = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < pars.length) {
            pars[i] = tokenizer.nextToken();
            ++i;
        }
        if (CMD_DISPLAY_URL.equalsIgnoreCase(command)) {
            if (pars.length >= 1 && pars[0] != null) {
                if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER_IN_PROCESS) {
                    this.webBrowser.navigate(pars[0]);
                    if (this.firstopenning) {
                        this.firstopenning = false;
                    } else {
                        this.shell.setVisible(false);
                        this.shell.setMinimized(true);
                    }
                    this.shell.setVisible(true);
                    this.shell.setMinimized(false);
                    this.shell.moveAbove(null);
                    this.shell.forceActive();
                    return;
                }
                this.display.syncExec((Runnable)new DisplayURLCommand(pars[0]));
                this.display.syncExec((Runnable)new MakeVisible());
            }
        } else if (CMD_SET_LOCATION.equalsIgnoreCase(command)) {
            if (pars.length >= 2 && pars[0] != null && pars[1] != null) {
                try {
                    this.display.syncExec((Runnable)new SetLocationCommand(Integer.parseInt(pars[0]), Integer.parseInt(pars[1])));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (CMD_SET_SIZE.equalsIgnoreCase(command)) {
            if (pars.length >= 2 && pars[0] != null && pars[1] != null) {
                try {
                    this.display.syncExec((Runnable)new SetSizeCommand(Integer.parseInt(pars[0]), Integer.parseInt(pars[1])));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            if (CMD_CLOSE.equalsIgnoreCase(command)) {
                if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER_IN_PROCESS) {
                    this.shell.dispose();
                    return;
                }
                this.display.syncExec((Runnable)new CloseCommand());
                return;
            }
            System.err.println(IEResources.getString("WE028", command));
        }
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    class SetLocationCommand
    implements Runnable {
        int x;
        int y;

        public SetLocationCommand(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void run() {
            IEHost.this.shell.setLocation(this.x, this.y);
        }
    }

    class SetSizeCommand
    implements Runnable {
        int x;
        int y;

        public SetSizeCommand(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void run() {
            IEHost.this.shell.setSize(this.x, this.y);
        }
    }

    class CloseCommand
    implements Runnable {
        CloseCommand() {
        }

        public void run() {
            IEHost.this.shell.dispose();
        }
    }

    class DisplayURLCommand
    implements Runnable {
        String url;

        public DisplayURLCommand(String url) {
            this.url = url;
        }

        public void run() {
            IEHost.this.webBrowser.navigate(this.url);
        }
    }

    class MakeVisible
    implements Runnable {
        MakeVisible() {
        }

        public void run() {
            if (IEHost.this.firstopenning) {
                IEHost.this.firstopenning = false;
            } else {
                IEHost.this.shell.setVisible(false);
                IEHost.this.shell.setMinimized(true);
            }
            IEHost.this.shell.setVisible(true);
            IEHost.this.shell.setMinimized(false);
            IEHost.this.shell.moveAbove(null);
            IEHost.this.shell.forceActive();
        }
    }
}

