/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.win32;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.StreamConsumer;
import org.eclipse.help.internal.util.TString;
import org.eclipse.help.ui.internal.WorkbenchHelpPlugin;
import org.eclipse.help.ui.internal.browser.win32.IEHost;
import org.eclipse.help.ui.internal.util.WorkbenchResources;

public class IEBrowserAdapter
implements IBrowser,
Runnable {
    private static final String PLUGIN_ID_SWT = "org.eclipse.swt";
    private static final String IE_CLASS = "org.eclipse.help.ui.internal.browser.win32.IEHost";
    PrintWriter commandWriter;
    boolean launched = false;
    private static String[] cmdarray;
    String cmd;
    String installURL = "";
    IEHost ieHost;

    public IEBrowserAdapter() {
        String executable;
        if (cmdarray != null) {
            return;
        }
        String vm = System.getProperty("java.vm.name");
        String string = executable = "J9".equals(vm) ? "j9" : "java";
        if ("win32".equals(BootLoader.getOS())) {
            executable = String.valueOf(executable) + "w.exe";
        }
        String javaInstallDir = String.valueOf(System.getProperty("java.home")) + File.separator + "bin";
        String program = String.valueOf(javaInstallDir) + File.separator + executable;
        String locale = BootLoader.getNL();
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        try {
            URL instURL = Platform.resolve((URL)WorkbenchHelpPlugin.getDefault().getDescriptor().getInstallURL());
            this.installURL = instURL.toExternalForm();
        }
        catch (IOException ioe) {
            WorkbenchHelpPlugin.logError((String)WorkbenchResources.getString((String)"WE022"), (Throwable)ioe);
            return;
        }
        String libraryPath = String.valueOf(javaInstallDir) + ";" + this.getPath(PLUGIN_ID_SWT) + System.getProperty("java.library.path");
        libraryPath = TString.change((String)libraryPath, (String)"\"", (String)"");
        if (libraryPath.charAt(libraryPath.length() - 1) != ';') {
            libraryPath = String.valueOf(libraryPath) + ";";
        }
        String classPath = this.getClassPath("org.eclipse.help.ui");
        String stateLocation = WorkbenchHelpPlugin.getDefault().getStateLocation().toString();
        String imageURL = this.getProductImageURL();
        if (imageURL == null) {
            imageURL = "";
        }
        cmdarray = WorkbenchHelpPlugin.DEBUG_IE_ADAPTER ? new String[]{program, "-Dlocale=" + locale, "-DinstallURL=" + this.installURL, "-DwindowImage=" + imageURL, "-Dname=" + this.getProductName(), "-DstateLocation=" + stateLocation, "-Ddebug=true", "-Djava.library.path=" + libraryPath, "-cp", classPath, IE_CLASS} : new String[]{program, "-Dlocale=" + locale, "-DinstallURL=" + this.installURL, "-DwindowImage=" + imageURL, "-Dname=" + this.getProductName(), "-DstateLocation=" + stateLocation, "-Djava.library.path=" + libraryPath, "-cp", classPath, IE_CLASS};
        this.cmd = "\"" + cmdarray[0] + "\"";
        int i = 1;
        while (i < cmdarray.length) {
            this.cmd = String.valueOf(this.cmd) + " \"" + cmdarray[i] + "\"";
            ++i;
        }
        if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER) {
            System.out.println("IEBrowserAdapter launch command is: " + this.cmd);
        }
    }

    public void close() {
        this.sendCommand("close");
    }

    public void displayURL(String url) {
        this.sendCommand("displayURL " + url);
    }

    public boolean isCloseSupported() {
        return true;
    }

    public boolean isSetLocationSupported() {
        return true;
    }

    public boolean isSetSizeSupported() {
        return true;
    }

    public void setLocation(int x, int y) {
        this.sendCommand("setLocation " + x + " " + y);
    }

    public void setSize(int width, int height) {
        this.sendCommand("setSize " + width + " " + height);
    }

    public void run() {
        Process pr;
        try {
            pr = Runtime.getRuntime().exec(cmdarray);
        }
        catch (IOException e) {
            WorkbenchHelpPlugin.logError((String)WorkbenchResources.getString((String)"WE024", (String)this.cmd), (Throwable)e);
            Object pr2 = null;
            this.launched = true;
            return;
        }
        StreamConsumer ieOutConsumer = new StreamConsumer(pr.getInputStream());
        ieOutConsumer.setName("Internet Explorer adapter output reader");
        ieOutConsumer.start();
        StreamConsumer ieErrConsumer = new StreamConsumer(pr.getErrorStream());
        ieErrConsumer.setName("Internet Explorer adapter error reader");
        ieErrConsumer.start();
        this.commandWriter = new PrintWriter(pr.getOutputStream(), true);
        this.launched = true;
        try {
            pr.waitFor();
        }
        catch (InterruptedException e) {
            WorkbenchHelpPlugin.logError((String)WorkbenchResources.getString((String)"WE023"), (Throwable)e);
        }
        if (this.commandWriter != null) {
            PrintWriter w = this.commandWriter;
            this.commandWriter = null;
            w.close();
        }
    }

    private void sendCommand(String command) {
        if (cmdarray == null) {
            return;
        }
        if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER_IN_PROCESS) {
            if (this.ieHost == null || this.ieHost.isDisposed()) {
                this.ieHost = new IEHost(this.installURL, this.getProductImageURL());
            }
            if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER) {
                System.out.println("Sending the following command to the IE browser (in process): " + command);
            }
            this.ieHost.executeCommand(command);
            return;
        }
        if (this.commandWriter == null) {
            if ("close".equals(command)) {
                return;
            }
            new Thread(this).start();
            while (!this.launched) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    this.launched = false;
                    return;
                }
            }
            this.launched = false;
        }
        try {
            this.commandWriter.println(command);
            if (WorkbenchHelpPlugin.DEBUG_IE_ADAPTER) {
                System.out.println("Sending the following command to the IE browser process: " + command);
            }
        }
        catch (Exception exception) {
            WorkbenchHelpPlugin.logWarning((String)WorkbenchResources.getString((String)"WW003"));
        }
    }

    private String getClassPath(String pluginID) {
        HashSet<String> pluginIDs = new HashSet<String>();
        this.addRequiredPluginIDs(pluginID, pluginIDs);
        pluginIDs.add(pluginID);
        HashSet<String> cpaths = new HashSet<String>();
        Iterator it = pluginIDs.iterator();
        while (it.hasNext()) {
            URLClassLoader cl = (URLClassLoader)Platform.getPlugin((String)((String)it.next())).getDescriptor().getPluginClassLoader();
            URL[] urls = cl.getURLs();
            int i = 0;
            while (i < urls.length) {
                cpaths.add(urls[i].getFile());
                ++i;
            }
        }
        StringBuffer classPath = new StringBuffer(4096);
        Iterator i = cpaths.iterator();
        while (i.hasNext()) {
            String cp = (String)i.next();
            if (cp.length() <= 0) continue;
            classPath.append(cp);
            classPath.append(File.pathSeparator);
        }
        return classPath.toString();
    }

    private void addRequiredPluginIDs(String pluginID, Collection IDs) {
        IPluginPrerequisite[] preqs = Platform.getPlugin((String)pluginID).getDescriptor().getPluginPrerequisites();
        int i = 0;
        while (i < preqs.length) {
            IDs.add(preqs[i].getUniqueIdentifier());
            this.addRequiredPluginIDs(preqs[i].getUniqueIdentifier(), IDs);
            ++i;
        }
    }

    private String getPath(String pluginID) {
        PluginFragmentModel[] fragmentModels;
        String path = "";
        ArrayList<URL> installURLs = new ArrayList<URL>();
        IPluginDescriptor pluginDescriptor = Platform.getPlugin((String)pluginID).getDescriptor();
        URL pluginInstallURL = pluginDescriptor.getInstallURL();
        installURLs.add(pluginInstallURL);
        if (pluginDescriptor instanceof PluginDescriptorModel && (fragmentModels = ((PluginDescriptorModel)pluginDescriptor).getFragments()) != null) {
            int f = 0;
            while (f < fragmentModels.length) {
                String location = fragmentModels[f].getLocation();
                try {
                    URL fragInstallURL = new URL(location);
                    installURLs.add(fragInstallURL);
                }
                catch (MalformedURLException malformedURLException) {}
                ++f;
            }
        }
        Iterator it = installURLs.iterator();
        while (it.hasNext()) {
            URL installURL = (URL)it.next();
            try {
                installURL = Platform.resolve((URL)installURL);
            }
            catch (IOException iOException) {
                continue;
            }
            File installFile = new File(installURL.getFile());
            String[] variants = IEBrowserAdapter.buildLibraryVariants();
            int v = 0;
            while (v < variants.length) {
                path = String.valueOf(path) + new File(installFile, variants[v]).getAbsolutePath() + File.pathSeparator;
                ++v;
            }
        }
        return path;
    }

    private static String[] buildLibraryVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + BootLoader.getWS() + "/");
        result.add("os/" + BootLoader.getOS() + "/" + System.getProperty("os.arch") + "/");
        result.add("os/" + BootLoader.getOS() + "/");
        String nl = BootLoader.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private String getProductImageURL() {
        IPlatformConfiguration c = BootLoader.getCurrentPlatformConfiguration();
        String primaryFeatureId = c.getPrimaryFeatureIdentifier();
        IPluginDescriptor pfd = Platform.getPluginRegistry().getPluginDescriptor(primaryFeatureId);
        if (pfd == null) {
            return null;
        }
        URL aboutURL = pfd.find((IPath)new Path("about.ini"));
        if (aboutURL == null) {
            return null;
        }
        try {
            aboutURL = Platform.resolve((URL)aboutURL);
            Properties aboutProps = new Properties();
            aboutProps.load(aboutURL.openStream());
            String windowIconPathStr = (String)((Hashtable)aboutProps).get("windowImage");
            if (windowIconPathStr == null) {
                return null;
            }
            Path windowIconPath = new Path(windowIconPathStr);
            HashMap<String, String> override = new HashMap<String, String>(1);
            override.put("$nl$", BootLoader.getNL());
            URL windowIconURL = pfd.find((IPath)windowIconPath, override);
            if (windowIconURL == null) {
                return null;
            }
            windowIconURL = Platform.resolve((URL)windowIconURL);
            return windowIconURL.toString();
        }
        catch (IOException ioe) {
            WorkbenchHelpPlugin.logError((String)WorkbenchResources.getString((String)"WE029"), (Throwable)ioe);
            return null;
        }
    }

    private String getProductName() {
        IPlatformConfiguration c = BootLoader.getCurrentPlatformConfiguration();
        String primaryFeatureId = c.getPrimaryFeatureIdentifier();
        IPluginDescriptor pfd = Platform.getPluginRegistry().getPluginDescriptor(primaryFeatureId);
        if (pfd == null) {
            return "";
        }
        return pfd.getLabel();
    }
}

