/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.EjbQlException;
import com.sap.ejbql.SchemaManager;
import com.sap.ejbql.tree.AbstractSchemaType;
import com.sap.ejbql.tree.Type;
import java.util.HashMap;

public class TypeManager {
    private HashMap javaTypes;
    private HashMap abstractSchemaTypes;
    SchemaManager sm;

    public TypeManager(SchemaManager sm) {
        Type[] predefined = Type.getBuiltinTypes();
        this.javaTypes = new HashMap(predefined.length * 2);
        int i = 0;
        while (i < predefined.length) {
            this.javaTypes.put(predefined[i].name, predefined[i]);
            ++i;
        }
        this.abstractSchemaTypes = new HashMap(20);
        this.sm = sm;
    }

    public boolean hasJavaType(String name) {
        if (this.javaTypes.get(name) == null) {
            if (!this.sm.classExists(name)) {
                return false;
            }
            this.javaTypes.put(name, new Type(name));
        }
        return true;
    }

    public Type getJavaType(String name) {
        if (!this.hasJavaType(name)) {
            throw new EjbQlException("There is no such type '" + name + "'");
        }
        return (Type)this.javaTypes.get(name);
    }

    public boolean hasAbstractSchemaType(String name) {
        if (this.abstractSchemaTypes.get(name) == null) {
            if (!this.sm.beanExists(name)) {
                return false;
            }
            this.abstractSchemaTypes.put(name, new AbstractSchemaType(name, this));
        }
        return true;
    }

    public AbstractSchemaType getAbstractSchemaType(String name) {
        if (!this.hasAbstractSchemaType(name)) {
            throw new EjbQlException("Abstract Schema Type '" + name + "' doesn't exist");
        }
        return (AbstractSchemaType)this.abstractSchemaTypes.get(name);
    }

    public boolean hasType(String name) {
        return this.hasAbstractSchemaType(name) || this.hasJavaType(name);
    }

    public Type getType(String name) {
        if (this.hasAbstractSchemaType(name)) {
            return this.getAbstractSchemaType(name);
        }
        if (!this.hasJavaType(name)) {
            throw new EjbQlException("There is no such type '" + name + "'");
        }
        String asName = this.sm.getBeanFromLocal(name);
        if (asName == null) {
            asName = this.sm.getBeanFromRemote(name);
        }
        if (asName == null) {
            return this.getJavaType(name);
        }
        return this.getAbstractSchemaType(asName);
    }
}

