/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.tree.NumericType;

public class Type {
    String name;
    boolean primitive;
    public static final Type _boolean_ = new Type("boolean", true);
    public static final Type Boolean = new Type("java.lang.Boolean");
    public static final Type String = new Type("java.lang.String");
    public static final Type Date = new Type("java.util.Date");
    public static final Type STRING = String;
    public static final Type DATE = Date;
    public static final Type INT = NumericType._long_;
    public static final Type DOUBLE = NumericType._double_;
    public static final Type DECIMAL = NumericType.BigDecimal;
    public static final Type BOOL = _boolean_;
    public static final Type UNKNOWN = new Type("<unknown>");

    Type(String name, boolean isPrimitive) {
        this.name = name;
        this.primitive = isPrimitive;
    }

    Type(String name) {
        this(name, false);
    }

    static Type[] getBuiltinTypes() {
        Type[] directTypes = new Type[]{_boolean_, Boolean, Date, String};
        Type[] numericTypes = NumericType.getBuiltinTypes();
        Type[] result = new Type[directTypes.length + numericTypes.length];
        System.arraycopy(directTypes, 0, result, 0, directTypes.length);
        System.arraycopy(numericTypes, 0, result, directTypes.length, numericTypes.length);
        return result;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isOrdered() {
        return this.isString() || this.isDate() || this.isNumeric() || this.isCharacter();
    }

    public boolean isDate() {
        return this == DATE;
    }

    public boolean isBoolean() {
        return this == _boolean_ || this == Boolean;
    }

    public boolean isString() {
        return this == STRING;
    }

    public boolean isCharacter() {
        return false;
    }

    public boolean isEntityBean() {
        return false;
    }

    public boolean isDependentObject() {
        return this != UNKNOWN && !this.isBoolean() && !this.isString() && !this.isDate() && !this.isNumeric() && !this.isEntityBean();
    }

    public boolean isConvertibleTo(Type t) {
        return this == t;
    }

    public String toString() {
        return this.name;
    }
}

