/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.ErrorCollector;
import com.sap.ejbql.Position;
import com.sap.ejbql.tree.TreeBuildException;
import java.util.ArrayList;

public abstract class TreeNode {
    Position pos;
    private State state = State.INITIAL;
    private ArrayList errors;
    protected ErrorCollector errColl;

    protected TreeNode(TreeNode node) {
        this(node == null ? null : node.pos, node == null ? null : node.errColl);
    }

    protected TreeNode(Position p, ErrorCollector e) {
        this.pos = p;
        this.errColl = e;
        this.errors = new ArrayList();
    }

    protected void error(String str) {
        this.error(this.pos, str);
    }

    protected void error(Position pos, String str) {
        this.error(pos, new TreeBuildException(str));
    }

    protected void error(TreeBuildException e) {
        this.error(this.pos, e);
    }

    protected void error(Position pos, TreeBuildException e) {
        this.state = State.FAULTY;
        this.errors.add(e);
        if (this.errColl == null) {
            throw e;
        }
        this.errColl.logError(pos, e, this);
    }

    public Position getPosition() {
        return this.pos;
    }

    public static class State {
        public static final State INITIAL = new State("<initial>");
        public static final State FAULTY = new State("<faulty>");
        public static final State SOUND = new State("<sound>");
        private String printableRepresentation;

        private State(String val) {
            this.printableRepresentation = val;
        }

        public String toString() {
            return this.printableRepresentation;
        }
    }
}

