/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ejbql.tree;

import com.sap.ejbql.tree.IdVarDeclaration;
import com.sap.ejbql.tree.PathExpression;
import com.sap.ejbql.tree.Select;
import com.sap.ejbql.tree.Type;

public class SelectPath
extends Select {
    PathExpression path;

    public SelectPath(PathExpression path) {
        this(path, false);
    }

    public SelectPath(PathExpression path, boolean distinct) {
        super(path);
        if (path == null) {
            throw new IllegalArgumentException("'path' not defined");
        }
        this.path = path;
        this.distinct = distinct;
        if (path.type != Type.UNKNOWN) {
            this.checkPath();
        }
    }

    public PathExpression getPath() {
        return this.path;
    }

    public void check(IdVarDeclaration[] declarations) {
        this.path.check(declarations);
        this.checkPath();
    }

    public void checkPath() {
        if (!this.path.isSingleValued()) {
            this.error(this.path.pos, "Path '" + this.path + "' is not single-valued");
        }
        this.returnType = this.path.type;
    }

    public String toString() {
        return (this.distinct ? "DISTINCT " : "") + this.path;
    }
}

